/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.dd;

import com.ericsson.ssa.dd.ModuleDeployException;
import com.ericsson.ssa.dd.SecurityConstraint;
import com.ericsson.ssa.dd.SecurityRole;
import com.ericsson.ssa.dd.SecurityRoleReference;
import com.ericsson.ssa.dd.Servlet;
import com.ericsson.ssa.dd.SipApplication;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipApplicationValidator {
    public static final String SIP_ARCHIVE_CLASSES_BASE_DIR = "WEB-INF/classes";

    private SipApplicationValidator() {
    }

    public static void validateSipDeploymentDescriptor(JarFile moduleJarFile, SipApplication sipApplication) throws ModuleDeployException {
        SipApplicationValidator.validateServletClass(moduleJarFile, sipApplication);
        SipApplicationValidator.validateSecurityConstraintRoles(sipApplication);
        SipApplicationValidator.validateSecurityRoleReferences(sipApplication);
        SipApplicationValidator.validateIcons(moduleJarFile, sipApplication);
    }

    private static void validateSecurityRoleReferences(SipApplication sipApplication) throws ModuleDeployException {
        StringBuffer missingRoles = new StringBuffer();
        Map<String, SecurityRole> securityRoles = sipApplication.getSecurityRoles();
        Map<String, Servlet> servlets = sipApplication.getServlets();
        for (String key : servlets.keySet()) {
            Servlet servlet = servlets.get(key);
            Collection<SecurityRoleReference> securityRoleReferences = servlet.getSecurityRoleReferences();
            Iterator<SecurityRoleReference> roleIterator = securityRoleReferences.iterator();
            while (roleIterator.hasNext()) {
                String role = roleIterator.next().getRoleLink();
                if (securityRoles.get(role) != null || role.equals("*")) continue;
                missingRoles.append(role);
                missingRoles.append("\n");
            }
        }
        if (missingRoles.toString().trim().length() > 0) {
            throw new ModuleDeployException("The following security role references are undefined in the security roles:\n" + missingRoles);
        }
    }

    private static void validateSecurityConstraintRoles(SipApplication sipApplication) throws ModuleDeployException {
        StringBuffer missingRoles = new StringBuffer();
        Map<String, SecurityRole> securityRoles = sipApplication.getSecurityRoles();
        Collection<SecurityConstraint> securityConstraints = sipApplication.getSecurityConstraints();
        Iterator<SecurityConstraint> securityIterator = securityConstraints.iterator();
        while (securityIterator.hasNext()) {
            Collection<String> roleNames = securityIterator.next().getAuthorizationConstraintRoleNames();
            for (String role : roleNames) {
                if (securityRoles.get(role) != null || role.equals("*")) continue;
                missingRoles.append(role);
                missingRoles.append("\n");
            }
        }
        if (missingRoles.toString().trim().length() > 0) {
            throw new ModuleDeployException("The following security constraint role names are undefined in the security roles:\n" + missingRoles);
        }
    }

    private static void validateServletClass(JarFile jarFile, SipApplication sipApplication) throws ModuleDeployException {
        HashSet<String> servletClasses = new HashSet<String>();
        Map<String, Servlet> servlets = sipApplication.getServlets();
        for (String key : servlets.keySet()) {
            Servlet servlet = servlets.get(key);
            String servletClass = servlet.getServletClass();
            StringBuffer servletPath = new StringBuffer(SIP_ARCHIVE_CLASSES_BASE_DIR);
            servletPath.append("/");
            servletPath.append(servletClass.replace('.', '/'));
            servletPath.append(".class");
            servletClasses.add(servletPath.toString());
        }
        String names = SipApplicationValidator.getNameOfFilesNotInJar(jarFile, servletClasses);
        if (names.trim().length() > 0) {
            throw new ModuleDeployException("The following servlet files are missing from the archive:\n" + names);
        }
    }

    private static void validateIcons(JarFile jarFile, SipApplication sipApplication) throws ModuleDeployException {
        HashSet<String> icons = new HashSet<String>();
        icons.add(sipApplication.getSmallIcon());
        icons.add(sipApplication.getLargeIcon());
        Map<String, Servlet> servlets = sipApplication.getServlets();
        for (String key : servlets.keySet()) {
            Servlet servlet = servlets.get(key);
            icons.add(servlet.getSmallIcon());
            icons.add(servlet.getLargeIcon());
        }
        String names = SipApplicationValidator.getNameOfFilesNotInJar(jarFile, icons);
        if (names.trim().length() > 0) {
            throw new ModuleDeployException("The following icon files are missing from the archive:\n" + names);
        }
    }

    private static String getNameOfFilesNotInJar(JarFile jarFile, Collection<String> fileNames) {
        StringBuffer missingNames = new StringBuffer();
        for (String name : fileNames) {
            if (name.charAt(0) == '/') {
                name = name.substring(1, name.length());
            }
            if (name == null || name.trim().length() == 0 || jarFile.getJarEntry(name) != null) continue;
            missingNames.append(name);
            missingNames.append("\n");
        }
        return missingNames.toString();
    }
}

