/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.router;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationRouter;
import javax.servlet.sip.SipApplicationRouterInfo;
import javax.servlet.sip.SipApplicationRoutingDirective;
import javax.servlet.sip.SipServletReadOnlyRequest;
import javax.servlet.sip.URI;
import javax.servlet.sip.annotation.SipFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphabeticalRouter
implements SipApplicationRouter {
    private SortedSet<String> deployedApps = new TreeSet<String>();
    @SipFactory
    private javax.servlet.sip.SipFactory sipFactory;
    private Logger log = Logger.getLogger("SipContainer");

    public void init(List<String> applications) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Init : Deployed Apps -> " + applications);
        }
        this.deployedApps = new TreeSet<String>(applications);
    }

    public void destroy() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Destroy");
        }
        this.deployedApps = null;
    }

    public void deployedApplications(List<String> applications) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "DeployedApplications");
        }
        for (String app : applications) {
            if (!this.deployedApps.contains(app)) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "Adding new Application : " + app);
                }
                this.deployedApps.add(app);
                continue;
            }
            if (!this.log.isLoggable(Level.FINE)) continue;
            this.log.log(Level.FINE, "Upgraded Application : " + app);
        }
    }

    public void undeployedApplications(List<String> applications) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "UndeployedApplications");
        }
        for (String app : applications) {
            boolean removed = this.deployedApps.remove(app);
            if (!this.log.isLoggable(Level.FINE)) continue;
            this.log.log(Level.FINE, "Removed Application : " + app + " = " + removed);
        }
    }

    public SipApplicationRouterInfo getNextApplication(SipServletReadOnlyRequest initialRequest, boolean lastError, SipApplicationRoutingDirective directive, Object stateInfo) {
        SipApplicationRouterInfo info = null;
        URI subscriberURI = null;
        String app = null;
        if (stateInfo == null) {
            if (this.deployedApps != null) {
                try {
                    app = this.deployedApps.first();
                }
                catch (RuntimeException re) {}
            }
        } else {
            boolean match = false;
            for (String x : this.deployedApps) {
                if (match) {
                    app = x;
                    break;
                }
                if (!stateInfo.equals(x)) continue;
                match = true;
            }
        }
        if (app == null) {
            Address target = null;
            try {
                target = initialRequest.getAddressHeader("Route");
                if (target == null) {
                    target = this.sipFactory.createAddress(initialRequest.getRequestURI());
                }
            }
            catch (ServletParseException ignore) {
                // empty catch block
            }
            info = new SipApplicationRouterInfo(target);
        } else {
            SessionCaseRegion region = this.getSessionCase(initialRequest.getPoppedRoute());
            info = new SipApplicationRouterInfo(app, subscriberURI, app, region.name());
        }
        return info;
    }

    private SessionCaseRegion getSessionCase(Address poppedRoute) {
        if (poppedRoute == null) {
            return SessionCaseRegion.UNKNOWN;
        }
        String sessionCase = poppedRoute.getParameter("call");
        if ("orig".equalsIgnoreCase(sessionCase)) {
            return SessionCaseRegion.ORIGINATING;
        }
        if ("terminating_registered".equalsIgnoreCase(sessionCase)) {
            return SessionCaseRegion.TERMINATING_REG;
        }
        if ("terminating_unregistered".equalsIgnoreCase(sessionCase)) {
            return SessionCaseRegion.TERMINATING_UNREG;
        }
        return SessionCaseRegion.UNKNOWN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SessionCaseRegion {
        UNKNOWN,
        ORIGINATING,
        TERMINATING_REG,
        TERMINATING_UNREG;

    }
}

