/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.AddressImpl;
import com.ericsson.ssa.sip.SipFactoryImpl;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;

public class AddressOrValue
implements Cloneable {
    public String value = null;
    public Address address = null;

    private AddressOrValue() {
    }

    public AddressOrValue(String value) {
        if (value == null) {
            throw new NullPointerException("Requires proper value");
        }
        this.value = value;
    }

    public AddressOrValue(Address address) {
        if (address == null) {
            throw new NullPointerException("Requires proper address");
        }
        this.address = address;
    }

    public Object clone() {
        AddressOrValue clone = new AddressOrValue();
        clone.value = this.value;
        if (this.address != null) {
            clone.address = (Address)((AddressImpl)this.address).clone(true, true);
        }
        return clone;
    }

    public Address getAddressValue() throws ServletParseException {
        if (this.address == null && this.value != null) {
            this.address = SipFactoryImpl.getInstance().createAddress(this.value);
            this.value = null;
        }
        return this.address;
    }

    public void setAddressValue(Address address) {
        this.address = address;
        this.value = null;
    }

    public String toString() {
        if (this.address != null) {
            return this.address.toString();
        }
        if (this.value != null) {
            return this.value;
        }
        return "";
    }

    public void setValue(String value) {
        this.address = null;
        this.value = value;
    }
}

