/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class Ascii7String {
    private static Charset charset7bit = Charset.forName("US-ASCII");
    private byte[] myData;

    public Ascii7String(String original) {
        byte[] orgBytes = Ascii7String.getBytes(original);
        int size = orgBytes.length;
        this.myData = new byte[size];
        System.arraycopy(orgBytes, 0, this.myData, 0, orgBytes.length);
    }

    Ascii7String(byte[] bytes) {
        this.myData = bytes;
    }

    public Ascii7String(byte[] bytes, int offset, int length, String charset) throws UnsupportedEncodingException {
        this(new String(bytes, offset, length, charset));
    }

    public Ascii7String(StringBuilder builder) {
        this(builder.toString());
    }

    public int length() {
        return this.myData.length;
    }

    public String toString() {
        try {
            return new String(this.myData, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getBytes() {
        return this.myData;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof Ascii7String) {
            Ascii7String anotherString = (Ascii7String)anObject;
            int n = this.length();
            if (n == anotherString.length()) {
                byte[] v1 = this.myData;
                byte[] v2 = anotherString.getBytes();
                while (n-- != 0) {
                    if (v1[n] == v2[n]) continue;
                    return false;
                }
                return true;
            }
        } else if (anObject instanceof String) {
            return new Ascii7String((String)anObject).equals(this);
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.myData.length; ++i) {
            h = 31 * h + this.myData[i];
        }
        return h;
    }

    public boolean equalsIgnoreCase(Ascii7String anotherString) {
        return this == anotherString ? true : anotherString != null && anotherString.myData.length == this.myData.length && this.regionMatches(true, 0, anotherString, 0, this.myData.length);
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, Ascii7String other, int ooffset, int len) {
        byte[] ta = this.myData;
        byte[] pa = other.myData;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)this.myData.length - (long)len || (long)ooffset > (long)other.myData.length - (long)len) {
            return false;
        }
        while (len-- > 0) {
            int u2;
            int u1;
            byte char2;
            byte char1;
            if ((char1 = ta[toffset++]) == (char2 = pa[ooffset++]) || ignoreCase && ((u1 = Character.toUpperCase(char1)) == (u2 = Character.toUpperCase(char2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2))) continue;
            return false;
        }
        return true;
    }

    public static byte[] getBytes(String str) {
        char[] ca = str.toCharArray();
        byte[] ba = new byte[ca.length];
        if (ca.length == 0) {
            return ba;
        }
        CharsetEncoder ce = charset7bit.newEncoder();
        ce.reset();
        ByteBuffer bb = ByteBuffer.wrap(ba);
        CharBuffer cb = CharBuffer.wrap(ca, 0, ca.length);
        try {
            CoderResult cr = ce.encode(cb, bb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = ce.flush(bb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
        return ba;
    }
}

