/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.PathNode;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.SipSessionBase;
import com.ericsson.ssa.sip.UA;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.UAMode;
import javax.servlet.sip.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class B2buaHelperImpl
implements B2buaHelper {
    private Logger _log = Logger.getLogger("SipContainer");
    private SipServletRequestImpl _originalRequest = null;
    private final SipFactory _sf;

    public B2buaHelperImpl(SipServletRequestImpl req) {
        this._sf = req.getApplicationSessionImpl().getServletDispatcher().getSipFactory();
        if (req.isInitial()) {
            this._originalRequest = req;
        }
    }

    public SipServletRequest createRequest(SipServletRequest origRequest, boolean linkedSessions, Map<String, Set<String>> headerMap) throws IllegalArgumentException, TooManyHopsException {
        if (origRequest == null) {
            throw new NullPointerException();
        }
        if (!origRequest.isInitial()) {
            throw new IllegalStateException();
        }
        if (origRequest.getMaxForwards() == 0) {
            throw new TooManyHopsException();
        }
        if (headerMap != null && !headerMap.isEmpty() && this.isSystemHeader(headerMap.keySet(), (SipServletRequestImpl)origRequest, true)) {
            throw new IllegalArgumentException();
        }
        SipServletRequest copiedReq = this._sf.createRequest(origRequest, false);
        if (headerMap != null && !headerMap.isEmpty()) {
            Iterator<String> names = headerMap.keySet().iterator();
            Iterator<Set<String>> values = headerMap.values().iterator();
            while (names.hasNext()) {
                this.setHeader(names.next(), values.next(), (SipServletRequestImpl)copiedReq);
            }
        }
        if (this.isAlreadyLinked((SipServletRequestImpl)origRequest)) {
            throw new IllegalArgumentException();
        }
        this.linkRequests((SipServletRequestImpl)origRequest, (SipServletRequestImpl)copiedReq);
        if (linkedSessions) {
            SipSession session1 = origRequest.getSession();
            SipSession session2 = copiedReq.getSession();
            if (session1 == null || session2 == null) {
                throw new NullPointerException();
            }
            if (!(this.isValidSessions((SipSessionBase)session1, (SipSessionBase)session2) && origRequest.getApplicationSession(false) != null && session1.getApplicationSession().equals(origRequest.getApplicationSession()))) {
                throw new IllegalArgumentException();
            }
            if (!this.isAlreadyLinkedToEachOther((SipSessionBase)session1, (SipSessionBase)session2)) {
                if (!this.isNotLinkedToAnyone((SipSessionBase)session1, (SipSessionBase)session2)) {
                    throw new IllegalArgumentException();
                }
                this.linkSipSessions((SipSessionBase)session1, (SipSessionBase)session2);
            }
        }
        return copiedReq;
    }

    public SipServletRequest createRequest(SipSession session2, SipServletRequest origRequest, Map<String, Set<String>> headerMap) throws IllegalArgumentException {
        if (origRequest == null) {
            throw new NullPointerException();
        }
        if (this.isAlreadyLinked((SipServletRequestImpl)origRequest)) {
            throw new IllegalArgumentException();
        }
        SipSession session1 = origRequest.getSession();
        if (session1 == null || session2 == null) {
            throw new NullPointerException();
        }
        if (this.isValidSessions((SipSessionBase)session1, (SipSessionBase)session2) && origRequest.getApplicationSession(false) != null && !session1.getApplicationSession().equals(origRequest.getApplicationSession())) {
            throw new IllegalArgumentException();
        }
        if (headerMap != null && !headerMap.isEmpty() && this.isSystemHeader(headerMap.keySet(), (SipServletRequestImpl)origRequest, false)) {
            throw new IllegalArgumentException();
        }
        boolean shouldLinkSessions = false;
        if (!this.isAlreadyLinkedToEachOther((SipSessionBase)session1, (SipSessionBase)session2)) {
            if (!this.isNotLinkedToAnyone((SipSessionBase)session1, (SipSessionBase)session2)) {
                throw new IllegalArgumentException();
            }
            shouldLinkSessions = true;
        }
        SipServletRequest subRequest = session2.createRequest(origRequest.getMethod());
        if (headerMap != null && !headerMap.isEmpty()) {
            Iterator<String> names = headerMap.keySet().iterator();
            Iterator<Set<String>> values = headerMap.values().iterator();
            while (names.hasNext()) {
                this.setHeader(names.next(), values.next(), (SipServletRequestImpl)subRequest);
            }
        }
        if (shouldLinkSessions) {
            this.linkSipSessions((SipSessionBase)session1, (SipSessionBase)session2);
        }
        this.linkRequests((SipServletRequestImpl)origRequest, (SipServletRequestImpl)subRequest);
        return subRequest;
    }

    private void setHeader(String name, Set<String> values, SipServletRequestImpl req1) throws IllegalArgumentException {
        if (Header.isSingleLineHeader(name) && values.size() > 1) {
            throw new IllegalArgumentException("Header " + name + " should be a singel line header.");
        }
        Header header = Header.createFormated(name, req1);
        boolean isFirst = true;
        for (String value : values) {
            header.setValue(value, isFirst);
            isFirst = false;
        }
        if ("From".equalsIgnoreCase(name) || "To".equalsIgnoreCase(name) || "Contact".equalsIgnoreCase(name)) {
            try {
                header.getAddressValue();
            }
            catch (ServletParseException e) {
                throw new IllegalArgumentException("Header " + name + " is not valid.", e);
            }
        }
        req1.setHeader(header);
    }

    private boolean isSystemHeader(Set<String> headers, SipServletMessageImpl message, boolean isInitial) {
        for (String name : headers) {
            if (isInitial && ("From".equalsIgnoreCase(name) || "To".equalsIgnoreCase(name)) || !Header.isSystemHeader(name, message)) continue;
            return true;
        }
        return false;
    }

    private boolean isAlreadyLinked(SipServletRequestImpl req1) {
        return req1.getLinkedRequest() != null;
    }

    private void linkRequests(SipServletRequestImpl origReq, SipServletRequestImpl linkedReq) {
        origReq.setLinkedRequest(linkedReq);
        linkedReq.setLinkedRequest(origReq);
        linkedReq.setB2buaHelper(this);
    }

    private void updateTransactionStack(SipServletResponseImpl resp) {
        PathNode p = null;
        Iterator<PathNode> i = resp.getDialog().getCaller2CalleePath();
        if (i.hasNext()) {
            i.next();
        }
        while (i.hasNext()) {
            resp.popDispatcher();
        }
        i = resp.getDialog().getCaller2CalleePath();
        if (i.hasNext()) {
            i.next();
        }
        while (i.hasNext()) {
            p = i.next();
            resp.pushTransactionDispatcher(p);
        }
    }

    public SipServletResponse createResponseToOriginalRequest(SipSession session, int status, String reasonPhrase) {
        return this.createResponseToOriginalRequest((SipSessionBase)session, status, reasonPhrase);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SipServletResponse createResponseToOriginalRequest(SipSessionBase session2, int status, String reasonPhrase) {
        if (this._originalRequest == null) {
            throw new IllegalStateException("Only allowed to create response to original request.");
        }
        SipSessionBase session = null;
        if (session2 instanceof FacadeSession) {
            if (this._log.isLoggable(Level.FINE)) {
                this._log.log(Level.FINE, "Convert FacadeSession -> session");
            }
            session = ((FacadeSession)session2).getSession();
        } else {
            session = session2;
        }
        SipServletResponseImpl resp = null;
        if (session.isDerived()) {
            SipSessionBase linkedSession = (SipSessionBase)this.getLinkedSession(session, false);
            if (linkedSession != null) {
                DialogFragment dialog = this._originalRequest.getDialog().getDialogSet().searchForDialog(linkedSession.getToTag(), linkedSession.getFragmentId());
                if (dialog == null) throw new IllegalStateException("Derived session is already linked but dialog is not established.");
                SipServletRequestImpl clone = (SipServletRequestImpl)this._originalRequest.clone();
                clone.setDialog(dialog);
                resp = (SipServletResponseImpl)clone.createResponse(status, reasonPhrase);
                resp.setRequest(this._originalRequest);
                resp.setSession(linkedSession);
                this.updateTransactionStack(resp);
                if (!this._log.isLoggable(Level.FINE)) return resp;
                this._log.log(Level.FINE, "Session is derivied and linked, uac session = " + session + ", uas session = " + linkedSession + " , linked dialog =" + dialog + ", " + resp);
                return resp;
            } else {
                PathNode uas = this._originalRequest.getDialog().getLast();
                DialogFragment d = this._originalRequest.getDialog().cloneFromCallerToCalleeUntil(uas, true);
                uas = new UA(this._originalRequest.getApplicationSessionImpl(), false);
                d.addToPath(uas);
                SipServletRequestImpl clone = (SipServletRequestImpl)this._originalRequest.clone();
                clone.setDialog(d);
                resp = (SipServletResponseImpl)clone.createResponse(status, reasonPhrase);
                resp.setRequest(this._originalRequest);
                this.updateTransactionStack(resp);
                resp.setSessionToLink(session);
                if (!this._log.isLoggable(Level.FINE)) return resp;
                this._log.log(Level.FINE, "Session is derivied but not linked, uac session = " + session + ", uas session = " + linkedSession + " , linked dialog =" + d + ", " + resp);
            }
            return resp;
        } else {
            resp = (SipServletResponseImpl)this._originalRequest.createResponse(status, reasonPhrase);
            if (!this.isAlreadyLinkedToEachOther(session, this._originalRequest.getSessionImpl())) {
                this.linkSipSessions(session, this._originalRequest.getSessionImpl());
                if (!this._log.isLoggable(Level.FINE)) return resp;
                this._log.log(Level.FINE, "Session is original and was not linked, uac session = " + session + ", uas session = " + this._originalRequest.getSessionImpl() + " , linked dialog =" + this._originalRequest.getDialog() + ", " + resp);
                return resp;
            } else {
                if (!this._log.isLoggable(Level.FINE)) return resp;
                this._log.log(Level.FINE, "Session is original and already linked, uac session = " + session + ", uas session = " + this._originalRequest.getSessionImpl() + " , linked dialog =" + this._originalRequest.getDialog() + ", " + resp);
            }
        }
        return resp;
    }

    public SipSession getLinkedSession(SipSession session) {
        return this.getLinkedSession((SipSessionBase)session, true);
    }

    private SipSession getLinkedSession(SipSessionBase session, boolean enableFacade) {
        SipApplicationSession app = session.getApplicationSession();
        SipSessionBase sb = session;
        String id = sb.getLinkedSipSessionId();
        if (enableFacade && id == null && sb.isDerived()) {
            return new FacadeSession(sb);
        }
        return id != null ? app.getSipSession(id) : null;
    }

    public SipServletRequest getLinkedSipServletRequest(SipServletRequest req) {
        return this.getLinkedSipServletRequest((SipServletRequestImpl)req);
    }

    private SipServletRequestImpl getLinkedSipServletRequest(SipServletRequestImpl req1) {
        SipSession session2;
        SipSession session1;
        SipServletRequestImpl req2 = req1.getLinkedRequest();
        if (req2 != null && !this.isAlreadyLinkedToEachOther((SipSessionBase)(session1 = req1.getSession()), (SipSessionBase)(session2 = req2.getSession()))) {
            req2 = null;
        }
        return req2;
    }

    public List<SipServletMessage> getPendingMessages(SipSession session, UAMode mode) {
        return null;
    }

    private boolean isValidSessions(SipSessionBase session1, SipSessionBase session2) {
        return session1.isValid() && session2.isValid() && session1.getApplicationSession().getId().equals(session2.getApplicationSession().getId());
    }

    private boolean isNotLinkedToAnyone(SipSessionBase session1, SipSessionBase session2) {
        return session1.getLinkedSipSessionId() == null && session2.getLinkedSipSessionId() == null;
    }

    private boolean isAlreadyLinkedToEachOther(SipSessionBase session1, SipSessionBase session2) {
        return session1.equals(session2) || session1.getLinkedSipSessionId() != null && session2.getLinkedSipSessionId() != null && session1.getLinkedSipSessionId().equals(session2.getId()) && session2.getLinkedSipSessionId().equals(session1.getId());
    }

    public void linkSipSessions(SipSession session1, SipSession session2) {
        if (session1 == null || session2 == null) {
            throw new NullPointerException();
        }
        if (!this.isAlreadyLinkedToEachOther((SipSessionBase)session1, (SipSessionBase)session2)) {
            if (!this.isValidSessions((SipSessionBase)session1, (SipSessionBase)session2) && !this.isNotLinkedToAnyone((SipSessionBase)session1, (SipSessionBase)session2)) {
                throw new IllegalArgumentException();
            }
            this.linkSipSessions((SipSessionBase)session1, (SipSessionBase)session2);
        }
    }

    private void linkSipSessions(SipSessionBase session1, SipSessionBase session2) {
        session1.setLinkedSipSessionId(session2.getId());
        session2.setLinkedSipSessionId(session1.getId());
    }

    public void unlinkSipSessions(SipSession session1) {
        SipSession session2 = this.getLinkedSession((SipSessionBase)session1, false);
        if (session2 == null || !session2.isValid()) {
            throw new IllegalArgumentException();
        }
        this.unlinkSipSessions((SipSessionBase)session1, (SipSessionBase)session2);
    }

    private void unlinkSipSessions(SipSessionBase session1, SipSessionBase session2) {
        session1.setLinkedSipSessionId(null);
        session2.setLinkedSipSessionId(null);
    }

    public class FacadeSession
    implements SipSessionBase {
        private static final long serialVersionUID = -5845365964095917542L;
        private final SipSessionBase _session;

        private FacadeSession(SipSessionBase s) {
            this._session = s;
        }

        private SipSessionBase getSession() {
            return this._session;
        }

        public long getCreationTime() {
            return 0L;
        }

        public String getId() {
            return "";
        }

        public long getLastAccessedTime() {
            return 0L;
        }

        public void invalidate() {
        }

        public void setOutboundInterface(SipURI uri) {
        }

        public boolean isOngoingTransaction() {
            return false;
        }

        public SipSession.State getState() {
            throw new RuntimeException(" Not yet implemented ");
        }

        public SipApplicationSession getApplicationSession() {
            return this._session.getApplicationSession();
        }

        public String getCallId() {
            return null;
        }

        public Address getLocalParty() {
            return null;
        }

        public Address getRemoteParty() {
            return null;
        }

        public SipServletRequest createRequest(String method) {
            return null;
        }

        public void setHandler(String name) throws ServletException {
        }

        public Object getAttribute(String name) {
            return null;
        }

        public Enumeration getAttributeNames() {
            return null;
        }

        public void setAttribute(String name, Object value) {
        }

        public void removeAttribute(String name) {
        }

        public String getRegion() {
            return null;
        }

        public URI getSubscriberURI() throws IllegalStateException {
            return null;
        }

        public boolean isValid() {
            return false;
        }

        public SipApplicationSessionImpl getApplicationSessionImpl() {
            return null;
        }

        public int getFragmentId() {
            return 0;
        }

        public String getFromTag() {
            return null;
        }

        public String getHandler() {
            return null;
        }

        public String getLinkedSipSessionId() {
            return null;
        }

        public SipSessionBase getOriginalOrDerivedSessionAndRegisterDialog(SipServletRequestImpl req, DialogFragment d) {
            return null;
        }

        public SipSessionBase getOriginalOrDerivedSessionAndRegisterDialog(SipServletResponseImpl resp, DialogFragment d) {
            return null;
        }

        public URI getRemoteTarget() {
            return null;
        }

        public Address getTo() {
            return null;
        }

        public String getToTag() {
            return null;
        }

        public boolean hasNoToTag() {
            return false;
        }

        public void invalidate(boolean hasTimedOut) {
        }

        public boolean is1xxReliableOngoing() {
            return false;
        }

        public boolean is1xxReliableSDP() {
            return false;
        }

        public boolean isDerived() {
            return false;
        }

        public void reset1xxReliable() {
        }

        public void resetUpdateOngoing() {
        }

        public boolean set1xxReliableOngoing(boolean sdp) {
            return false;
        }

        public void setLinkedSipSessionId(String id) {
        }

        public void setRegion(String region) {
        }

        public void setRemoteTarget(URI contact) {
        }

        public void setSubscriberURI(URI subscriberURI) {
        }

        public void setType(PathNode.Type type) {
        }

        public boolean setUpdateOngoing() {
            return false;
        }

        public boolean isReplicable() {
            return this._session.isReplicable();
        }
    }
}

