/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.Ascii7String;
import com.ericsson.ssa.sip.DialogFragmentManager;
import com.ericsson.ssa.sip.DialogSet;
import com.ericsson.ssa.sip.NotEqualDialogException;
import com.ericsson.ssa.sip.PathNode;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogFragment
implements Externalizable {
    private static final long serialVersionUID = -7081403938667526477L;
    public static final int DEFAULT_FRAGMENT_ID = 1;
    public static final int BAD_FRAGMENT_ID = 666;
    private static final Logger m_Log = Logger.getLogger("SipContainer");
    private LinkedList<PathNode> m_Nodes = new LinkedList();
    private Ascii7String m_ToTag = null;
    private int m_FragmentId = 1;
    private DialogSet m_DialogSet;
    private boolean m_IsValid = true;
    private AtomicInteger m_SessionCounter = new AtomicInteger(0);
    private long m__DialogStartedTimestamp = 0L;
    private final Object VALID_LOCK = new Object();
    private long invalidationTimeStamp;
    private String invalidationThreadInfo;
    private boolean isReplicable = true;

    public DialogFragment(DialogSet set) {
        this.m_DialogSet = set;
        this.m_DialogSet.addDialog(this);
        this.m__DialogStartedTimestamp = System.currentTimeMillis();
    }

    public DialogFragment(DialogSet ds, boolean newFragmentId) {
        this.m_FragmentId = newFragmentId ? ds.nextFragmentId() : 1;
        ds.addDialog(this);
        this.m_DialogSet = ds;
    }

    public DialogFragment() {
        this.m_FragmentId = 1;
    }

    public static String createKey(String callId, String fromTag) {
        return DialogFragment.createKey(callId, fromTag, null, 0);
    }

    public static String createKey(String callId, String fromTag, String toTag) {
        return DialogFragment.createKey(callId, fromTag, toTag, 1);
    }

    public static String createKey(String callId, String fromTag, String toTag, int fragmentId) {
        StringBuilder sb = new StringBuilder(callId);
        sb.append('&');
        sb.append(fromTag);
        if (toTag != null) {
            sb.append('&');
            sb.append(toTag);
        }
        if (fragmentId > 0) {
            sb.append(':');
            sb.append(fragmentId);
        }
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.m_Nodes.size());
        Iterator pni = this.m_Nodes.iterator();
        while (pni.hasNext()) {
            out.writeObject(pni.next());
        }
        if (this.m_ToTag == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.m_ToTag.toString());
        }
        out.writeInt(this.m_FragmentId);
        out.writeUTF(this.m_DialogSet.getCallId());
        out.writeObject(this.m_DialogSet.getFrom());
        out.writeBoolean(this.m_IsValid);
        out.writeInt(this.m_SessionCounter.get());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_Nodes = new LinkedList();
        int i = in.readInt();
        for (int c = 0; c < i; ++c) {
            this.m_Nodes.add((PathNode)in.readObject());
        }
        this.m_ToTag = new Ascii7String(in.readUTF());
        this.m_FragmentId = in.readInt();
        String callId = in.readUTF();
        Address from = (Address)in.readObject();
        this.m_DialogSet = new DialogSet(callId, from);
        this.m_IsValid = in.readBoolean();
        this.m_SessionCounter = new AtomicInteger(in.readInt());
    }

    public DialogSet getDialogSet() {
        return this.m_DialogSet;
    }

    public Object clone() {
        DialogFragment d = new DialogFragment(this.m_DialogSet);
        LinkedList<PathNode> nodes = new LinkedList<PathNode>();
        PathNode p = null;
        for (int i = 0; i < this.m_Nodes.size(); ++i) {
            p = (PathNode)this.m_Nodes.get(i).clone();
            nodes.add(p);
            if (p.isReplicable()) continue;
            d.isReplicable = false;
        }
        d.m_Nodes = nodes;
        d.m_FragmentId = this.m_FragmentId;
        return d;
    }

    public DialogFragment cloneFromCallerToCalleeUntil(PathNode pn, boolean excludePn) {
        DialogFragment d = new DialogFragment(this.m_DialogSet, true);
        LinkedList<PathNode> nodes = new LinkedList<PathNode>();
        PathNode p = null;
        PathNode clone = null;
        Iterator<PathNode> iter = this.getCaller2CalleePath();
        while (iter.hasNext()) {
            p = iter.next();
            if (excludePn && pn.equals(p)) break;
            clone = (PathNode)p.clone();
            nodes.add(clone);
            if (!clone.isReplicable()) {
                d.isReplicable = false;
            }
            if (excludePn || !pn.equals(p)) continue;
        }
        d.m_Nodes = nodes;
        return d;
    }

    public String getDialogId() {
        return DialogFragment.createKey(this.m_DialogSet.getCallId(), this.m_DialogSet.getFromTag(), this.getToTag(), this.m_FragmentId);
    }

    public String getToTag() {
        return this.m_ToTag == null ? null : this.m_ToTag.toString();
    }

    public void registerSession(SipSession s) {
        this.m_SessionCounter.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToTagAndRegisterSession(String toTag, SipSession s) {
        this.registerSession(s);
        if (this.m_ToTag == null) {
            DialogFragment dialogFragment = this;
            synchronized (dialogFragment) {
                if (this.m_ToTag == null) {
                    this.m_ToTag = new Ascii7String(toTag);
                    DialogFragmentManager.getInstance().registerDialogFragment(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryToSetToTagAndRegisterDialog(String toTag, boolean isDialogCreational) {
        boolean success = false;
        if (this.m_ToTag == null) {
            DialogFragment dialogFragment = this;
            synchronized (dialogFragment) {
                if (this.m_ToTag == null) {
                    this.m_ToTag = new Ascii7String(toTag);
                    if (isDialogCreational) {
                        DialogFragmentManager.getInstance().registerDialogFragment(this);
                    }
                    success = true;
                } else if (this.m_ToTag.equals(toTag)) {
                    success = true;
                }
            }
        } else if (this.m_ToTag.equals(toTag)) {
            success = true;
        }
        return success;
    }

    public int getFragmentId() {
        return this.m_FragmentId;
    }

    public void setFragmentId(int fragmentId) {
        this.m_FragmentId = fragmentId;
    }

    public long getDialogLifetime() {
        return System.currentTimeMillis() - this.m__DialogStartedTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(boolean hasTimedOut) {
        if (this.m_SessionCounter.decrementAndGet() == 0) {
            Object object = this.VALID_LOCK;
            synchronized (object) {
                this.m_DialogSet.removeDialog(this);
                DialogFragmentManager.getInstance().removeDialogFragment(this, hasTimedOut);
                this.m_IsValid = false;
                this.invalidationTimeStamp = System.currentTimeMillis();
                Thread t = Thread.currentThread();
                this.invalidationThreadInfo = "Id=" + t.getId() + ", name=" + t.getName();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.VALID_LOCK;
        synchronized (object) {
            return this.m_IsValid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInvalidationTimeStamp() {
        Object object = this.VALID_LOCK;
        synchronized (object) {
            return this.invalidationTimeStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInvalidationThreadInfo() {
        Object object = this.VALID_LOCK;
        synchronized (object) {
            return this.invalidationThreadInfo;
        }
    }

    public void addToPath(PathNode node) {
        this.m_Nodes.add(node);
    }

    public PathNode getFirst() {
        return this.m_Nodes.getFirst();
    }

    public PathNode getLast() {
        return this.m_Nodes.getLast();
    }

    public int size() {
        return this.m_Nodes.size();
    }

    public Iterator<PathNode> getCaller2CalleePath() {
        return this.m_Nodes.iterator();
    }

    public Iterator<PathNode> getCallee2CallerPath() {
        return new BackwardListIterator<PathNode>(this.m_Nodes);
    }

    public boolean isMessageFromCaller(SipServletMessageImpl m) throws NotEqualDialogException {
        if (m.getCallId().equals(this.m_DialogSet.getCallId())) {
            String fromTag = m.getFrom().getParameter("tag");
            String toTag = m.getTo().getParameter("tag");
            boolean isFromCaller = false;
            boolean isFromCallee = false;
            if (!m.hasToTag() || this.getToTag() == null) {
                isFromCaller = this.m_DialogSet.getFromTag().equals(fromTag);
            } else {
                isFromCaller = this.m_DialogSet.getFromTag().equals(fromTag) && this.getToTag().equals(toTag);
                boolean bl = isFromCallee = this.m_DialogSet.getFromTag().equals(toTag) && this.getToTag().equals(fromTag);
            }
            if (!isFromCaller && !isFromCallee) {
                throw new NotEqualDialogException();
            }
            return isFromCaller;
        }
        throw new NotEqualDialogException();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        str.append("[ DialogFragment fragmentId=" + this.m_FragmentId);
        str.append(NEW_LINE);
        str.append(", dialogStartedTimestamp=" + this.m__DialogStartedTimestamp);
        str.append(", hashCode=" + this.hashCode());
        str.append(", dialogLifetime=" + this.getDialogLifetime());
        str.append(", isValid=" + this.m_IsValid);
        str.append(", sessionCounter=" + this.m_SessionCounter);
        str.append(", node size=" + this.m_Nodes.size());
        str.append(", m_ToTag=" + this.m_ToTag);
        SipApplicationSessionImpl sip = null;
        String s = "SipApplicationSessionImpl=";
        for (PathNode p : this.m_Nodes) {
            if (p == null) continue;
            str.append(NEW_LINE);
            str.append(", PathNode: type=" + (Object)((Object)p.getType()) + ", hashCode" + p.hashCode() + ", servlet=" + p.getApplicationSession());
            sip = p.getApplicationSession();
            if (sip != null) {
                s = s + ", ID=" + sip.getId() + ", name=" + sip.getName() + ", sessionTimeout=" + sip.getDefaultSessionTimeout() + " hashCode=" + sip.hashCode();
            }
            str.append(sip);
        }
        str.append(NEW_LINE);
        str.append(" ]");
        return str.toString();
    }

    public boolean isReplicable() {
        return this.isReplicable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BackwardListIterator<T>
    implements Iterator<T> {
        private List<T> m_List;
        private int m_Index = -1;

        public BackwardListIterator(List<T> list) {
            this.m_List = list;
            this.m_Index = list.size();
        }

        @Override
        public boolean hasNext() {
            return this.m_Index > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.m_Index;
            return this.m_List.get(this.m_Index);
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

