/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.MultiLineHeader;
import com.ericsson.ssa.sip.SingleLineHeader;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Header
implements Externalizable {
    static Logger _log = Logger.getLogger("SipContainer");
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String ACCEPT_INFO = "Alert-Info";
    public static final String ALLOW = "Allow";
    public static final String ALLOW_EVENTS = "Allow-Events";
    public static final String ALLOW_EVENTS_SHORT = "U";
    public static final String AUTHENTICATION_INFO = "Authentication-Info";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CALL_INFO = "Call-Info";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_SHORT = "C";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_LENGTH_SHORT = "L";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_ENCODING_SHORT = "E";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String DATE = "Date";
    public static final String ERROR_INFO = "Error-Info";
    public static final String EVENT = "Event";
    public static final String EVENT_SHORT = "O";
    public static final String EXPIRES = "Expires";
    public static final String IN_REPLY_TO = "In-Reply-To";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String MIME_VERSION = "Mime-Version";
    public static final String MIN_EXPIRES = "Min-Expires";
    public static final String ORGANIZATION = "Organization";
    public static final String PRIORITY = "Priority";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String PROXY_REQUIRE = "Proxy-Require";
    public static final String REPLY_TO = "Reply-To";
    public static final String REQUIRE = "Require";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String SERVER = "Server";
    public static final String SUBJECT = "Subject";
    public static final String SUBJECT_SHORT = "S";
    public static final String SUBSCRIPTION_STATE = "Subscription-State";
    public static final String SUPPORTED = "Supported";
    public static final String SUPPORTED_SHORT = "K";
    public static final String TIMESTAMP = "Timestamp";
    public static final String UNSUPPORTED = "Unsupported";
    public static final String USER_AGENT = "User-Agent";
    public static final String WARNING = "Warning";
    public static final String WWW_AUTHENTICATE = "Www-Authenticate";
    public static final String CALL_ID = "Call-Id";
    public static final String CALL_ID_SHORT = "I";
    public static final String CONTACT = "Contact";
    public static final String CONTACT_SHORT = "M";
    public static final String CSEQ = "Cseq";
    public static final String FROM = "From";
    public static final String FROM_SHORT = "F";
    public static final String RECORD_ROUTE = "Record-Route";
    public static final String ROUTE = "Route";
    public static final String TO = "To";
    public static final String TO_SHORT = "T";
    public static final String VIA = "Via";
    public static final String VIA_SHORT = "V";
    public static final String RACK = "Rack";
    public static final String RSEQ = "Rseq";
    public static final String REFER_TO = "Refer-To";
    public static final String REFER_TO_SHORT = "R";
    public static final String REFERRED_BY = "Referred-By";
    public static final String REFERRED_BY_SHORT = "B";
    public static final String P_ASSERTED_ID = "P-Asserted-Identity";
    public static final String ILLEGAL_ACCESS = "You can not modify a system header!";
    public static final String MIN_SE = "Min-Se";
    public static final String SESSION_EXPIRES = "Session-Expires";
    public static final String SESSION_EXPIRES_SHORT = "X";
    public static final String PRIVACY = "Privacy";
    public static final String REPLACES = "Replaces";
    public static final String SIP_ETAG = "Sip-Etag";
    public static final String SIP_IF_MATCH = "Sip-If-Match";
    public static final String REFER_SUB = "Refer-Sub";
    public static final String PATH = "Path";
    public static final Map<String, String> ALL_HEADERS_MAP = new HashMap<String, String>();
    public static final Map<String, String> SHORT_TO_LONG_MAP;
    public static final Map<String, String> SYSTEM_HEADER_MAP;
    public static final Map<String, String> SINGLE_LINE_HEADER_MAP;
    protected boolean _readOnly = false;
    protected boolean _singleLine = true;
    protected List<Boolean> _multiValuesOnSameLineIndicator = new ArrayList<Boolean>();
    protected String _name;
    protected SipFactoryImpl _sipFactory;

    protected Header(String pretty, boolean systemHeader, boolean singleLine) {
        this._name = pretty;
        this._readOnly = systemHeader;
        this._singleLine = singleLine;
        this._sipFactory = SipFactoryImpl.getInstance();
    }

    public Header() {
    }

    @Deprecated
    public static Header create(String header, SipServletMessageImpl message) {
        String name = Header.format(header.getBytes(), 0, header.length());
        return Header.createFormated(name, message);
    }

    public static Header create(byte[] bytes, int offset, int length, SipServletMessageImpl message) {
        String name = Header.format(bytes, offset, length);
        return Header.createFormated(name, message);
    }

    public static Header createFormated(String name, SipServletMessageImpl message) {
        boolean readOnly = Header.isSystemHeader(name, message);
        boolean singleLine = Header.isSingleLineHeader(name);
        if (singleLine) {
            return new SingleLineHeader(name, readOnly);
        }
        return new MultiLineHeader(name, readOnly);
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        try {
            if (this._multiValuesOnSameLineIndicator != null) {
                output.writeInt(this._multiValuesOnSameLineIndicator.size());
                Iterator<Boolean> i = this._multiValuesOnSameLineIndicator.iterator();
                while (i.hasNext()) {
                    output.writeBoolean(i.next());
                }
            } else {
                output.writeInt(0);
            }
            output.writeBoolean(this._readOnly);
            output.writeBoolean(this._singleLine);
            output.writeUTF(this._name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException {
        try {
            int len = input.readInt();
            if (this._multiValuesOnSameLineIndicator == null) {
                this._multiValuesOnSameLineIndicator = new ArrayList<Boolean>(len);
            }
            for (int i = 0; i < len; ++i) {
                this._multiValuesOnSameLineIndicator.add(input.readBoolean());
            }
            this._readOnly = input.readBoolean();
            this._singleLine = input.readBoolean();
            String name = input.readUTF();
            String constant = ALL_HEADERS_MAP.get(name);
            this._name = constant != null ? constant : name;
            this._sipFactory = SipFactoryImpl.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract Object clone();

    public static String format(String name) {
        return Header.format(name.getBytes(), 0, name.length());
    }

    public static String format(byte[] bytes, int offset, int length) {
        boolean firstChar = true;
        boolean started = false;
        int endIndex = offset + length;
        block8: for (int i = offset; i < endIndex; ++i) {
            byte b = bytes[i];
            switch (b) {
                case 9: 
                case 32: {
                    if (started) {
                        endIndex = i;
                        continue block8;
                    }
                    offset = i + 1;
                    continue block8;
                }
                case 45: {
                    firstChar = true;
                    continue block8;
                }
                default: {
                    if (!firstChar && 64 < b && b < 91) {
                        bytes[i] = (byte)(b | 0x20);
                    } else if (firstChar && 96 < b && b < 123) {
                        bytes[i] = (byte)(b & 0xDF);
                    }
                    started = true;
                    firstChar = false;
                }
            }
        }
        int diff = endIndex - offset;
        if (diff <= 0) {
            throw new NullPointerException("Not a valid header value!");
        }
        if (diff == 1) {
            try {
                return SHORT_TO_LONG_MAP.get(new String(bytes, offset, diff, "US-ASCII"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        try {
            String name = new String(bytes, offset, diff, "US-ASCII");
            String constant = ALL_HEADERS_MAP.get(name);
            if (constant != null) {
                return constant;
            }
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "The header " + name + " could be added to ALL_HEADERS_MAP for better performance!");
            }
            return name;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public String getName() {
        return this._name;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public void setReadOnly(boolean ro) {
        this._readOnly = ro;
    }

    public abstract String getValue();

    public abstract void setValue(String var1, boolean var2);

    public abstract Address getAddressValue() throws ServletParseException;

    public abstract void setAddressValue(Address var1, boolean var2);

    public abstract ListIterator<String> getValues();

    public abstract ListIterator<Address> getAddressValues() throws ServletParseException;

    public abstract void removeValues();

    public abstract void merge(Header var1);

    public boolean equals(Object o) {
        if (o instanceof Header) {
            return ((Header)o).getName().equals(this._name);
        }
        if (o instanceof String) {
            return ((String)o).equals(this._name);
        }
        return false;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public static boolean isSystemHeader(String name, SipServletMessageImpl message) {
        if (!SYSTEM_HEADER_MAP.containsKey(name)) {
            return false;
        }
        if (!name.equals(CONTACT)) {
            return true;
        }
        if (message.getMethod().equals("REGISTER")) {
            return false;
        }
        if (message instanceof SipServletRequestImpl) {
            return true;
        }
        int code = ((SipServletResponseImpl)message).getStatus();
        return code != 485 && (code < 300 || code >= 400);
    }

    public static boolean isSingleLineHeader(String name) {
        return SINGLE_LINE_HEADER_MAP.containsKey(name);
    }

    public static boolean isSingleLineHeader(Header name) {
        return Header.isSingleLineHeader(name.getName());
    }

    public void setIsNextValueOnSameLine(boolean nextValueOnSameLineIndicator, boolean first) {
        if (first) {
            this._multiValuesOnSameLineIndicator.add(0, nextValueOnSameLineIndicator);
        } else {
            this._multiValuesOnSameLineIndicator.add(nextValueOnSameLineIndicator);
        }
    }

    public boolean getIsNextValueOnSameLine(boolean first) {
        if (first) {
            return this._multiValuesOnSameLineIndicator.get(0);
        }
        int last = this._multiValuesOnSameLineIndicator.size() - 1;
        return this._multiValuesOnSameLineIndicator.get(last);
    }

    static {
        ALL_HEADERS_MAP.put(ACCEPT, ACCEPT);
        ALL_HEADERS_MAP.put(ACCEPT_ENCODING, ACCEPT_ENCODING);
        ALL_HEADERS_MAP.put(ACCEPT_LANGUAGE, ACCEPT_LANGUAGE);
        ALL_HEADERS_MAP.put(ACCEPT_INFO, ACCEPT_INFO);
        ALL_HEADERS_MAP.put(ALLOW, ALLOW);
        ALL_HEADERS_MAP.put(ALLOW_EVENTS, ALLOW_EVENTS);
        ALL_HEADERS_MAP.put(AUTHENTICATION_INFO, AUTHENTICATION_INFO);
        ALL_HEADERS_MAP.put(AUTHORIZATION, AUTHORIZATION);
        ALL_HEADERS_MAP.put(CALL_INFO, CALL_INFO);
        ALL_HEADERS_MAP.put(CONTENT_TYPE, CONTENT_TYPE);
        ALL_HEADERS_MAP.put(CONTENT_LENGTH, CONTENT_LENGTH);
        ALL_HEADERS_MAP.put(CONTENT_DISPOSITION, CONTENT_DISPOSITION);
        ALL_HEADERS_MAP.put(CONTENT_ENCODING, CONTENT_ENCODING);
        ALL_HEADERS_MAP.put(CONTENT_LANGUAGE, CONTENT_LANGUAGE);
        ALL_HEADERS_MAP.put(DATE, DATE);
        ALL_HEADERS_MAP.put(ERROR_INFO, ERROR_INFO);
        ALL_HEADERS_MAP.put(EVENT, EVENT);
        ALL_HEADERS_MAP.put(EXPIRES, EXPIRES);
        ALL_HEADERS_MAP.put(IN_REPLY_TO, IN_REPLY_TO);
        ALL_HEADERS_MAP.put(MAX_FORWARDS, MAX_FORWARDS);
        ALL_HEADERS_MAP.put(MIME_VERSION, MIME_VERSION);
        ALL_HEADERS_MAP.put(MIN_EXPIRES, MIN_EXPIRES);
        ALL_HEADERS_MAP.put(ORGANIZATION, ORGANIZATION);
        ALL_HEADERS_MAP.put(PRIORITY, PRIORITY);
        ALL_HEADERS_MAP.put(PROXY_AUTHENTICATE, PROXY_AUTHENTICATE);
        ALL_HEADERS_MAP.put(PROXY_AUTHORIZATION, PROXY_AUTHORIZATION);
        ALL_HEADERS_MAP.put(PROXY_REQUIRE, PROXY_REQUIRE);
        ALL_HEADERS_MAP.put(REPLY_TO, REPLY_TO);
        ALL_HEADERS_MAP.put(REQUIRE, REQUIRE);
        ALL_HEADERS_MAP.put(RETRY_AFTER, RETRY_AFTER);
        ALL_HEADERS_MAP.put(SERVER, SERVER);
        ALL_HEADERS_MAP.put(SUBJECT, SUBJECT);
        ALL_HEADERS_MAP.put(SUBSCRIPTION_STATE, SUBSCRIPTION_STATE);
        ALL_HEADERS_MAP.put(SUPPORTED, SUPPORTED);
        ALL_HEADERS_MAP.put(TIMESTAMP, TIMESTAMP);
        ALL_HEADERS_MAP.put(UNSUPPORTED, UNSUPPORTED);
        ALL_HEADERS_MAP.put(USER_AGENT, USER_AGENT);
        ALL_HEADERS_MAP.put(WARNING, WARNING);
        ALL_HEADERS_MAP.put(WWW_AUTHENTICATE, WWW_AUTHENTICATE);
        ALL_HEADERS_MAP.put(CALL_ID, CALL_ID);
        ALL_HEADERS_MAP.put(CONTACT, CONTACT);
        ALL_HEADERS_MAP.put(CSEQ, CSEQ);
        ALL_HEADERS_MAP.put(FROM, FROM);
        ALL_HEADERS_MAP.put(RECORD_ROUTE, RECORD_ROUTE);
        ALL_HEADERS_MAP.put(ROUTE, ROUTE);
        ALL_HEADERS_MAP.put(TO, TO);
        ALL_HEADERS_MAP.put(VIA, VIA);
        ALL_HEADERS_MAP.put(RACK, RACK);
        ALL_HEADERS_MAP.put(RSEQ, RSEQ);
        ALL_HEADERS_MAP.put(REFER_TO, REFER_TO);
        ALL_HEADERS_MAP.put(REFERRED_BY, REFERRED_BY);
        ALL_HEADERS_MAP.put(P_ASSERTED_ID, P_ASSERTED_ID);
        ALL_HEADERS_MAP.put(MIN_SE, MIN_SE);
        ALL_HEADERS_MAP.put(SESSION_EXPIRES, SESSION_EXPIRES);
        ALL_HEADERS_MAP.put(PRIVACY, PRIVACY);
        ALL_HEADERS_MAP.put(REPLACES, REPLACES);
        ALL_HEADERS_MAP.put(SIP_ETAG, SIP_ETAG);
        ALL_HEADERS_MAP.put(SIP_IF_MATCH, SIP_IF_MATCH);
        ALL_HEADERS_MAP.put(REFER_SUB, REFER_SUB);
        ALL_HEADERS_MAP.put(PATH, PATH);
        SHORT_TO_LONG_MAP = new HashMap<String, String>();
        SHORT_TO_LONG_MAP.put(CONTENT_TYPE_SHORT, CONTENT_TYPE);
        SHORT_TO_LONG_MAP.put(CONTENT_LENGTH_SHORT, CONTENT_LENGTH);
        SHORT_TO_LONG_MAP.put(CONTENT_ENCODING_SHORT, CONTENT_ENCODING);
        SHORT_TO_LONG_MAP.put(SUBJECT_SHORT, SUBJECT);
        SHORT_TO_LONG_MAP.put(SUPPORTED_SHORT, SUPPORTED);
        SHORT_TO_LONG_MAP.put(CALL_ID_SHORT, CALL_ID);
        SHORT_TO_LONG_MAP.put(CONTACT_SHORT, CONTACT);
        SHORT_TO_LONG_MAP.put(FROM_SHORT, FROM);
        SHORT_TO_LONG_MAP.put(TO_SHORT, TO);
        SHORT_TO_LONG_MAP.put(VIA_SHORT, VIA);
        SHORT_TO_LONG_MAP.put(ALLOW_EVENTS_SHORT, ALLOW_EVENTS);
        SHORT_TO_LONG_MAP.put(EVENT_SHORT, EVENT);
        SHORT_TO_LONG_MAP.put(REFER_TO_SHORT, REFER_TO);
        SHORT_TO_LONG_MAP.put(REFERRED_BY_SHORT, REFERRED_BY);
        SHORT_TO_LONG_MAP.put(SESSION_EXPIRES_SHORT, SESSION_EXPIRES);
        SYSTEM_HEADER_MAP = new HashMap<String, String>();
        SYSTEM_HEADER_MAP.put(FROM, FROM);
        SYSTEM_HEADER_MAP.put(TO, TO);
        SYSTEM_HEADER_MAP.put(CALL_ID, CALL_ID);
        SYSTEM_HEADER_MAP.put(CSEQ, CSEQ);
        SYSTEM_HEADER_MAP.put(VIA, VIA);
        SYSTEM_HEADER_MAP.put(ROUTE, ROUTE);
        SYSTEM_HEADER_MAP.put(RECORD_ROUTE, RECORD_ROUTE);
        SYSTEM_HEADER_MAP.put(CONTACT, CONTACT);
        SYSTEM_HEADER_MAP.put(RACK, RACK);
        SYSTEM_HEADER_MAP.put(RSEQ, RSEQ);
        SINGLE_LINE_HEADER_MAP = new HashMap<String, String>();
        SINGLE_LINE_HEADER_MAP.put(FROM, FROM);
        SINGLE_LINE_HEADER_MAP.put(TO, TO);
        SINGLE_LINE_HEADER_MAP.put(CALL_ID, CALL_ID);
        SINGLE_LINE_HEADER_MAP.put(CSEQ, CSEQ);
        SINGLE_LINE_HEADER_MAP.put(CONTENT_LENGTH, CONTENT_LENGTH);
        SINGLE_LINE_HEADER_MAP.put(CONTENT_TYPE, CONTENT_TYPE);
        SINGLE_LINE_HEADER_MAP.put(MAX_FORWARDS, MAX_FORWARDS);
        SINGLE_LINE_HEADER_MAP.put(RACK, RACK);
        SINGLE_LINE_HEADER_MAP.put(RSEQ, RSEQ);
        SINGLE_LINE_HEADER_MAP.put(CONTENT_DISPOSITION, CONTENT_DISPOSITION);
        SINGLE_LINE_HEADER_MAP.put(DATE, DATE);
        SINGLE_LINE_HEADER_MAP.put(EXPIRES, EXPIRES);
        SINGLE_LINE_HEADER_MAP.put(MIME_VERSION, MIME_VERSION);
        SINGLE_LINE_HEADER_MAP.put(MIN_EXPIRES, MIN_EXPIRES);
        SINGLE_LINE_HEADER_MAP.put(ORGANIZATION, ORGANIZATION);
        SINGLE_LINE_HEADER_MAP.put(PRIORITY, PRIORITY);
        SINGLE_LINE_HEADER_MAP.put(RETRY_AFTER, RETRY_AFTER);
        SINGLE_LINE_HEADER_MAP.put(SERVER, SERVER);
        SINGLE_LINE_HEADER_MAP.put(SUBJECT, SUBJECT);
        SINGLE_LINE_HEADER_MAP.put(TIMESTAMP, TIMESTAMP);
        SINGLE_LINE_HEADER_MAP.put(USER_AGENT, USER_AGENT);
        SINGLE_LINE_HEADER_MAP.put(REFER_TO, REFER_TO);
        SINGLE_LINE_HEADER_MAP.put(REFERRED_BY, REFERRED_BY);
        SINGLE_LINE_HEADER_MAP.put(MIN_SE, MIN_SE);
        SINGLE_LINE_HEADER_MAP.put(SESSION_EXPIRES, SESSION_EXPIRES);
        SINGLE_LINE_HEADER_MAP.put(PRIVACY, PRIVACY);
        SINGLE_LINE_HEADER_MAP.put(REPLACES, REPLACES);
        SINGLE_LINE_HEADER_MAP.put(SIP_ETAG, SIP_ETAG);
        SINGLE_LINE_HEADER_MAP.put(SIP_IF_MATCH, SIP_IF_MATCH);
        SINGLE_LINE_HEADER_MAP.put(REFER_SUB, REFER_SUB);
        SINGLE_LINE_HEADER_MAP.put(PATH, PATH);
    }
}

