/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.BasicMandatoryHeaderValidator;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import javax.servlet.sip.SipServletRequest;

public class MaxForwardsValidator
extends BasicMandatoryHeaderValidator {
    public MaxForwardsValidator() {
        super("Max-Forwards");
    }

    public boolean validate(SipServletMessageImpl message) {
        Header header = message.getRawHeader("Max-Forwards");
        if (header == null || header.getValue() == null || header.getValue().length() == 0) {
            return !(message instanceof SipServletRequest);
        }
        try {
            int maxForwards = Integer.parseInt(header.getValue());
            return maxForwards >= 0 && maxForwards < 256;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

