/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.AddressOrValue;
import com.ericsson.ssa.sip.Header;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiLineHeader
extends Header
implements Externalizable {
    private static final long serialVersionUID = 3834588816114529840L;
    public static final String LIST_ALTERED_ERROR_REASON = "List backing iterator have been altered with non-Address value after creation of iterator";
    private List<AddressOrValue> addressesOrValues = new ArrayList<AddressOrValue>();

    public MultiLineHeader(String pretty, boolean systemHeader) {
        super(pretty, systemHeader, false);
    }

    public MultiLineHeader() {
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        if (this.addressesOrValues != null) {
            output.writeInt(this.addressesOrValues.size());
            Iterator<AddressOrValue> i = this.addressesOrValues.iterator();
            while (i.hasNext()) {
                output.writeUTF(i.next().toString());
            }
        } else {
            output.writeInt(0);
        }
        super.writeExternal(output);
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException {
        int len = input.readInt();
        if (this.addressesOrValues == null) {
            this.addressesOrValues = new ArrayList<AddressOrValue>(len);
        }
        for (int i = 0; i < len; ++i) {
            this.addressesOrValues.add(new AddressOrValue(input.readUTF()));
        }
        super.readExternal(input);
    }

    @Override
    protected Object clone() {
        MultiLineHeader newHeader = new MultiLineHeader(new String(this._name), this._readOnly);
        for (Boolean k : this._multiValuesOnSameLineIndicator) {
            newHeader._multiValuesOnSameLineIndicator.add(new Boolean(k));
        }
        for (AddressOrValue k : this.addressesOrValues) {
            newHeader.addressesOrValues.add((AddressOrValue)k.clone());
        }
        return newHeader;
    }

    @Override
    public String getValue() {
        if (!this.addressesOrValues.isEmpty()) {
            return this.addressesOrValues.get(0).toString();
        }
        return null;
    }

    @Override
    public void setValue(String value, boolean first) {
        if (value != null) {
            if (first) {
                this.addressesOrValues.add(0, new AddressOrValue(value));
            } else {
                this.addAddrOrValue(new AddressOrValue(value));
            }
        }
    }

    private boolean addAddrOrValue(AddressOrValue addrOrValue) {
        boolean retVal = this.addressesOrValues.add(addrOrValue);
        if (this._name.equals("P-Asserted-Identity")) {
            Collections.sort(this.addressesOrValues, new Comparator<AddressOrValue>(){

                @Override
                public int compare(AddressOrValue o1, AddressOrValue o2) {
                    try {
                        int w1 = this.getWeight(o1);
                        int w2 = this.getWeight(o2);
                        if (w1 - w2 > 0) {
                            return 1;
                        }
                        if (w1 - w2 < 0) {
                            return -1;
                        }
                    }
                    catch (ServletParseException servletParseException) {
                        // empty catch block
                    }
                    return 0;
                }

                private int getWeight(AddressOrValue o) throws ServletParseException {
                    boolean value = false;
                    if (o.getAddressValue().getURI().getScheme().equals("sip")) {
                        return 0;
                    }
                    if (o.getAddressValue().getURI().getScheme().equals("sips")) {
                        return 1;
                    }
                    return 2;
                }
            });
        }
        return retVal;
    }

    @Override
    public Address getAddressValue() throws ServletParseException {
        if (!this.addressesOrValues.isEmpty()) {
            return this.addressesOrValues.get(0).getAddressValue();
        }
        return null;
    }

    @Override
    public void setAddressValue(Address address, boolean first) {
        if (first) {
            this.addressesOrValues.add(0, new AddressOrValue(address));
        } else {
            this.addAddrOrValue(new AddressOrValue(address));
        }
    }

    @Override
    public ListIterator<String> getValues() {
        final ListIterator<AddressOrValue> addressIterator = this.addressesOrValues.listIterator();
        return new ListIterator<String>(){

            @Override
            public boolean hasNext() {
                return addressIterator.hasNext();
            }

            @Override
            public String next() {
                return ((AddressOrValue)addressIterator.next()).toString();
            }

            @Override
            public boolean hasPrevious() {
                return addressIterator.hasPrevious();
            }

            @Override
            public String previous() {
                return ((AddressOrValue)addressIterator.previous()).toString();
            }

            @Override
            public int nextIndex() {
                return addressIterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                return addressIterator.previousIndex();
            }

            @Override
            public void remove() {
                if (MultiLineHeader.this._readOnly) {
                    throw new IllegalStateException("You can not modify a system header!");
                }
                addressIterator.remove();
            }

            @Override
            public void set(String o) {
                if (MultiLineHeader.this._readOnly) {
                    throw new IllegalStateException("You can not modify a system header!");
                }
                addressIterator.set(new AddressOrValue(o));
            }

            @Override
            public void add(String o) {
                if (MultiLineHeader.this._readOnly) {
                    throw new IllegalStateException("You can not modify a system header!");
                }
                addressIterator.add(new AddressOrValue(o));
            }
        };
    }

    @Override
    public ListIterator<Address> getAddressValues() throws ServletParseException {
        for (AddressOrValue address : this.addressesOrValues) {
            address.getAddressValue();
        }
        final ListIterator<AddressOrValue> addressIterator = this.addressesOrValues.listIterator();
        return new ListIterator<Address>(){

            @Override
            public boolean hasNext() {
                return addressIterator.hasNext();
            }

            @Override
            public Address next() {
                try {
                    return ((AddressOrValue)addressIterator.next()).getAddressValue();
                }
                catch (ServletParseException e) {
                    throw new IllegalStateException(MultiLineHeader.LIST_ALTERED_ERROR_REASON);
                }
            }

            @Override
            public boolean hasPrevious() {
                return addressIterator.hasPrevious();
            }

            @Override
            public Address previous() {
                try {
                    return ((AddressOrValue)addressIterator.previous()).getAddressValue();
                }
                catch (ServletParseException e) {
                    throw new IllegalStateException(MultiLineHeader.LIST_ALTERED_ERROR_REASON);
                }
            }

            @Override
            public int nextIndex() {
                return addressIterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                return addressIterator.previousIndex();
            }

            @Override
            public void remove() {
                if (MultiLineHeader.this._readOnly) {
                    throw new IllegalStateException("You can not modify a system header!");
                }
                addressIterator.remove();
            }

            @Override
            public void set(Address o) {
                if (MultiLineHeader.this._readOnly) {
                    throw new IllegalStateException("You can not modify a system header!");
                }
                addressIterator.set(new AddressOrValue(o));
            }

            @Override
            public void add(Address o) {
                if (MultiLineHeader.this._readOnly) {
                    throw new IllegalStateException("You can not modify a system header!");
                }
                addressIterator.add(new AddressOrValue(o));
            }
        };
    }

    @Override
    public void removeValues() {
        this.addressesOrValues.clear();
    }

    @Override
    public void merge(Header other) {
        if (!(other instanceof MultiLineHeader) || !this._name.equals(other._name)) {
            throw new UnsupportedOperationException();
        }
        MultiLineHeader mlh = (MultiLineHeader)other;
        this.addressesOrValues.addAll(mlh.addressesOrValues);
        this._multiValuesOnSameLineIndicator.addAll(mlh._multiValuesOnSameLineIndicator);
    }

    public String toString() {
        if (!this.addressesOrValues.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator<AddressOrValue> i = this.addressesOrValues.iterator();
            Iterator newline = this._multiValuesOnSameLineIndicator.iterator();
            sb.append(this._name);
            sb.append(": ");
            while (i.hasNext()) {
                sb.append(i.next().toString());
                boolean nextIsOnSameLine = false;
                if (newline.hasNext()) {
                    Boolean aB = (Boolean)newline.next();
                    nextIsOnSameLine = aB;
                }
                if (i.hasNext() && nextIsOnSameLine) {
                    sb.append(", ");
                    continue;
                }
                if (!i.hasNext()) {
                    sb.append("\r\n");
                    continue;
                }
                sb.append("\r\n");
                sb.append(this._name);
                sb.append(": ");
            }
            return sb.toString();
        }
        return "";
    }
}

