/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.CreatedTargetSet;
import com.ericsson.ssa.sip.TargetSet;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelTargetSet
extends TargetSet {
    private List<TargetSet> _targetSets = null;
    private boolean _isStarted = false;
    private final boolean _isRecurse;

    public ParallelTargetSet(CreatedTargetSet t, boolean isRecurse) {
        super(t.getProxyImpl());
        this._isRecurse = isRecurse;
        this._targetSets = new ArrayList<TargetSet>(t.getTargetSets());
        for (TargetSet child : this.getTargetSets()) {
            child.setParent(this);
        }
    }

    @Override
    protected List<TargetSet> getTargetSets() {
        return this._targetSets;
    }

    @Override
    public void proxyTo() throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        this._isStarted = true;
        for (TargetSet t : this.getTargetSets()) {
            t.proxyTo();
        }
    }

    @Override
    public void cancel() throws IllegalStateException {
        if (this.isStarted()) {
            for (TargetSet t : this.getTargetSets()) {
                t.cancel();
            }
        }
    }

    @Override
    public boolean getParallel() {
        return true;
    }

    @Override
    public boolean isStarted() {
        return this._isStarted;
    }

    @Override
    public boolean getRecurse() {
        return this._isRecurse;
    }
}

