/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.container.SipContainerThreadPool;
import com.ericsson.ssa.sip.AddressImpl;
import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.PathNode;
import com.ericsson.ssa.sip.ProxyContext;
import com.ericsson.ssa.sip.ProxyImpl;
import com.ericsson.ssa.sip.SessionManager;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.TargetSet;
import com.ericsson.ssa.sip.timer.ServletTimerImpl;
import com.ericsson.ssa.sip.timer.TimerServiceImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyBranchImpl
extends TargetSet
implements ProxyBranch,
TimerListener {
    protected static final Logger _log = Logger.getLogger("SipContainer");
    static int TimerC = 180;
    private SipServletResponseImpl _bestResponse = null;
    private SipServletResponse _lastResponse = null;
    private final SipServletRequestImpl _request;
    private ServletTimerImpl _timer = null;
    private int _proxyBranchTimeout = 0;
    private SipURI _outboundURI;
    private List<ProxyBranchImpl> _proxyBranches = null;
    private boolean _isCanceled = false;
    private boolean _pendingCancel = false;
    private SipServletResponseImpl _provisional = null;

    public ProxyBranchImpl(ProxyImpl p, SipServletRequestImpl request) {
        super(p);
        this._request = request;
    }

    @Override
    protected List<TargetSet> getTargetSets() {
        if (this.getRecursedProxyBranchesImpl() == null) {
            return super.getTargetSets();
        }
        return new ArrayList<TargetSet>(this.getRecursedProxyBranchesImpl());
    }

    @Override
    public synchronized SipServletResponseImpl findBestResponse() {
        if (this._bestResponse != null && this._bestResponse.isAlreadyRedirected() && this.getRecursedProxyBranchesImpl() != null) {
            return super.findBestResponse();
        }
        return this._bestResponse;
    }

    public synchronized SipServletResponseImpl getBestResponse() {
        return this._bestResponse;
    }

    private synchronized void setBestResponse(SipServletResponseImpl resp) {
        int bestStatus;
        int n = bestStatus = this._bestResponse == null ? 700 : this._bestResponse.getStatus();
        if (bestStatus / 100 != 2) {
            int status = resp.getStatus() / 100;
            if (status == 2) {
                this._bestResponse = resp;
            } else if (status == 6) {
                this._bestResponse = resp;
            } else if (status > 2 && status < 6 && bestStatus / 100 != 6 && resp.getStatus() < bestStatus) {
                this._bestResponse = resp;
            }
        }
    }

    @Override
    public ProxyBranchImpl findBranch(URI uri) {
        ProxyBranchImpl branch;
        if (this.getRecurse() && (branch = super.findBranch(uri)) != null) {
            return branch;
        }
        return uri.equals(this._request.getRequestURI()) ? this : null;
    }

    @Override
    public void addTopLevelBranch(List<ProxyBranchImpl> branches) {
        branches.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimer(SipServletResponseImpl resp) {
        if (this._timer == null) {
            ProxyBranchImpl proxyBranchImpl = this;
            synchronized (proxyBranchImpl) {
                if (this._timer == null) {
                    int time = -1;
                    if (this.getParallel()) {
                        time = this.getProxyBranchTimeout() > 0 && this.getProxyBranchTimeout() < this.getProxy().getProxyTimeout() ? this.getProxyBranchTimeout() * 1000 : this.getProxy().getProxyTimeout() * 1000;
                    } else {
                        time = this.getProxyBranchTimeout() > 0 ? this.getProxyBranchTimeout() * 1000 : this.getProxy().getProxyTimeout() * 1000;
                        int n = time = time < TimerC * 1000 ? time : TimerC * 1000;
                    }
                    if (_log.isLoggable(Level.FINE)) {
                        _log.log(Level.FINE, "start timer " + time / 1000 + " sec for branch = " + this._request.getRequestURI());
                    }
                    this.setProvisionalResponse(resp);
                    this._timer = TimerServiceImpl.getInstance().createTimer(this, (long)time, false, null);
                }
            }
        }
    }

    private synchronized void stopTimer() {
        if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doInitialResponse(SipServletResponseImpl resp, ProxyContext pc) {
        this.setLastResponse(resp);
        int status = resp.getStatus() / 100;
        if (status == 1) {
            if (resp.getMethod().equals("INVITE") && this.isPendingCancel()) {
                SipServletRequestImpl cancel;
                ProxyBranchImpl proxyBranchImpl = this;
                synchronized (proxyBranchImpl) {
                    this.setProvisionalResponse(resp);
                    if (_log.isLoggable(Level.INFO)) {
                        _log.log(Level.INFO, "CANCEL is pending, lets cancel this branch " + this._request.getRequestURI() + " for response " + resp.getStatus());
                    }
                    if ((cancel = this.cancelIntern()) != null) {
                        this.setCanceled();
                    }
                }
                if (cancel != null) {
                    SipContainerThreadPool.getInstance().execute(new Runnable(){

                        public void run() {
                            cancel.popDispatcher().dispatch(cancel);
                        }
                    });
                }
            } else {
                this.startTimer(resp);
            }
            this.getProxyImpl().invokeServletAndForward(resp, pc);
        } else {
            this.setBestResponse(resp);
            this.stopTimer();
            if (status == 3 && this.getProxy().getRecurse()) {
                AddressImpl address = null;
                URI uri = null;
                ArrayList<URI> contacts = new ArrayList<URI>();
                ListIterator<String> contactsIt = resp.getHeaders("Contact");
                while (contactsIt.hasNext()) {
                    String contact = contactsIt.next();
                    try {
                        address = new AddressImpl(contact);
                        uri = address.getURI();
                        contacts.add(uri);
                    }
                    catch (ServletParseException e) {
                        if (!_log.isLoggable(Level.WARNING)) continue;
                        _log.log(Level.WARNING, "Could not recurse on Contact = " + contact);
                    }
                }
                if (contacts.size() > 0) {
                    List<ProxyBranchImpl> branches = this.getProxyImpl().recurseTo(resp.getRequestImpl(), contacts);
                    this.addRecursedProxyBranches(branches);
                }
                resp.setAlreadyRedirected();
            } else if (this.getParent().hasNext()) {
                if (_log.isLoggable(Level.FINE)) {
                    _log.log(Level.FINE, "start next branch");
                }
                this.getParent().next();
            }
        }
        return false;
    }

    public Proxy getProxy() {
        try {
            return this.getProxyImpl().getOriginalRequestImpl().getProxy();
        }
        catch (TooManyHopsException e) {
            return null;
        }
    }

    public int getProxyBranchTimeout() {
        return this._proxyBranchTimeout;
    }

    private synchronized List<ProxyBranchImpl> getRecursedProxyBranchesImpl() {
        return this._proxyBranches;
    }

    private synchronized void addRecursedProxyBranches(List<ProxyBranchImpl> branches) {
        if (this._proxyBranches == null) {
            this._proxyBranches = branches;
        } else {
            this._proxyBranches.addAll(branches);
        }
    }

    public List<ProxyBranch> getRecursedProxyBranches() {
        List<ProxyBranchImpl> branches = this.getRecursedProxyBranchesImpl();
        return branches == null ? null : new ArrayList<ProxyBranchImpl>(branches);
    }

    private synchronized void setLastResponse(SipServletResponse resp) {
        this._lastResponse = resp;
    }

    public synchronized SipServletResponse getResponse() {
        return this._lastResponse;
    }

    public SipServletRequest getRequest() {
        return this._request;
    }

    public SipServletRequestImpl getRequestImpl() {
        return this._request;
    }

    @Override
    public boolean getParallel() {
        return this.getParent().getParallel();
    }

    @Override
    public boolean isStarted() {
        return this.getParent().isStarted();
    }

    @Override
    public boolean getRecurse() {
        return this.getParent().getRecurse();
    }

    public void setOutboundInterface(SipURI uri) {
        this._outboundURI = uri;
    }

    public void setProxyBranchTimeout(int seconds) {
        this._proxyBranchTimeout = seconds;
    }

    public void timeout(ServletTimer timer) {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "timer fired for branch = " + this._request.getRequestURI());
        }
        if (this.getBestResponse() == null) {
            this.cancel();
            if (this.getParent().hasNext()) {
                if (_log.isLoggable(Level.FINE)) {
                    _log.log(Level.FINE, "start next branch");
                }
                this.getParent().next();
            }
        }
    }

    @Override
    public void proxyTo() throws IllegalStateException {
        this.prepareProxyTo();
        final SipServletRequestImpl clone = (SipServletRequestImpl)this.getRequestImpl().clone();
        clone.pushTransactionDispatcher(this.getRequestImpl().getProxyContext());
        clone.setTransactionRequest(this.getRequestImpl());
        clone.setSent(true);
        SipContainerThreadPool.getInstance().execute(new Runnable(){

            public void run() {
                if (_log.isLoggable(Level.FINE)) {
                    _log.log(Level.FINE, "Proxy request " + clone.toDebugString() + ", " + this.toString());
                }
                clone.popDispatcher().dispatch(clone);
            }
        });
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "Lets leave...");
        }
    }

    protected void prepareProxyTo() throws IllegalStateException {
        if (this.getParent() == null) {
            throw new IllegalStateException("Need to add parent target set before calling.");
        }
        if (this.getProxyImpl().isFirstProxyBranchSetAndTest()) {
            this.getRequestImpl().getDialog().addToPath(this.getRequestImpl().getProxyContext());
        } else {
            DialogFragment clone = this.getRequestImpl().getDialog().cloneFromCallerToCalleeUntil(this.getRequestImpl().getProxyContext(), false);
            this.getRequestImpl().setDialog(clone);
            this.getRequestImpl().setFragmentId(clone.getFragmentId());
            if (this.getRequestImpl().isContactIndicated()) {
                Header contact = this.getRequestImpl().getRawHeader("Contact");
                contact.setReadOnly(false);
                contact.removeValues();
                SessionManager.getInstance().addContact(this.getRequestImpl());
            }
            PathNode p = null;
            int size = 0;
            Iterator<PathNode> i = clone.getCallee2CallerPath();
            if (i.hasNext()) {
                i.next();
            }
            while (i.hasNext()) {
                p = i.next();
                if (!this.getRequestImpl().getSupervised()) continue;
                size = this.getRequestImpl()._transactionStack.size();
                this.getRequestImpl()._transactionStack.remove(size - 1);
            }
            i = clone.getCallee2CallerPath();
            if (i.hasNext()) {
                ProxyContext pc = (ProxyContext)i.next();
                this.getRequestImpl().setProxyContext(pc);
            }
            while (i.hasNext()) {
                p = i.next();
                if (!this.getRequestImpl().getSupervised()) continue;
                this.getRequestImpl().pushTransactionDispatcher(p);
            }
        }
        if (this.getProxy().getRecordRoute()) {
            this.getRequestImpl().indicateRecordRoute();
        }
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, this.getRequestImpl().toDebugString() + ", " + this.toString());
        }
    }

    private void setProvisionalResponse(SipServletResponseImpl resp) {
        this._provisional = resp;
    }

    private SipServletResponseImpl getProvisionalResponse() {
        return this._provisional;
    }

    private SipServletRequestImpl createCancel() {
        SipServletRequestImpl cancel = this._request.createCancelImpl();
        SipServletResponseImpl provisonal = this.getProvisionalResponse();
        cancel.setHeader(provisonal.getCancelVia());
        PathNode next = provisonal.getPreviousVisited();
        if (next != null) {
            cancel.pushApplicationDispatcher(next);
        }
        this.setProvisionalResponse(null);
        return cancel;
    }

    public boolean isPendingCancel() {
        return this._pendingCancel;
    }

    public void setPendingCancel() {
        this._pendingCancel = true;
    }

    private synchronized boolean isCanceled() {
        return this._isCanceled;
    }

    private void setCanceled() {
        this._isCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        SipServletRequestImpl cancel = null;
        ProxyBranchImpl proxyBranchImpl = this;
        synchronized (proxyBranchImpl) {
            cancel = this.cancelIntern();
        }
        if (cancel != null) {
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, cancel + " will be sent for branch = " + this._request.getRequestURI());
            }
            cancel.popDispatcher().dispatch(cancel);
            proxyBranchImpl = this;
            synchronized (proxyBranchImpl) {
                this.setCanceled();
            }
        }
    }

    private SipServletRequestImpl cancelIntern() {
        SipServletRequestImpl cancel = null;
        if (!this.isCanceled()) {
            SipServletResponseImpl bestResp = this.getBestResponse();
            if (bestResp == null) {
                if (this.getProvisionalResponse() == null) {
                    if (_log.isLoggable(Level.FINE)) {
                        _log.log(Level.FINE, "pending CANCEL for branch = " + this._request.getRequestURI());
                    }
                    this.setPendingCancel();
                } else {
                    cancel = this.createCancel();
                    if (_log.isLoggable(Level.FINE)) {
                        _log.log(Level.FINE, cancel.toDebugString());
                    }
                }
            } else if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "Will not CANCEL, already got final response " + bestResp.getStatus() + " for current branch = " + this._request.getRequestURI());
            }
        } else if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "CANCEL already for branch = " + this._request.getRequestURI());
        }
        return cancel;
    }
}

