/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.CreatedTargetSet;
import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.ParallelTargetSet;
import com.ericsson.ssa.sip.PathNode;
import com.ericsson.ssa.sip.ProxyBranchImpl;
import com.ericsson.ssa.sip.ProxyContext;
import com.ericsson.ssa.sip.SequentialTargetSet;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.SipSessionBase;
import com.ericsson.ssa.sip.SipURIImpl;
import com.ericsson.ssa.sip.TargetSet;
import com.ericsson.ssa.sip.VirtualProxyBranchImpl;
import com.ericsson.ssa.sip.dns.TargetResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyImpl {
    private static final Logger _log = Logger.getLogger("SipContainer");
    private static final URI _virtualProxyBranchURI = new SipURIImpl(false, "proxy_uas", "localhost");
    private SipApplicationSessionImpl _sipApplicationSession = null;
    private SipServletRequestImpl _originalRequest = null;
    private boolean _isRecordRoute = false;
    private boolean _isRecurse = true;
    private boolean _isParallel = true;
    private int _proxyTimeout = ProxyBranchImpl.TimerC;
    private SipServletResponseImpl _bestResponse = null;
    private boolean _is6xx = false;
    private final Collection<TargetSet> _targetSets = new ConcurrentLinkedQueue<TargetSet>();
    private CreatedTargetSet _createdSet = new CreatedTargetSet(this);
    private boolean _isFirst = true;
    private ProxyBranchImpl _virtualProxyBranch = null;

    public ProxyImpl(SipApplicationSessionImpl appSession, SipServletRequestImpl originalRequest) {
        this._sipApplicationSession = appSession;
        this._originalRequest = originalRequest;
        SipSessionBase s = originalRequest.getSessionImpl();
        s.setType(this.getType());
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "ProxyImpl reference = " + this);
        }
    }

    public PathNode.Type getType() {
        return PathNode.Type.Proxy;
    }

    public Collection<TargetSet> getTargetSets() {
        return this._targetSets;
    }

    private void setDerivedOrOriginalSession(SipServletRequestImpl req, ProxyContext pc) throws IOException, ServletException {
        if (req.getMethod().equals("NOTIFY")) {
            req.indicateRecordRoute();
            if (!pc.getSipSession().hasNoToTag() && req.getDialog().getToTag() != null && req.getDialog().getToTag().equals(pc.getSipSession().getToTag())) {
                req.setSession(pc.getSipSession());
            } else {
                DialogFragment df = req.getDialog();
                SipSessionBase s = pc.getSipSession().getOriginalOrDerivedSessionAndRegisterDialog(req, df);
                if (s.isDerived()) {
                    req.setSession(s);
                    pc.setSipSession(s);
                }
            }
        } else {
            req.setSession(pc.getSipSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(SipServletRequestImpl req, ProxyContext pc) {
        block35: {
            int maxForwards;
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, req.toDebugString());
            }
            if ((maxForwards = req.getMaxForwards()) == 0) {
                SipServletResponseImpl response;
                if (_log.isLoggable(Level.INFO)) {
                    _log.log(Level.INFO, "Too Many Hops for request = " + req);
                }
                if ((response = req.createTerminatingResponse(483)) != null) {
                    response.popDispatcher().dispatch(response);
                }
                return;
            }
            maxForwards = maxForwards == -1 ? 70 : --maxForwards;
            req.setMaxForwards(maxForwards);
            if (req.getMethod().equals("CANCEL")) {
                if (!this.getTargetSets().isEmpty()) {
                    this.cancelIntern();
                } else {
                    ProxyImpl response = this;
                    synchronized (response) {
                        if (this._bestResponse == null) {
                            this._bestResponse = this.getOriginalRequestImpl().createTerminatingResponse(487);
                        }
                    }
                    if (this._bestResponse != null) {
                        this._bestResponse.popDispatcher().dispatch(this._bestResponse);
                    }
                }
                SipServletResponseImpl resp = req.createTerminatingResponse(200);
                resp.setRemote(req.getRemote());
                resp.popDispatcher().dispatch(resp);
                try {
                    this.setDerivedOrOriginalSession(req, pc);
                    Servlet s = this.getServlet(pc.getSipSession().getHandler());
                    if (s != null) {
                        req.setProxyContext(pc);
                        s.service((ServletRequest)req, null);
                    } else if (_log.isLoggable(Level.INFO)) {
                        _log.log(Level.INFO, "Could not find servlet name: " + req.getSessionImpl().getHandler() + " in application: " + req.getSessionImpl().getApplicationSessionImpl().getName());
                    }
                    break block35;
                }
                catch (Exception e) {
                    if (this._bestResponse != null) break block35;
                    ProxyImpl proxyImpl = this;
                    synchronized (proxyImpl) {
                        if (this._bestResponse == null) {
                            this._bestResponse = this.getOriginalRequestImpl().createTerminatingResponse(500);
                        }
                    }
                    if (this._bestResponse != null) {
                        this._bestResponse.popDispatcher().dispatch(this._bestResponse);
                    }
                    break block35;
                }
            }
            if (this.getRecordRoute()) {
                try {
                    this.setDerivedOrOriginalSession(req, pc);
                    Servlet s = this.getServlet(pc.getSipSession().getHandler());
                    if (s != null) {
                        req.setProxyContext(pc);
                        s.service((ServletRequest)req, null);
                        if (req.getSupervised()) {
                            SipServletRequestImpl clone = (SipServletRequestImpl)req.clone();
                            clone.pushTransactionDispatcher(pc);
                            clone.setTransactionRequest(req);
                            clone.popDispatcher().dispatch(clone);
                        } else {
                            req.popDispatcher().dispatch(req);
                        }
                    } else if (_log.isLoggable(Level.INFO)) {
                        _log.log(Level.INFO, "Could not find servlet name: " + req.getSessionImpl().getHandler() + " in application: " + req.getSessionImpl().getApplicationSessionImpl().getName());
                    }
                    break block35;
                }
                catch (Exception e) {
                    if (_log.isLoggable(Level.FINE)) {
                        _log.log(Level.FINE, "Problem in servlet ", e);
                    }
                    ProxyImpl proxyImpl = this;
                    synchronized (proxyImpl) {
                        this._bestResponse = req.createTerminatingResponse(500);
                    }
                    if (this._bestResponse != null) {
                        this._bestResponse.popDispatcher().dispatch(this._bestResponse);
                    }
                    break block35;
                }
            }
            req.popDispatcher().dispatch(req);
        }
    }

    private void invokeServlet(SipServletResponseImpl resp) throws IOException, ServletException {
        if (resp.getStatus() != 100) {
            Servlet s = this.getServlet(resp.getSessionImpl().getHandler());
            if (s != null) {
                s.service(null, (ServletResponse)resp);
            } else if (_log.isLoggable(Level.INFO)) {
                _log.log(Level.INFO, "Could not find servlet name: " + resp.getSessionImpl().getHandler() + " in application: " + resp.getSessionImpl().getApplicationSessionImpl().getName());
            }
        }
    }

    private void dispatchAndClone(SipServletResponseImpl resp) {
        SipServletResponseImpl clone = (SipServletResponseImpl)resp.clone();
        SipServletRequestImpl req = resp.getRequestImpl().getTransactionRequest();
        if (req != null) {
            clone.setRequest(req);
            clone.setSession(req.getSessionImpl());
        }
        clone.popDispatcher().dispatch(clone);
    }

    private void assignSession(SipServletResponseImpl resp, ProxyContext pc) throws IOException, ServletException {
        if (resp.getStatus() != 100) {
            if (!pc.getSipSession().hasNoToTag() && resp.getDialog().getToTag() != null && resp.getDialog().getToTag().equals(pc.getSipSession().getToTag())) {
                resp.setSession(pc.getSipSession());
            } else {
                DialogFragment df = resp.getDialog();
                SipSessionBase s = resp.getSessionImpl().getOriginalOrDerivedSessionAndRegisterDialog(resp, df);
                if (s.isDerived()) {
                    resp.setSession(s);
                }
                pc.setSipSession(s);
            }
        }
    }

    public void invokeServletAndForward(SipServletResponseImpl resp, ProxyContext pc) {
        block4: {
            try {
                this.assignSession(resp, pc);
                if (resp.getRequestImpl().getSupervised()) {
                    this.invokeServlet(resp);
                    this.dispatchAndClone(resp);
                } else {
                    resp.popDispatcher().dispatch(resp);
                }
            }
            catch (Exception e) {
                if (!_log.isLoggable(Level.INFO)) break block4;
                _log.log(Level.INFO, "Problem in servlet.", e);
            }
        }
    }

    private void doInitialResponse(SipServletResponseImpl resp, ProxyContext pc) {
        block18: {
            int status = resp.getStatus() / 100;
            if (status != 1) {
                SipServletResponseImpl bestResp;
                if (status == 2) {
                    if (this.setAndTestBestResponse(resp) == null) {
                        this.cancelIntern();
                        this.invokeServletAndForward(resp, pc);
                    } else if (resp.getMethod().equals("INVITE")) {
                        this.invokeServletAndForward(resp, pc);
                    }
                } else if (status == 6) {
                    if (!this.setAndTest6xx()) {
                        this.cancelIntern();
                        SipServletResponseImpl bestResp2 = this.findBestResponse();
                        if (bestResp2 != null && this.setAndTestBestResponse(bestResp2) == null) {
                            this.invokeServletAndForward(bestResp2, pc);
                        }
                    }
                } else if (status > 2 && status < 6 && (bestResp = this.findBestResponse()) != null) {
                    try {
                        if (!this.hasBestResponse()) {
                            this.assignSession(bestResp, pc);
                            if (bestResp.getRequestImpl().getSupervised()) {
                                this.invokeServlet(bestResp);
                                bestResp.setAlreadyRedirected();
                                bestResp = this.findBestResponse();
                                if (bestResp != null && this.setAndTestBestResponse(bestResp) == null) {
                                    bestResp.popDispatcher().dispatch(bestResp);
                                }
                            } else if (this.setAndTestBestResponse(bestResp) == null) {
                                bestResp.popDispatcher().dispatch(bestResp);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!_log.isLoggable(Level.INFO)) break block18;
                        _log.log(Level.INFO, "Problem in servlet.", e);
                    }
                }
            }
        }
    }

    public void dispatch(SipServletResponseImpl resp, ProxyContext pc) {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, resp.toDebugString());
        }
        if (resp.getRequest().isInitial()) {
            if (!this.hasBestResponse()) {
                ProxyBranchImpl branch = this.findBranch(resp.getRequest().getRequestURI());
                if (branch != null) {
                    if (branch.doInitialResponse(resp, pc) && (this.findBestResponse() != null || resp.getStatus() / 100 == 2)) {
                        if (this.setAndTestBestResponse(resp) == null) {
                            resp.getRequestImpl().setSupervised(false);
                            this.setRecordRoute(false);
                            resp.popDispatcher().dispatch(resp);
                        }
                    } else {
                        this.doInitialResponse(resp, pc);
                    }
                } else if (_log.isLoggable(Level.INFO)) {
                    _log.log(Level.INFO, "Could not find ProxyBranch of response: " + resp);
                }
            } else if (resp.getStatus() / 100 == 2 && resp.getMethod().equals("INVITE")) {
                this.invokeServletAndForward(resp, pc);
            }
        } else {
            this.invokeServletAndForward(resp, pc);
        }
    }

    public SipServletRequest getOriginalRequest() {
        return this.getOriginalRequestImpl();
    }

    public SipServletRequestImpl getOriginalRequestImpl() {
        return this._originalRequest;
    }

    public SipServletRequestImpl cloneOriginalRequest() {
        SipServletRequestImpl clone = (SipServletRequestImpl)this._originalRequest.clone();
        clone.setProxyContext(this._originalRequest.getProxyContext());
        clone.setTransactionRequest(this._originalRequest.getTransactionRequest());
        return clone;
    }

    public void cancel() throws IllegalStateException {
        if (this.hasBestResponse() || this.has6xx()) {
            throw new IllegalStateException("Proxy has already completed");
        }
        this.cancelIntern();
    }

    public void cancelIntern() {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "CANCEL proxy");
        }
        this.getCreatedTarget().getTargetSets().clear();
        for (TargetSet t : this.getTargetSets()) {
            t.cancel();
        }
    }

    public boolean getRecurse() {
        return this._isRecurse;
    }

    public void setRecurse(boolean recurse) {
        this._isRecurse = recurse;
    }

    public boolean getRecordRoute() {
        return this._isRecordRoute;
    }

    public void setRecordRoute(boolean recordRoute) {
        this._isRecordRoute = recordRoute;
    }

    public boolean getParallel() {
        return this._isParallel;
    }

    public void setParallel(boolean parallel) {
        this._isParallel = parallel;
    }

    public boolean getStateful() {
        return true;
    }

    @Deprecated
    public void setStateful(boolean stateful) {
    }

    public int getProxyTimeout() {
        return this._proxyTimeout;
    }

    @Deprecated
    public int getSequentialSearchTimeout() {
        return this._proxyTimeout;
    }

    public void setProxyTimeout(int timeout) {
        this._proxyTimeout = timeout;
    }

    @Deprecated
    public void setSequentialSearchTimeout(int timeout) {
        this._proxyTimeout = timeout;
    }

    public SipURI getRecordRouteURI(SipServletRequestImpl req) {
        return new RecordRouteURI(req);
    }

    public SipApplicationSessionImpl getApplicationSession() {
        return this._sipApplicationSession;
    }

    public SipSessionBase getSipSession() {
        if (this.getOriginalRequestImpl() != null) {
            return this.getOriginalRequestImpl().getSessionImpl();
        }
        return null;
    }

    public Servlet getServlet(String handler) {
        return SipFactoryImpl.getInstance().getServiceHandler().getHandler(this.getApplicationSession().getName(), handler);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString() + " isRecordRoute: ");
        sb.append(this.getRecordRoute());
        sb.append(" isStateful: ");
        sb.append(this.getStateful());
        return sb.toString();
    }

    private CreatedTargetSet getCreatedTarget() {
        return this._createdSet;
    }

    private ProxyBranchImpl createBranch(URI uri, boolean isVirtual) {
        SipServletRequestImpl req = this.createRequest(uri);
        return isVirtual ? new VirtualProxyBranchImpl(this, req) : new ProxyBranchImpl(this, req);
    }

    private SipServletRequestImpl createRequest(URI uri) {
        TargetResolver.getInstance().updateDefaultTransportParameter(uri);
        SipServletRequestImpl request = this.cloneOriginalRequest();
        request.setRequestURI(uri);
        int maxForwards = request.getMaxForwards();
        maxForwards = maxForwards == -1 ? 70 : --maxForwards;
        request.setMaxForwards(maxForwards);
        return request;
    }

    public List<ProxyBranch> getProxyBranches() {
        ArrayList<ProxyBranchImpl> branches = new ArrayList<ProxyBranchImpl>();
        for (TargetSet t : this.getTargetSets()) {
            t.addTopLevelBranch(branches);
        }
        return new ArrayList<ProxyBranch>(branches);
    }

    public ProxyBranch getProxyBranch(URI uri) {
        return this.findBranch(uri);
    }

    private ProxyBranchImpl findBranch(URI uri) {
        ProxyBranchImpl branch = null;
        for (TargetSet t : this.getTargetSets()) {
            branch = t.findBranch(uri);
            if (branch == null) continue;
            return branch;
        }
        return null;
    }

    public synchronized List<ProxyBranch> createProxyBranches(List<? extends URI> targets) {
        return this.createProxyBranchesIntern(targets);
    }

    private List<ProxyBranch> createProxyBranchesIntern(List<? extends URI> targets) {
        for (URI uRI : targets) {
            if (this.findBranch(uRI) == null) continue;
            throw new IllegalStateException("Not allowed to proxy to same destination twice = " + uRI);
        }
        ArrayList<ProxyBranch> list = new ArrayList<ProxyBranch>(targets.size());
        Object var3_4 = null;
        for (URI uRI : targets) {
            ProxyBranchImpl proxyBranchImpl = this.createBranch(uRI, false);
            this.getCreatedTarget().add(proxyBranchImpl);
            list.add(proxyBranchImpl);
        }
        return list;
    }

    private List<ProxyBranchImpl> createRecursedProxyBranchesIntern(List<? extends URI> targets) {
        ArrayList<ProxyBranchImpl> list = new ArrayList<ProxyBranchImpl>(targets.size());
        ProxyBranchImpl branch = null;
        for (URI uRI : targets) {
            branch = this.createBranch(uRI, false);
            this.getCreatedTarget().add(branch);
            list.add(branch);
        }
        return list;
    }

    public synchronized void setVirtualProxyBranchRequest(SipServletResponseImpl resp) {
        if (this._virtualProxyBranch == null) {
            this._virtualProxyBranch = this.createBranch(_virtualProxyBranchURI, true);
        }
        resp.setRequest(this._virtualProxyBranch.getRequestImpl());
    }

    public synchronized void startVirtualProxyBranch(SipServletResponseImpl resp) {
        if (this._virtualProxyBranch != null) {
            ProxyBranchImpl vpb = this.findBranch(_virtualProxyBranchURI);
            if (vpb == null) {
                this.getTargetSets().add(this._virtualProxyBranch);
                this._virtualProxyBranch.proxyTo();
                resp.setDialog(resp.getRequestImpl().getDialog());
            }
        } else {
            throw new IllegalStateException("Must first create VirtualProxyBranch");
        }
    }

    private synchronized SipServletResponseImpl findBestResponse() {
        boolean isRunning = false;
        SipServletResponseImpl bestResponse = null;
        SipServletResponseImpl currentResp = null;
        int currentStatus = -1;
        int bestStatus = 700;
        for (TargetSet t : this.getTargetSets()) {
            currentResp = t.findBestResponse();
            if (currentResp == null) {
                isRunning = true;
                continue;
            }
            currentStatus = currentResp.getStatus();
            if (currentStatus / 100 == 2) {
                return currentResp;
            }
            if (currentStatus / 100 == 6) {
                bestStatus = currentStatus;
                bestResponse = currentResp;
                continue;
            }
            if (bestStatus / 100 == 6 || bestStatus <= currentResp.getStatus()) continue;
            bestStatus = currentResp.getStatus();
            bestResponse = currentResp;
        }
        if (isRunning) {
            return null;
        }
        return bestResponse;
    }

    private synchronized SipServletResponseImpl setAndTestBestResponse(SipServletResponseImpl resp) {
        if (this._bestResponse != null) {
            return this._bestResponse;
        }
        this._bestResponse = resp;
        return null;
    }

    private synchronized boolean hasBestResponse() {
        return this._bestResponse != null;
    }

    private synchronized boolean setAndTest6xx() {
        if (this._is6xx) {
            return true;
        }
        this._is6xx = true;
        return false;
    }

    private synchronized boolean has6xx() {
        return this._is6xx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProxy(boolean isSaved) {
        if (this.getCreatedTarget().getTargetSets().isEmpty()) {
            throw new IllegalStateException("Must create branches before startProxy");
        }
        if (this.hasBestResponse() || this.has6xx()) {
            throw new IllegalStateException("Proxy has already completed");
        }
        TargetSet t = null;
        ProxyImpl proxyImpl = this;
        synchronized (proxyImpl) {
            t = this.getParallel() ? new ParallelTargetSet(this.getCreatedTarget(), this.getRecurse()) : new SequentialTargetSet(this.getCreatedTarget(), this.getRecurse());
            this.getCreatedTarget().getTargetSets().clear();
            if (isSaved) {
                this.getTargetSets().add(t);
            }
        }
        t.proxyTo();
    }

    public void proxyTo(SipServletRequestImpl req, URI uri) throws IllegalStateException {
        ArrayList<URI> uris = new ArrayList<URI>(1);
        uris.add(uri);
        this.proxyTo(req, uris);
    }

    public void proxyTo(SipServletRequestImpl req, List<? extends URI> uris) throws IllegalStateException {
        this.createProxyBranchesIntern(uris);
        this.startProxy(true);
    }

    List<ProxyBranchImpl> recurseTo(SipServletRequestImpl req, List<? extends URI> uris) throws IllegalStateException {
        List<ProxyBranchImpl> l = this.createRecursedProxyBranchesIntern(uris);
        this.startProxy(false);
        return l;
    }

    public synchronized boolean isFirstProxyBranchSetAndTest() {
        if (this._isFirst) {
            this._isFirst = false;
            return true;
        }
        return false;
    }

    public Proxy getFacade(SipServletRequestImpl request) {
        return new ProxyFacade(this, request);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProxyFacade
    implements Proxy {
        private ProxyImpl delegate;
        private SipServletRequestImpl req;

        public ProxyFacade(ProxyImpl proxy, SipServletRequestImpl reqImpl) {
            this.delegate = proxy;
            this.req = reqImpl;
        }

        public void cancel() {
            this.delegate.cancel();
        }

        public SipServletRequest getOriginalRequest() {
            return this.delegate.getOriginalRequest();
        }

        public boolean getParallel() {
            return this.delegate.getParallel();
        }

        public boolean getRecordRoute() {
            return this.delegate.getRecordRoute();
        }

        public SipURI getRecordRouteURI() {
            return this.delegate.getRecordRouteURI(this.req);
        }

        public boolean getRecurse() {
            return this.delegate.getRecurse();
        }

        public int getSequentialSearchTimeout() {
            return this.delegate.getSequentialSearchTimeout();
        }

        public boolean getStateful() {
            return this.delegate.getStateful();
        }

        public boolean getSupervised() {
            return this.req.getSupervised();
        }

        public void proxyTo(URI uri) {
            this.delegate.proxyTo(this.req, uri);
        }

        public void proxyTo(List<? extends URI> uris) {
            this.delegate.proxyTo(this.req, uris);
        }

        public void setParallel(boolean parallel) {
            this.delegate.setParallel(parallel);
        }

        public void setRecordRoute(boolean recordRoute) {
            this.delegate.setRecordRoute(recordRoute);
        }

        public void setRecurse(boolean recurse) {
            this.delegate.setRecurse(recurse);
        }

        public void setSequentialSearchTimeout(int seconds) {
            this.delegate.setSequentialSearchTimeout(seconds);
        }

        public void setStateful(boolean stateful) {
            this.delegate.setStateful(stateful);
        }

        public void setSupervised(boolean supervised) {
            this.req.setSupervised(supervised);
        }

        public List<ProxyBranch> createProxyBranches(List<? extends URI> targets) {
            return this.delegate.createProxyBranches(targets);
        }

        public boolean getAddToPath() {
            return false;
        }

        public SipURI getPathURI() {
            return null;
        }

        public ProxyBranch getProxyBranch(URI uri) {
            return this.delegate.getProxyBranch(uri);
        }

        public List<ProxyBranch> getProxyBranches() {
            return this.delegate.getProxyBranches();
        }

        public int getProxyTimeout() {
            return this.delegate.getProxyTimeout();
        }

        public void setAddToPath(boolean p) {
        }

        public void setOutboundInterface(SipURI uri) {
        }

        public void setProxyTimeout(int seconds) {
            this.delegate.setProxyTimeout(seconds);
        }

        public void startProxy() {
            this.delegate.startProxy(true);
        }
    }

    private static final class RecordRouteURI
    implements SipURI {
        private final SipServletRequestImpl req;

        private RecordRouteURI(SipServletRequestImpl req) {
            this.req = req;
        }

        public Object clone() {
            throw new UnsupportedOperationException();
        }

        public String getHeader(String name) {
            throw new UnsupportedOperationException();
        }

        public Iterator getHeaderNames() {
            throw new UnsupportedOperationException();
        }

        public String getHost() {
            throw new UnsupportedOperationException();
        }

        public boolean getLrParam() {
            throw new UnsupportedOperationException();
        }

        public String getMAddrParam() {
            throw new UnsupportedOperationException();
        }

        public String getMethodParam() {
            throw new UnsupportedOperationException();
        }

        public String getParameter(String name) {
            return this.req.getRecordRouteURIParam(name);
        }

        public Iterator getParameterNames() {
            return this.req.getRecordRouteURIParamNames();
        }

        public int getPort() {
            throw new UnsupportedOperationException();
        }

        public int getTTLParam() {
            throw new UnsupportedOperationException();
        }

        public String getTransportParam() {
            throw new UnsupportedOperationException();
        }

        public String getUser() {
            throw new UnsupportedOperationException();
        }

        public String getUserParam() {
            throw new UnsupportedOperationException();
        }

        public String getUserPassword() {
            throw new UnsupportedOperationException();
        }

        public boolean isSecure() {
            throw new UnsupportedOperationException();
        }

        public void removeParameter(String name) {
            this.req.removeRecordRouteURIParam(name);
        }

        public void setHeader(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public void setHost(String host) {
            throw new UnsupportedOperationException();
        }

        public void setLrParam(boolean lr) {
            throw new UnsupportedOperationException();
        }

        public void setMAddrParam(String mAddr) {
            throw new UnsupportedOperationException();
        }

        public void setMethodParam(String methodParam) {
            throw new UnsupportedOperationException();
        }

        public void setParameter(String name, String value) {
            this.req.setRecordRouteURIParam(name, value);
        }

        public void setPort(int port) {
            throw new UnsupportedOperationException();
        }

        public void setSecure(boolean sips) {
            throw new UnsupportedOperationException();
        }

        public void setTTLParam(int ttl) {
            throw new UnsupportedOperationException();
        }

        public void setTransportParam(String transport) {
            throw new UnsupportedOperationException();
        }

        public void setUser(String user) {
            throw new UnsupportedOperationException();
        }

        public void setUserParam(String userParam) {
            throw new UnsupportedOperationException();
        }

        public void setUserPassword(String password) {
            throw new UnsupportedOperationException();
        }

        public String getScheme() {
            throw new UnsupportedOperationException();
        }

        public boolean isSipURI() {
            throw new UnsupportedOperationException();
        }
    }
}

