/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.CreatedTargetSet;
import com.ericsson.ssa.sip.TargetSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequentialTargetSet
extends TargetSet {
    private static final Logger _log = Logger.getLogger("SipContainer");
    private List<TargetSet> _targetSets = null;
    private Iterator<TargetSet> _iter = null;
    private boolean _isStarted = false;
    private final boolean _isRecurse;

    public SequentialTargetSet(CreatedTargetSet t, boolean isRecurse) {
        super(t.getProxyImpl());
        this._isRecurse = isRecurse;
        this._targetSets = new ArrayList<TargetSet>(t.getTargetSets());
        for (TargetSet child : this.getTargetSets()) {
            child.setParent(this);
        }
    }

    @Override
    protected List<TargetSet> getTargetSets() {
        return this._targetSets;
    }

    @Override
    public boolean hasNext() {
        return this._iter.hasNext();
    }

    @Override
    public void next() {
        TargetSet t = this._iter.next();
        try {
            t.proxyTo();
        }
        catch (IllegalStateException e) {
            if (_log.isLoggable(Level.WARNING)) {
                _log.log(Level.WARNING, "Failed to proxy request. ", e);
            }
            this.getTargetSets().remove(t);
        }
    }

    @Override
    public void proxyTo() throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        this._isStarted = true;
        this._iter = this.getTargetSets().iterator();
        if (this.hasNext()) {
            this.next();
        }
    }

    @Override
    public void cancel() throws IllegalStateException {
        if (this.isStarted()) {
            for (TargetSet t : this.getTargetSets()) {
                t.cancel();
            }
        }
    }

    @Override
    public boolean getParallel() {
        return false;
    }

    @Override
    public boolean isStarted() {
        return this._isStarted;
    }

    @Override
    public boolean getRecurse() {
        return this._isRecurse;
    }
}

