/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.AddressImpl;
import com.ericsson.ssa.sip.AddressOrValue;
import com.ericsson.ssa.sip.Header;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SingleLineHeader
extends Header
implements Externalizable {
    private static final long serialVersionUID = 3256437027846566967L;
    private AddressOrValue addressOrValue;

    public SingleLineHeader(String pretty, boolean systemHeader) {
        super(pretty, systemHeader, true);
    }

    public SingleLineHeader() {
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeUTF(this.addressOrValue != null ? this.addressOrValue.toString() : "");
        super.writeExternal(output);
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException {
        this.addressOrValue = new AddressOrValue(input.readUTF());
        super.readExternal(input);
    }

    @Override
    protected Object clone() {
        SingleLineHeader newHeader = new SingleLineHeader(new String(this._name), this._readOnly);
        if (this.addressOrValue != null) {
            newHeader.addressOrValue = (AddressOrValue)this.addressOrValue.clone();
        }
        return newHeader;
    }

    @Override
    public String getValue() {
        if (this.addressOrValue != null) {
            return this.addressOrValue.toString();
        }
        return null;
    }

    @Override
    public void setValue(String value, boolean ignore) {
        if (value != null) {
            if (this.addressOrValue == null) {
                this.addressOrValue = new AddressOrValue(value);
            } else {
                this.addressOrValue.setValue(value);
            }
        }
    }

    @Override
    public Address getAddressValue() throws ServletParseException {
        if (this.addressOrValue != null) {
            Address address = this.addressOrValue.getAddressValue();
            ((AddressImpl)address).setReadOnly(this._readOnly);
            return address;
        }
        return null;
    }

    @Override
    public void setAddressValue(Address address, boolean first) {
        if (address != null) {
            if (this.addressOrValue == null) {
                this.addressOrValue = new AddressOrValue(address);
            } else {
                this.addressOrValue.setAddressValue(address);
            }
        }
    }

    @Override
    public ListIterator<String> getValues() {
        return new HeaderIterator<Object>((this.addressOrValue != null ? this.addressOrValue.toString() : null));
    }

    @Override
    public ListIterator<Address> getAddressValues() throws ServletParseException {
        Address address = this.getAddressValue();
        ((AddressImpl)address).setReadOnly(this._readOnly);
        return new HeaderIterator<Address>(address);
    }

    @Override
    public void removeValues() {
        this.addressOrValue = null;
    }

    @Override
    public void merge(Header h) {
        throw new UnsupportedOperationException("Header = " + this._name + " old val = " + String.valueOf(this.addressOrValue) + " merge with = " + h.getName() + " : " + h.getValue());
    }

    public String toString() {
        if (this.addressOrValue != null) {
            StringBuilder sb = new StringBuilder(this._name);
            sb.append(": ");
            sb.append(this.addressOrValue.toString());
            sb.append("\r\n");
            return sb.toString();
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HeaderIterator<T>
    implements ListIterator<T> {
        private ListIterator<T> _li;

        public HeaderIterator(T val) {
            ArrayList<T> l = new ArrayList<T>();
            if (val != null) {
                l.add(val);
            }
            this._li = l.listIterator();
        }

        @Override
        public void add(T o) {
            if (SingleLineHeader.this._readOnly) {
                throw new IllegalStateException("You can not modify a system header!");
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this._li.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this._li.hasPrevious();
        }

        @Override
        public T next() {
            return this._li.next();
        }

        @Override
        public int nextIndex() {
            return this._li.nextIndex();
        }

        @Override
        public T previous() {
            return this._li.previous();
        }

        @Override
        public int previousIndex() {
            return this._li.previousIndex();
        }

        @Override
        public void remove() {
            if (SingleLineHeader.this._readOnly) {
                throw new IllegalStateException("You can not modify a system header!");
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T o) {
            if (SingleLineHeader.this._readOnly) {
                throw new IllegalStateException("You can not modify a system header!");
            }
            throw new UnsupportedOperationException();
        }
    }
}

