/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.config.LayerHandler;
import com.ericsson.ssa.container.NetworkManager;
import com.ericsson.ssa.dd.SessionCase;
import com.ericsson.ssa.sip.AddressImpl;
import com.ericsson.ssa.sip.B2buaHelperImpl;
import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.HeaderRequirement;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.PathNode;
import com.ericsson.ssa.sip.ProxyContext;
import com.ericsson.ssa.sip.ProxyImpl;
import com.ericsson.ssa.sip.SessionManager;
import com.ericsson.ssa.sip.SingleLineHeader;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.SipURIImpl;
import com.ericsson.ssa.sip.TelURLImpl;
import com.ericsson.ssa.sip.UA;
import com.ericsson.ssa.sip.URIImpl;
import java.io.BufferedReader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.SipApplicationRoutingDirective;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.URI;
import org.jvnet.glassfish.comms.security.auth.impl.AuthInfoImpl;
import org.jvnet.glassfish.comms.security.auth.impl.ClientDigestCreator;

public class SipServletRequestImpl
extends SipServletMessageImpl
implements SipServletRequest,
Externalizable {
    public static final String CLIENT_CERT = "javax.servlet.request.X509Certificate";
    private static final long serialVersionUID = 3257849874501548343L;
    private static final Set<String> _disallowedRecordRouteURIParams = new HashSet<String>();
    private URI _requestURI;
    private boolean _isInitial = false;
    private ProxyContext _proxyContext = null;
    private boolean m_IsInPath = false;
    private SessionCase m_SessionCase = SessionCase.INTERNAL;
    private SipServletRequestImpl _transactionRequest = null;
    protected boolean _IsRecordRouteIndicated = false;
    private byte[] toBufferContent = null;
    private int toBufferContentOffset = -1;
    private int _sentFinalResponseCode = -1;
    private int _rseq = 0;
    protected List<Dispatcher> _retransmission_applicationStack = null;
    private Address _poppedRoute = null;
    private Object _stateInfo = null;
    private SipServletRequestImpl _linkedRequest = null;
    private B2buaHelper _b2buahelper = null;
    private Logger _logger = Logger.getLogger("SipContainer");
    private boolean _supervised = true;
    private Map<String, String> _recordRouteURIParams = new HashMap<String, String>();

    public SipServletRequestImpl() {
        this._messageType = SipServletMessageImpl.SipMessageType.SipRequest;
    }

    public SipServletRequestImpl(String method, URI requestURI, String protocol) {
        super(method, protocol);
        this._requestURI = requestURI;
        this._messageType = SipServletMessageImpl.SipMessageType.SipRequest;
    }

    public URI getRequestURI() {
        return this._requestURI;
    }

    public boolean isRecordRouteIndicated() {
        return this._IsRecordRouteIndicated;
    }

    public void indicateRecordRoute() {
        this._IsRecordRouteIndicated = true;
    }

    public void setRequestURI(URI requestURI) {
        this._requestURI = requestURI;
    }

    public void writeExternal(ObjectOutput output) throws IOException {
        try {
            output.writeObject(this._requestURI);
            super.writeExternal(output);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readExternal(ObjectInput input) throws IOException {
        try {
            this._requestURI = (URI)input.readObject();
            super.readExternal(input);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PathNode.Type isDirection() {
        if (this.isInitial()) {
            this._Type = PathNode.Type.Caller;
            return this._Type;
        }
        return super.isDirection();
    }

    public void pushRoute(SipURI route) {
        Address routeAddress = this._sf.createAddress((URI)route);
        this.pushRoute(routeAddress);
    }

    public void pushRoute(Address routeAddress) {
        if (!this.isInitial()) {
            throw new IllegalStateException("It's not allowed to call pushRoute for subsequent requests.");
        }
        if (this.headerMap.containsKey("Route")) {
            Header header = (Header)this.headerMap.get("Route");
            header.setAddressValue(routeAddress, true);
        } else {
            Header header = Header.createFormated("Route", this);
            header.setAddressValue(routeAddress, true);
            this.headerMap.put("Route", header);
        }
    }

    public int getMaxForwards() {
        Header header = (Header)this.headerMap.get("Max-Forwards");
        if (header == null) {
            return -1;
        }
        String mf = header.getValue();
        if (mf == null) {
            return -1;
        }
        return Integer.parseInt(mf);
    }

    public void setMaxForwards(int nr) {
        this.setHeader("Max-Forwards", String.valueOf(nr));
    }

    public void setInitial(boolean isInitial) {
        this._isInitial = isInitial;
    }

    public boolean isInitial() {
        return this._isInitial;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public void setInApplicationPath(boolean inPath) {
        this.m_IsInPath = inPath;
    }

    public boolean isInApplicationPath() {
        return this.m_IsInPath;
    }

    public ProxyContext getProxyContext() {
        return this._proxyContext;
    }

    public void setProxyContext(ProxyContext proxyContext) {
        this._proxyContext = proxyContext;
    }

    public Proxy getProxy() throws TooManyHopsException {
        return this.getProxy(true);
    }

    public Proxy getProxy(boolean create) throws TooManyHopsException {
        if (!this.isInitial()) {
            throw new IllegalStateException("Applications should not attempt to explicitly proxy subsequent requests");
        }
        if (this._b2buahelper != null) {
            throw new IllegalStateException("Only allowed to be B2bua");
        }
        if (((Header)this.headerMap.get("Max-Forwards")).getValue().equals("0")) {
            throw new TooManyHopsException();
        }
        Proxy proxy = null;
        if (this.getProxyContext() == null) {
            if (this.isInApplicationPath()) {
                throw new IllegalStateException("Only allowed to be UA");
            }
            if (create) {
                ProxyImpl proxyImpl = new ProxyImpl(this.getApplicationSessionImpl(), this);
                this.setProxyContext(new ProxyContext(proxyImpl, this.getSessionImpl()));
                proxy = proxyImpl.getFacade(this);
            }
        } else {
            proxy = this.getProxyContext().getProxy().getFacade(this);
        }
        return proxy;
    }

    public SipServletResponse createResponse(int code) throws IllegalArgumentException, IllegalStateException {
        this.checkResponseCode(code);
        return this.createResponseImpl(code);
    }

    public SipServletResponseImpl createTerminatingResponse(int code) {
        if (this.getMethod().equals("ACK")) {
            return null;
        }
        SipServletResponseImpl resp = this.createResponseImpl(code);
        if (!resp.hasToTag()) {
            resp.createTag("To");
        }
        resp.setRemote(this.getRemote());
        resp.setRequest(this);
        return resp;
    }

    public SipServletResponseImpl create100TryingResponse() {
        return this.createResponseImpl(100);
    }

    public SipServletResponseImpl createResponseImpl(int code) {
        return this.populateResponse(new SipServletResponseImpl(this, this.getProtocol(), code));
    }

    public SipServletResponse createResponse(int code, String phrase) throws IllegalArgumentException, IllegalStateException {
        this.checkResponseCode(code);
        return this.createResponseImpl(code, phrase);
    }

    public SipServletResponseImpl createTerminatingResponse(int code, String phrase) {
        if (this.getMethod().equals("ACK")) {
            return null;
        }
        SipServletResponseImpl resp = this.createResponseImpl(code, phrase);
        if (!resp.hasToTag()) {
            resp.createTag("To");
        }
        return resp;
    }

    public SipServletResponseImpl createResponseImpl(int code, String phrase) {
        return this.populateResponse(new SipServletResponseImpl(this, this.getProtocol(), code, phrase));
    }

    public SipServletRequest createCancel() throws IllegalStateException {
        return this.createCancelImpl();
    }

    public SipServletRequestImpl createCancelImpl() throws IllegalStateException {
        if (this.isInitial() && this.getMethod().equals("INVITE")) {
            Address fromCopy = (Address)((AddressImpl)this.getFrom()).clone(true, true);
            Address toCopy = (Address)((AddressImpl)this.getTo()).clone(true, true);
            SipServletRequestImpl req = new SipServletRequestImpl("CANCEL", this.getRequestURI(), "SIP/2.0");
            SingleLineHeader toHeader = new SingleLineHeader("To", true);
            ((Header)toHeader).setAddressValue(toCopy, false);
            req.setHeader(toHeader);
            SingleLineHeader fromHeader = new SingleLineHeader("From", true);
            ((Header)fromHeader).setAddressValue(fromCopy, false);
            req.setHeader(fromHeader);
            SingleLineHeader maxForwardsHeader = new SingleLineHeader("Max-Forwards", false);
            ((Header)maxForwardsHeader).setValue("70", false);
            req.setHeader(maxForwardsHeader);
            SingleLineHeader callIDHeader = new SingleLineHeader("Call-Id", true);
            ((Header)callIDHeader).setValue(this.getCallId(), false);
            req.setHeader(callIDHeader);
            SingleLineHeader cSeqHeader = new SingleLineHeader("Cseq", true);
            ((Header)cSeqHeader).setValue(Integer.toString(this.getCSeqNumber()) + " CANCEL", false);
            req.setHeader(cSeqHeader);
            Header route = this.getRawHeader("Route");
            if (route != null) {
                req.setHeader((Header)route.clone());
            }
            req.setSession(this.getSessionImpl());
            req.setDialog(this.getDialog());
            req.setDirection(this.isDirection());
            req.setInitial(false);
            List<Layer> layers = LayerHandler.getInstance().getLayers();
            req._applicationStack.addAll(layers);
            req.setRemote(this.getRemote());
            return req;
        }
        throw new IllegalStateException("Cancel is only allowed for initial INVITE.");
    }

    public String getParameter(String name) {
        return this.getRecordRouteURIParam(name);
    }

    public Enumeration getParameterNames() {
        final Iterator it = this.getRecordRouteURIParamNames();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)it.next();
            }
        };
    }

    public String[] getParameterValues(String name) {
        return new String[]{this.getRecordRouteURIParam(name)};
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this._recordRouteURIParams);
    }

    public String getScheme() {
        return this._requestURI.getScheme();
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public String getRemoteHost() {
        return null;
    }

    public void removeAttribute(String arg0) {
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return null;
    }

    @Deprecated
    public String getRealPath(String arg0) {
        return null;
    }

    public String getLocalName() {
        return null;
    }

    public String toString() {
        Header cl;
        StringBuilder sb = new StringBuilder(this._method);
        sb.append(' ');
        sb.append(this._requestURI);
        sb.append(' ');
        sb.append("SIP/2.0");
        sb.append("\r\n");
        int len = 0;
        byte[] content = null;
        try {
            content = this.getRawContent();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (content != null) {
            len = content.length;
        }
        if ((cl = (Header)this.headerMap.get("Content-Length")) == null) {
            cl = new SingleLineHeader("Content-Length", false);
            cl.setValue("" + len, false);
            this.headerMap.put("Content-Length", cl);
        } else {
            cl.setValue("" + len, false);
        }
        Iterator i = this.headerMap.values().iterator();
        while (i.hasNext()) {
            sb.append(((Header)i.next()).toString());
        }
        sb.append("\r\n");
        if (content != null && content.length > 0) {
            sb.append(new String(content));
        }
        return sb.toString();
    }

    public boolean toBufferHasRemaining() {
        return this.toBufferContentOffset != (this.toBufferContent == null ? 0 : this.toBufferContent.length);
    }

    public void toBufferInit() {
        this.toBufferContent = null;
        this.toBufferContentOffset = -1;
    }

    public ByteBuffer toBuffer(ByteBuffer bb) throws UnsupportedEncodingException {
        if (this.toBufferContentOffset == -1) {
            Header cl;
            this.toBufferContentOffset = 0;
            bb.put(this._method.getBytes());
            bb.put((byte)32);
            bb.put(this._requestURI.toString().getBytes("UTF-8"));
            bb.put((byte)32);
            bb.put("SIP/2.0".getBytes());
            bb.put("\r\n".getBytes());
            int len = 0;
            try {
                this.toBufferContent = this.getRawContent();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.toBufferContent != null) {
                len = this.toBufferContent.length;
            }
            if ((cl = (Header)this.headerMap.get("Content-Length")) == null) {
                cl = new SingleLineHeader("Content-Length", false);
                cl.setValue("" + len, false);
                this.headerMap.put("Content-Length", cl);
            } else {
                cl.setValue("" + len, false);
            }
            Iterator i = this.headerMap.values().iterator();
            while (i.hasNext()) {
                bb.put(((Header)i.next()).toString().getBytes("UTF-8"));
            }
            bb.put("\r\n".getBytes());
        }
        if (this.toBufferContent != null && this.toBufferContent.length > 0) {
            int remainingContent = this.toBufferContent.length - this.toBufferContentOffset;
            int remainingBufferLength = bb.remaining();
            int bytesToCopy = remainingContent < remainingBufferLength ? remainingContent : remainingBufferLength;
            bb.put(this.toBufferContent, this.toBufferContentOffset, bytesToCopy);
            this.toBufferContentOffset += bytesToCopy;
        }
        return bb;
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder(this._method);
        sb.append(" ");
        sb.append(this._requestURI);
        sb.append(" ");
        sb.append(super.toDebugString());
        return sb.toString();
    }

    private SipServletResponseImpl populateResponse(SipServletResponseImpl response) {
        if (this.getMethod().equals("ACK")) {
            throw new IllegalStateException("Not allowed to create response " + response.getStatus() + " for ACK with callId = " + this.getCallId() + ", from = " + this.getFrom() + ", to = " + this.getTo());
        }
        for (Header next : this.headerMap.values()) {
            if (next.equals("Via")) {
                response.headerMap.put("Via", (Header)next.clone());
                continue;
            }
            if (next.equals("From")) {
                response.headerMap.put("From", (Header)next.clone());
                continue;
            }
            if (next.equals("To")) {
                response.headerMap.put("To", (Header)next.clone());
                continue;
            }
            if (next.equals("Cseq")) {
                response.headerMap.put("Cseq", (Header)next.clone());
                continue;
            }
            if (next.equals("Call-Id")) {
                response.headerMap.put("Call-Id", (Header)next.clone());
                continue;
            }
            if (!next.equals("Record-Route")) continue;
            response.headerMap.put("Record-Route", (Header)next.clone());
        }
        response._dialog = this._dialog;
        if (SipFactoryImpl.getContactRequirement(response) != HeaderRequirement.NOT_APPLICAPLE) {
            SessionManager.getInstance().addContact(response);
        }
        response._method = this._method;
        response._transactionStack.addAll(this._transactionStack);
        response._sf = this._sf;
        response._local = this._local;
        response._session = this._session;
        response._isRedirect = this._isRedirect;
        response.setDirection(this.isDirection());
        String version = System.getProperty("sip.module.version");
        if (version != null) {
            response.addHeader("Server", version);
        }
        if (this.isInitial() && this.getProxyContext() != null) {
            this.getProxyContext().getProxy().setVirtualProxyBranchRequest(response);
        }
        return response;
    }

    public void send() throws IOException {
        if (!NetworkManager.getInstance().isRunning()) {
            throw new IllegalStateException("Stack is not yet available for sending requests:");
        }
        DialogFragment p = this.getDialog();
        PathNode uac = null;
        if (this.isInitial()) {
            uac = new UA(this.getApplicationSessionImpl(), true);
            p.addToPath(uac);
            this.pushTransactionDispatcher(uac);
            this.setSent(true);
        } else {
            Iterator<PathNode> iter = null;
            if (this.isDirection() == PathNode.Type.Caller) {
                iter = p.getCallee2CallerPath();
            } else if (this.isDirection() == PathNode.Type.Callee) {
                iter = p.getCaller2CalleePath();
            } else {
                throw new IOException("Don't know the direction of the flow.");
            }
            while (iter.hasNext()) {
                uac = iter.next();
                this.pushApplicationDispatcher(uac);
            }
            this.popDispatcher();
            this.pushTransactionDispatcher(uac);
        }
        uac.send(this);
    }

    public SessionCase getSessionCase() {
        return this.m_SessionCase;
    }

    public void setSessionCase(SessionCase sessionCase) {
        this.m_SessionCase = sessionCase;
    }

    public void removeSystemHeaders() {
        Iterator<String> i = Header.SYSTEM_HEADER_MAP.values().iterator();
        while (i.hasNext()) {
            this.headerMap.remove(i.next());
        }
    }

    public Object clone() {
        SipServletRequestImpl clone = new SipServletRequestImpl(this.getMethod(), this.getRequestURI(), this.getProtocol());
        for (Header next : this.headerMap.values()) {
            clone.headerMap.put(next.getName(), (Header)next.clone());
        }
        if (this.attrib != null) {
            clone.attrib = this.systemAttrib != null ? new HashMap(this.systemAttrib) : new HashMap(this.attrib.size());
            clone.attrib.putAll(this.attrib);
        } else if (this.systemAttrib != null) {
            clone.systemAttrib = new HashMap(this.systemAttrib.size());
            clone.systemAttrib.putAll(this.systemAttrib);
        }
        clone.m_SessionCase = this.m_SessionCase;
        clone._content_enc = this._content_enc;
        clone._content_byte = this._content_byte;
        clone._content_obj = this._content_obj;
        clone._roles = this._roles;
        clone._remote = this._remote;
        clone._local = this._local;
        clone._isInitial = this._isInitial;
        clone._session = this._session;
        clone._dialog = this._dialog;
        clone._isRedirect = this._isRedirect;
        clone._sf = this._sf;
        clone._IsContactIndicated = this._IsContactIndicated;
        clone._IsRecordRouteIndicated = this._IsRecordRouteIndicated;
        clone._headersComplete = this._headersComplete;
        clone._messageComplete = this._messageComplete;
        clone.m_IsInPath = this.m_IsInPath;
        clone._rseq = this._rseq;
        clone._fragmentId = this._fragmentId;
        clone._supervised = this._supervised;
        clone._recordRouteURIParams = this._recordRouteURIParams;
        clone._poppedRoute = this._poppedRoute;
        clone._stateInfo = this._stateInfo;
        clone.setDirection(this.isDirection());
        if (this._transactionStack != null) {
            clone._transactionStack.addAll(this._transactionStack);
        }
        if (this._applicationStack != null) {
            clone._applicationStack.addAll(this._applicationStack);
        }
        return clone;
    }

    public void saveRetransmissionApplicationStack() {
        this._retransmission_applicationStack = new ArrayList<Dispatcher>(this._applicationStack);
    }

    public void restoreRetransmissionApplicationStack() {
        if (this._applicationStack == null || this._applicationStack != null && this._applicationStack.isEmpty()) {
            this._applicationStack = new ArrayList<Dispatcher>(this._retransmission_applicationStack);
        }
    }

    public Dispatcher popDispatcher() {
        int size = this._applicationStack.size();
        if (size > 0) {
            return (Dispatcher)this._applicationStack.remove(size - 1);
        }
        return null;
    }

    public Dispatcher peekDispatcher() {
        int size = this._applicationStack.size();
        if (size > 0) {
            return (Dispatcher)this._applicationStack.get(size - 1);
        }
        return null;
    }

    public SipServletRequestImpl getTransactionRequest() {
        return this._transactionRequest;
    }

    public void setTransactionRequest(SipServletRequestImpl request) {
        this._transactionRequest = request;
    }

    public void setFragmentId(int id) {
        this._fragmentId = id;
    }

    public void setSentFinalResponse(int statusCode) {
        this._sentFinalResponseCode = statusCode;
    }

    public boolean isSentFinalResponse2xx() {
        return this._sentFinalResponseCode != -1 ? this._sentFinalResponseCode / 100 == 2 : false;
    }

    private boolean isValidStatusCode(int statusCode) {
        if (this._sentFinalResponseCode != -1) {
            if (this._sentFinalResponseCode / 100 == 2) {
                if (statusCode / 100 != 2) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private void checkResponseCode(int statusCode) throws IllegalArgumentException, IllegalStateException {
        if (!this.isValidStatusCode(statusCode)) {
            throw new IllegalStateException("The request has already responded with a final response.");
        }
        if (statusCode < 100 || statusCode > 699) {
            throw new IllegalArgumentException("Invalid SIP status code.");
        }
    }

    public boolean is100RelSupportedOrRequire() {
        if (this.getMethod().equals("INVITE")) {
            ListIterator<String> supportedList = this.getHeaders("Supported");
            String supported = null;
            while (supportedList.hasNext()) {
                supported = supportedList.next();
                if (!supported.equals("100rel")) continue;
                return true;
            }
            ListIterator<String> requireList = this.getHeaders("Require");
            String require = null;
            while (requireList.hasNext()) {
                require = requireList.next();
                if (!require.equals("100rel")) continue;
                return true;
            }
        }
        return false;
    }

    public int getAndIncrementRSeq() {
        return ++this._rseq;
    }

    public void setPoppedRoute(Address route) {
        this._poppedRoute = route;
    }

    public Address getPoppedRoute() {
        if (this._poppedRoute == null) {
            return null;
        }
        return (Address)this._poppedRoute.clone();
    }

    public void setStateInfo(Object stateInfo) {
        this._stateInfo = stateInfo;
    }

    public Object getStateInfo() {
        return this._stateInfo;
    }

    public void setRoutingDirective(SipApplicationRoutingDirective directive, SipServletRequest origRequest) {
    }

    public SipServletRequestImpl getLinkedRequest() {
        return this._linkedRequest;
    }

    public void setLinkedRequest(SipServletRequestImpl linkedRequest) {
        this._linkedRequest = linkedRequest;
    }

    public B2buaHelper getB2buaHelper() {
        if (this._proxyContext != null) {
            throw new IllegalStateException("Only allowed to be proxy");
        }
        if (this._b2buahelper == null) {
            this._b2buahelper = new B2buaHelperImpl(this);
        }
        return this._b2buahelper;
    }

    public void setB2buaHelper(B2buaHelper bua) {
        this._b2buahelper = bua;
    }

    public boolean getSupervised() {
        return this._supervised;
    }

    public void setSupervised(boolean supervised) {
        this._supervised = supervised;
    }

    public String getRecordRouteURIParam(String name) {
        return this._recordRouteURIParams.get(name);
    }

    public Iterator getRecordRouteURIParamNames() {
        return this._recordRouteURIParams.keySet().iterator();
    }

    public void removeRecordRouteURIParam(String name) {
        this._recordRouteURIParams.remove(name);
    }

    public void setRecordRouteURIParam(String name, String value) {
        if (_disallowedRecordRouteURIParams.contains(value)) {
            throw new IllegalArgumentException("Not allowed to set parameter '" + name + "' on Record-Route URI.");
        }
        this._recordRouteURIParams.put(name, value);
    }

    public void setRecordRouteURI(URIImpl uri) {
        Iterator<String> iter;
        if (uri instanceof SipURIImpl) {
            iter = ((SipURIImpl)uri).getParameterNames();
        } else if (uri instanceof TelURLImpl) {
            iter = ((TelURLImpl)uri).getParameterNames();
        } else {
            return;
        }
        while (iter.hasNext()) {
            String name = iter.next();
            String value = uri.getParameter(name);
            if (_disallowedRecordRouteURIParams.contains(value)) continue;
            this._recordRouteURIParams.put(name, value);
        }
    }

    public void setCertificate(X509Certificate[] cert) {
        super.setCertificate(cert);
        if (this.systemAttrib == null) {
            this.systemAttrib = new HashMap();
        }
        this.systemAttrib.put(CLIENT_CERT, cert);
    }

    public void addAuthHeader(SipServletResponse response, AuthInfo info) {
        if (response != null) {
            ClientDigestCreator cdc = new ClientDigestCreator();
            cdc.createDigest(info, (SipServletRequest)this, response);
        }
    }

    public void addAuthHeader(SipServletResponse response, String username, String password) {
        AuthInfoImpl ai = new AuthInfoImpl();
        this.addAuthHeader(response, (AuthInfo)ai);
    }

    static {
        _disallowedRecordRouteURIParams.add("transport");
        _disallowedRecordRouteURIParams.add("lr");
        _disallowedRecordRouteURIParams.add("ttl");
        _disallowedRecordRouteURIParams.add("user");
        _disallowedRecordRouteURIParams.add("method");
        _disallowedRecordRouteURIParams.add("maddr");
    }
}

