/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.config.LayerHandler;
import com.ericsson.ssa.config.lease.Lease;
import com.ericsson.ssa.config.lease.LeaseExpiredException;
import com.ericsson.ssa.container.SipBindingResolver;
import com.ericsson.ssa.container.sim.ServletDispatcher;
import com.ericsson.ssa.dd.SipApplicationListeners;
import com.ericsson.ssa.sip.AddressImpl;
import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.DialogSet;
import com.ericsson.ssa.sip.EnumerationConverter;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.PathNode;
import com.ericsson.ssa.sip.SessionManager;
import com.ericsson.ssa.sip.SingleLineHeader;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.SipSessionBase;
import com.ericsson.ssa.sip.SipSessionManager;
import com.ericsson.ssa.sip.SipSessionManagerBase;
import com.ericsson.ssa.sip.dns.TargetTuple;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionEvent;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.catalina.session.SessionLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipSessionDialogImpl
implements SipSessionBase,
Externalizable {
    private static final long serialVersionUID = 3762535598732096310L;
    public static final String SIP_SESSIONID_DELIMITER = "##";
    private static final Logger m_Log = Logger.getLogger("SipContainer");
    private SipApplicationSessionImpl m_SipApplicationSession = null;
    private SipSessionManager m_SipSessionManager = null;
    private ConcurrentHashMap<String, Object> m_SessionAttributeMap = null;
    private String m_Handler = null;
    private DialogFragment m_Dialog = null;
    private PathNode.Type m_Type = null;
    private String m_Id;
    private ArrayList<SipSessionListener> m_sessionListeners = null;
    private boolean m_IsValid = true;
    private Address m_To;
    private long m_CreationDate = new Date().getTime();
    private long m_LastAccessedDate;
    private DialogSet m_DialogSet;
    private boolean m_IsDerived = false;
    private AtomicInteger m_CSeq = null;
    private URI m_RemoteTarget = null;
    private boolean m_1xxReliableOngoing = false;
    private boolean m_1xxReliableSDP = false;
    private boolean m_UpdateOngoing = false;
    protected AtomicLong version = new AtomicLong(-1L);
    private String _routingRegion = null;
    private URI _subscriberURI = null;
    private String m_linkedSipSessionId = null;
    private boolean m_SwapLocalRemote = false;
    private Config _config = ConfigFactory.getConfig();
    private SessionLock m_SessionLock = new SessionLock();

    public SipSessionDialogImpl(SipSessionManagerBase manager, DialogSet set, Address to, SipApplicationSessionImpl appSession, String handler, PathNode.Type type) {
        this.m_SipSessionManager = manager;
        this.m_DialogSet = set;
        this.m_To = (Address)((AddressImpl)to).clone(false, false);
        ((AddressImpl)this.m_To).setReadOnly(true);
        this.m_SipApplicationSession = appSession;
        this.m_Handler = handler;
        this.m_Type = type;
        if (this.m_Type.equals((Object)PathNode.Type.Caller) || this.m_Type.equals((Object)PathNode.Type.Callee)) {
            this.m_CSeq = new AtomicInteger(1);
        }
        this.m_Id = this.createID().toString();
        this.m_SipApplicationSession.addSession(this);
        SipApplicationListeners sipapplisteners = this.m_SipApplicationSession.getSipApplicationListeners();
        if (sipapplisteners != null) {
            this.m_sessionListeners = sipapplisteners.getSipSessionListeners();
        }
        this.m_SessionAttributeMap = new ConcurrentHashMap();
        this.notifySessionCreated();
    }

    public SipSessionDialogImpl() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_SipSessionManager.getContext().getName());
        out.writeObject(this.m_SipApplicationSession.getId());
        out.writeObject(this.version);
        out.writeObject(this.m_SessionAttributeMap);
        out.writeUTF(this.m_Handler);
        out.writeObject(this.m_Dialog);
        out.writeObject((Object)this.m_Type);
        out.writeUTF(this.m_Id);
        out.writeBoolean(this.m_IsValid);
        out.writeObject(this.m_To);
        out.writeLong(this.m_CreationDate);
        out.writeLong(this.m_LastAccessedDate);
        out.writeObject(this.m_DialogSet);
        out.writeBoolean(this.m_IsDerived);
        out.writeBoolean(this.m_SwapLocalRemote);
        if (this.m_CSeq != null) {
            out.writeInt(this.m_CSeq.get());
        } else {
            out.writeInt(1);
        }
        out.writeObject(this._subscriberURI);
        out.writeUTF(this._routingRegion);
        out.writeObject(this.m_SessionLock);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String contextName = (String)in.readObject();
        this.m_SipSessionManager = SipSessionManagerBase.get(contextName);
        String sasId = (String)in.readObject();
        this.m_SipApplicationSession = this.m_SipSessionManager.findApplicationSession(sasId);
        if (this.m_SipApplicationSession != null) {
            this.m_SipApplicationSession.addSession(this);
        }
        this.version = (AtomicLong)in.readObject();
        this.m_SessionAttributeMap = (ConcurrentHashMap)in.readObject();
        this.m_Handler = in.readUTF();
        this.m_Dialog = (DialogFragment)in.readObject();
        this.m_Type = (PathNode.Type)((Object)in.readObject());
        this.m_Id = in.readUTF();
        SipApplicationListeners sipapplisteners = this.m_SipApplicationSession.getSipApplicationListeners();
        if (sipapplisteners != null) {
            this.m_sessionListeners = sipapplisteners.getSipSessionListeners();
        }
        this.m_IsValid = in.readBoolean();
        this.m_To = (Address)in.readObject();
        this.m_CreationDate = in.readLong();
        this.m_LastAccessedDate = in.readLong();
        this.m_DialogSet = (DialogSet)in.readObject();
        this.m_IsDerived = in.readBoolean();
        this.m_SwapLocalRemote = in.readBoolean();
        if (this.m_Type.equals((Object)PathNode.Type.Caller) || this.m_Type.equals((Object)PathNode.Type.Callee)) {
            this.m_CSeq = new AtomicInteger(in.readInt());
        }
        this._subscriberURI = (URI)in.readObject();
        this._routingRegion = in.readUTF();
        this.m_SessionLock = (SessionLock)in.readObject();
    }

    @Override
    public boolean isDerived() {
        return this.m_IsDerived;
    }

    @Override
    public boolean isValid() {
        return this.m_IsValid;
    }

    private StringBuilder createID() {
        StringBuilder id = new StringBuilder(UUID.randomUUID().toString());
        id.append(SIP_SESSIONID_DELIMITER);
        if (Boolean.getBoolean("sip.module.use_new_config")) {
            try {
                Lease<TargetTuple[]> lease = SipBindingResolver.instance().lease("PUBLIC_BINDING_CTX");
                System.out.println("SipSessionDialogImpl: \n" + lease.getResource()[0]);
                id.append(lease.getResource()[0].getIP());
            }
            catch (LeaseExpiredException e) {
                e.printStackTrace();
            }
        } else {
            id.append(this._config.get("SIP_PUBLIC_HOST"));
        }
        return id;
    }

    private void notifySessionCreated() {
        if (this.m_sessionListeners == null) {
            return;
        }
        for (SipSessionListener listener : this.m_sessionListeners) {
            listener.sessionCreated(new SipSessionEvent((SipSession)this));
        }
    }

    private void notifySessionDestroyed() {
        if (this.m_sessionListeners == null) {
            return;
        }
        for (SipSessionListener listener : this.m_sessionListeners) {
            listener.sessionDestroyed(new SipSessionEvent((SipSession)this));
        }
    }

    public long getCreationTime() {
        return this.m_CreationDate;
    }

    public String getId() {
        return this.m_Id;
    }

    public long getLastAccessedTime() {
        return -1L;
    }

    public void invalidate() {
        this.invalidate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(boolean hasTimedOut) {
        if (this.isValid()) {
            SipSessionDialogImpl sipSessionDialogImpl = this;
            synchronized (sipSessionDialogImpl) {
                if (this.isValid()) {
                    this.m_IsValid = false;
                    if (this.m_Dialog != null) {
                        this.m_Dialog.invalidate(hasTimedOut);
                        this.m_Dialog = null;
                    } else if (this.m_DialogSet != null) {
                        this.m_DialogSet.removeEarlyDialog();
                    }
                    if (!this.m_SipApplicationSession.isValid()) {
                        this.m_SipApplicationSession = null;
                    }
                } else {
                    throw new IllegalStateException("The session is not valid.");
                }
                this.m_SipSessionManager.removeSession(this);
                this.notifySessionDestroyed();
            }
        } else {
            throw new IllegalStateException("The session is not valid.");
        }
    }

    public SipApplicationSession getApplicationSession() {
        return this.m_SipApplicationSession;
    }

    @Override
    public SipApplicationSessionImpl getApplicationSessionImpl() {
        return this.m_SipApplicationSession;
    }

    public String getCallId() {
        return this.m_DialogSet.getCallId();
    }

    public Address getLocalParty() {
        return this.m_SwapLocalRemote ? this.getTo() : this.m_DialogSet.getFrom();
    }

    public Address getRemoteParty() {
        return this.m_SwapLocalRemote ? this.m_DialogSet.getFrom() : this.getTo();
    }

    private Address getLocalSide() {
        Address add = null;
        if (this.m_Type.equals((Object)PathNode.Type.Caller)) {
            add = this.m_DialogSet.getFrom();
        } else if (this.m_Type.equals((Object)PathNode.Type.Callee)) {
            add = this.getTo();
        } else if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, "Unable to decide if its caller or callee. Session id = " + this.getId());
        }
        return add;
    }

    private Address getOtherside() {
        Address add = null;
        if (this.m_Type.equals((Object)PathNode.Type.Caller)) {
            add = this.getTo();
        } else if (this.m_Type.equals((Object)PathNode.Type.Callee)) {
            add = this.m_DialogSet.getFrom();
        } else if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, "Unable to decide if its caller or callee. Session id = " + this.getId());
        }
        return add;
    }

    public SipServletRequest createRequest(String method) {
        if (this.m_Dialog != null && this.getFromTag() != null && this.getToTag() != null && this.m_CSeq != null) {
            Address from = (Address)((AddressImpl)this.getLocalSide()).clone(true, true);
            Address to = (Address)((AddressImpl)this.getOtherside()).clone(true, true);
            if (from == null || to == null) {
                throw new IllegalStateException();
            }
            SipServletRequestImpl req = new SipServletRequestImpl(method, this.getRemoteTarget(), "SIP/2.0");
            req.setDirection(this.m_Type);
            SingleLineHeader toHeader = new SingleLineHeader("To", true);
            ((Header)toHeader).setAddressValue(to, false);
            req.setHeader(toHeader);
            SingleLineHeader fromHeader = new SingleLineHeader("From", true);
            ((Header)fromHeader).setAddressValue(from, false);
            req.setHeader(fromHeader);
            SingleLineHeader maxForwardsHeader = new SingleLineHeader("Max-Forwards", false);
            ((Header)maxForwardsHeader).setValue("70", false);
            req.setHeader(maxForwardsHeader);
            SingleLineHeader callIDHeader = new SingleLineHeader("Call-Id", true);
            ((Header)callIDHeader).setValue(this.getCallId(), false);
            req.setHeader(callIDHeader);
            SingleLineHeader cSeqHeader = new SingleLineHeader("Cseq", true);
            ((Header)cSeqHeader).setValue(Integer.toString(this.m_CSeq.incrementAndGet()) + " " + req.getMethod(), false);
            req.setHeader(cSeqHeader);
            req.setSession(this);
            req.setDialog(this.m_Dialog);
            req.setInitial(false);
            List<Layer> layers = LayerHandler.getInstance().getLayers();
            req._applicationStack.addAll(layers);
            req.setRole(this.m_SipApplicationSession.getName());
            if (SipFactoryImpl.isDialogCreational(req.getMethod()) || "UPDATE".equals(req.getMethod())) {
                SessionManager.getInstance().addContact(req);
            }
            return req;
        }
        throw new IllegalStateException("Not allowed to create a request.");
    }

    public void setHandler(String name) throws ServletException {
        ServletDispatcher servletDispatcher = this.m_SipApplicationSession.getServletDispatcher();
        if (servletDispatcher != null) {
            if (name == null || !servletDispatcher.findServlet(name)) {
                throw new ServletException("Could not found the servlet to set it as a handler.");
            }
        } else if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, "Unexpected: Called setHandler, but the servlet dispatcher is null.");
        }
        this.m_Handler = name;
    }

    @Override
    public String getHandler() {
        return this.m_Handler;
    }

    public Object getAttribute(String name) {
        if (name.equals("com.ericsson.ssa.RemoteTarget")) {
            return this.getRemoteTarget();
        }
        if (!this.isValid()) {
            throw new IllegalStateException("The session is not valid.");
        }
        return this.m_SessionAttributeMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getAttributeNames() {
        if (!this.isValid()) {
            throw new IllegalStateException("The session is not valid.");
        }
        ConcurrentHashMap<String, Object> concurrentHashMap = this.m_SessionAttributeMap;
        synchronized (concurrentHashMap) {
            Collection c = this.m_SessionAttributeMap.keySet();
            if (c == null) {
                c = new ArrayList(1);
            }
            c.add("com.ericsson.ssa.RemoteTarget");
            return new EnumerationConverter<String>(c);
        }
    }

    public void setAttribute(String name, Object attribute) {
        if (name.equals("com.ericsson.ssa.RemoteTarget")) {
            throw new IllegalStateException("reserved key.");
        }
        if (!this.isValid()) {
            throw new IllegalStateException("The session is not valid.");
        }
        this.m_SessionAttributeMap.put(name, attribute);
    }

    public void removeAttribute(String name) {
        if (!this.isValid()) {
            throw new IllegalStateException("The session is not valid.");
        }
        this.m_SessionAttributeMap.remove(name);
    }

    @Override
    public URI getRemoteTarget() {
        return this.m_RemoteTarget;
    }

    @Override
    public void setRemoteTarget(URI contact) {
        this.m_RemoteTarget = contact;
    }

    @Override
    public String getToTag() {
        return this.getTo().getParameter("tag");
    }

    @Override
    public boolean hasNoToTag() {
        return this.m_Dialog == null;
    }

    @Override
    public String getFromTag() {
        return this.m_DialogSet.getFromTag();
    }

    @Override
    public synchronized void setType(PathNode.Type type) {
        this.m_Type = type;
        if (this.m_CSeq == null && (this.m_Type.equals((Object)PathNode.Type.Caller) || this.m_Type.equals((Object)PathNode.Type.Callee))) {
            this.m_CSeq = new AtomicInteger(1);
        }
    }

    @Override
    public Address getTo() {
        return this.m_To;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SipSessionDialogImpl getOriginalOrDerivedSession(DialogFragment d, String toTag) {
        if (d.getToTag() != null && toTag != null && toTag.equals(d.getToTag())) {
            SipSessionDialogImpl s = null;
            if (this.m_Dialog == null) {
                SipSessionDialogImpl sipSessionDialogImpl = this;
                synchronized (sipSessionDialogImpl) {
                    if (this.m_Dialog == null) {
                        s = this;
                        this.m_Dialog = d;
                        this.m_Dialog.registerSession(s);
                        AddressImpl toAddress = (AddressImpl)this.getTo();
                        toAddress.setReadOnly(false);
                        toAddress.setParameter("tag", toTag);
                        toAddress.setReadOnly(true);
                    } else {
                        s = this.m_SipSessionManager.createSipSession(this.m_DialogSet, this.getTo(), this.getApplicationSessionImpl(), this.getHandler(), this.m_Type);
                        s.m_IsDerived = true;
                        s.m_Dialog = d;
                        s.m_Dialog.registerSession(s);
                        AddressImpl toAddress = (AddressImpl)s.getTo();
                        toAddress.setReadOnly(false);
                        toAddress.setParameter("tag", toTag);
                        toAddress.setReadOnly(true);
                    }
                }
            } else {
                s = this.m_SipSessionManager.createSipSession(this.m_DialogSet, this.getTo(), this.getApplicationSessionImpl(), this.getHandler(), this.m_Type);
                s.m_IsDerived = true;
                s.m_Dialog = d;
                s.m_Dialog.registerSession(s);
                AddressImpl toAddress = (AddressImpl)s.getTo();
                toAddress.setReadOnly(false);
                toAddress.setParameter("tag", toTag);
                toAddress.setReadOnly(true);
            }
            return s;
        }
        throw new IllegalStateException("DialogFragment must have same to-tag as message.");
    }

    @Override
    public SipSessionBase getOriginalOrDerivedSessionAndRegisterDialog(SipServletRequestImpl req, DialogFragment d) {
        String toTag = req.getFrom().getParameter("tag");
        return this.getOriginalOrDerivedSessionAndRegisterDialog(req, d, toTag);
    }

    @Override
    public SipSessionBase getOriginalOrDerivedSessionAndRegisterDialog(SipServletResponseImpl resp, DialogFragment d) {
        String toTag = resp.getTo().getParameter("tag");
        return this.getOriginalOrDerivedSessionAndRegisterDialog(resp, d, toTag);
    }

    private SipSessionBase getOriginalOrDerivedSessionAndRegisterDialog(SipServletMessageImpl m, DialogFragment d, String toTag) {
        if (toTag != null) {
            SipSessionBase s = null;
            boolean isDialogCreational = SipFactoryImpl.isDialogCreational(m.getMethod());
            boolean success = d.tryToSetToTagAndRegisterDialog(toTag, isDialogCreational);
            if (success) {
                s = this.getOriginalOrDerivedSession(d, toTag);
            } else {
                DialogFragment searchedDialog = this.m_DialogSet.searchForDialog(toTag, m.getFragmentId());
                if (searchedDialog != null) {
                    m.setDialog(searchedDialog);
                    s = this.getOriginalOrDerivedSession(searchedDialog, toTag);
                } else {
                    DialogFragment clone = (DialogFragment)d.clone();
                    s = this.getOriginalOrDerivedSessionAndRegisterDialog(m, clone, toTag);
                }
            }
            return s;
        }
        throw new IllegalStateException("DialogFragment must have same to-tag as message.");
    }

    public void swapLocalRemote() {
        this.m_SwapLocalRemote = true;
    }

    @Override
    public boolean setUpdateOngoing() {
        if (this.m_UpdateOngoing) {
            return false;
        }
        this.m_UpdateOngoing = true;
        return true;
    }

    @Override
    public void resetUpdateOngoing() {
        this.m_UpdateOngoing = false;
    }

    @Override
    public boolean is1xxReliableOngoing() {
        return this.m_1xxReliableOngoing;
    }

    @Override
    public synchronized boolean set1xxReliableOngoing(boolean sdp) {
        if (this.m_1xxReliableOngoing) {
            return false;
        }
        this.m_1xxReliableSDP = sdp;
        this.m_1xxReliableOngoing = true;
        return true;
    }

    @Override
    public boolean is1xxReliableSDP() {
        return this.m_1xxReliableSDP;
    }

    @Override
    public void reset1xxReliable() {
        this.m_1xxReliableOngoing = false;
        this.m_1xxReliableSDP = false;
    }

    @Override
    public void setRegion(String region) {
        this._routingRegion = region;
    }

    public String getRegion() {
        return this._routingRegion;
    }

    @Override
    public void setSubscriberURI(URI subscriberURI) {
        this._subscriberURI = subscriberURI;
    }

    public URI getSubscriberURI() throws IllegalStateException {
        return this._subscriberURI;
    }

    @Override
    public String getLinkedSipSessionId() {
        return this.m_linkedSipSessionId;
    }

    @Override
    public void setLinkedSipSessionId(String id) {
        this.m_linkedSipSessionId = id;
    }

    @Override
    public int getFragmentId() {
        return this.m_Dialog != null ? this.m_Dialog.getFragmentId() : -1;
    }

    public SipSession.State getState() {
        throw new RuntimeException(" Not yet implemented ");
    }

    public boolean isOngoingTransaction() {
        throw new RuntimeException(" Not yet implemented ");
    }

    public void setOutboundInterface(SipURI uri) {
        throw new RuntimeException(" Not yet implemented ");
    }

    public SipSessionManager getSipSessionManager() {
        return this.m_SipSessionManager;
    }

    public String getCurrentOwnerInstanceName() {
        return this.m_SipSessionManager.getInstanceName();
    }

    protected boolean getSessionLockForForeground() {
        boolean result = false;
        long pollTime = 200L;
        int tryNumber = 0;
        int numTries = 7;
        boolean keepTrying = true;
        boolean lockResult = false;
        while (keepTrying) {
            lockResult = this.lockForeground();
            if (lockResult) {
                keepTrying = false;
                result = true;
                break;
            }
            if (++tryNumber < numTries - 1) {
                pollTime *= 2L;
                continue;
            }
            this.unlockBackground();
        }
        return result;
    }

    public synchronized boolean isForegroundLocked() {
        return this.m_SessionLock.isForegroundLocked();
    }

    public synchronized boolean lockBackground() {
        return this.m_SessionLock.lockBackground();
    }

    public synchronized boolean lockForeground() {
        return this.m_SessionLock.lockForeground();
    }

    public synchronized void unlockForegroundCompletely() {
        this.m_SessionLock.unlockForegroundCompletely();
    }

    public synchronized void unlockForeground() {
        this.m_SessionLock.unlockForeground();
    }

    public synchronized void unlockBackground() {
        this.m_SessionLock.unlockBackground();
    }

    public SessionLock getSessionLock() {
        return this.m_SessionLock;
    }

    @Override
    public boolean isReplicable() {
        return this.m_SipApplicationSession.isReplicable();
    }

    public void incrementVersion() {
        this.version.incrementAndGet();
    }
}

