/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import java.io.UnsupportedEncodingException;

public class SipURIDecoder {
    protected String m_encoding = "UTF-8";

    public String decode(String s) throws UnsupportedEncodingException {
        if (s == null) {
            return null;
        }
        boolean needToChange = false;
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        while (i < numChars) {
            char c = s.charAt(i);
            if (c == '%') {
                try {
                    if (bytes == null) {
                        bytes = new byte[(numChars - i) / 3];
                    }
                    int pos = 0;
                    while (i + 2 < numChars && c == '%') {
                        bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                        if ((i += 3) >= numChars) continue;
                        c = s.charAt(i);
                    }
                    if (i < numChars && c == '%') {
                        throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                    }
                    String string = new String(bytes, 0, pos, this.m_encoding);
                    sb.append(string);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                }
                needToChange = true;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    public String decode(String s, String encoding) throws UnsupportedEncodingException {
        if (encoding.length() == 0) {
            throw new UnsupportedEncodingException("URLDecoder: empty string enc parameter");
        }
        this.m_encoding = encoding;
        return this.decode(s);
    }
}

