/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.ProxyBranchImpl;
import com.ericsson.ssa.sip.ProxyImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.sip.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TargetSet {
    private static final Logger _log = Logger.getLogger("SipContainer");
    private static final List<TargetSet> EMPTY_TARGET_SET = new ArrayList<TargetSet>(0);
    protected int _proxyTimeout = 0;
    private final ProxyImpl _proxy;
    private TargetSet _parent = null;

    protected TargetSet(ProxyImpl p) {
        this._proxy = p;
    }

    protected List<TargetSet> getTargetSets() {
        return EMPTY_TARGET_SET;
    }

    protected void setParent(TargetSet t) {
        this._parent = t;
    }

    public TargetSet getParent() {
        return this._parent;
    }

    public ProxyBranchImpl findBranch(URI uri) {
        ProxyBranchImpl branch = null;
        for (TargetSet t : this.getTargetSets()) {
            branch = t.findBranch(uri);
            if (branch == null) continue;
            return branch;
        }
        return null;
    }

    public void addTopLevelBranch(List<ProxyBranchImpl> branches) {
        for (TargetSet t : this.getTargetSets()) {
            t.addTopLevelBranch(branches);
        }
    }

    public SipServletResponseImpl findBestResponse() {
        if (!this.isStarted()) {
            return null;
        }
        boolean isRunning = false;
        SipServletResponseImpl bestResponse = null;
        SipServletResponseImpl currentResp = null;
        int currentStatus = -1;
        int bestStatus = 700;
        for (TargetSet t : this.getTargetSets()) {
            currentResp = t.findBestResponse();
            if (currentResp == null) {
                isRunning = true;
                continue;
            }
            if (currentResp.isAlreadyRedirected()) continue;
            currentStatus = currentResp.getStatus();
            if (currentStatus / 100 == 2) {
                return currentResp;
            }
            if (currentStatus / 100 == 6) {
                bestStatus = currentStatus;
                bestResponse = currentResp;
                continue;
            }
            if (bestStatus / 100 == 6 || bestStatus <= currentResp.getStatus()) continue;
            bestStatus = currentResp.getStatus();
            bestResponse = currentResp;
        }
        if (isRunning) {
            return null;
        }
        return bestResponse;
    }

    public abstract void proxyTo() throws IllegalStateException;

    public abstract void cancel() throws IllegalStateException;

    public void add(TargetSet t) throws IllegalStateException {
        throw new IllegalStateException("Not allowed to add targets in this target set");
    }

    public boolean hasNext() {
        return false;
    }

    public void next() {
    }

    public ProxyImpl getProxyImpl() {
        return this._proxy;
    }

    public abstract boolean getParallel();

    public abstract boolean isStarted();

    public abstract boolean getRecurse();

    public void setProxyTimeout(int t) {
        this._proxyTimeout = t;
    }

    public int getProxyTimeout() {
        return this._proxyTimeout;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getProxyImpl().toString());
        sb.append(" isParallel: ");
        sb.append(this.getParallel());
        sb.append(" isRecurse: ");
        sb.append(this.getRecurse());
        return sb.toString();
    }
}

