/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.ParameterByteMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class URIImpl
implements URI {
    public static final String LOOSE_ROUTE_PARAM = "lr";
    public static final String FRAGID_PARAM = "fid";
    private static final Logger _logger = Logger.getLogger("SipContainer");
    protected ParameterByteMap _parameters = null;

    public String getParameter(String param) {
        if (this._parameters == null) {
            return null;
        }
        return this._parameters.get(param);
    }

    public boolean getLrParam() {
        String v = this.getParameter(LOOSE_ROUTE_PARAM);
        return v != null && (v.equals("") || v.equals("on"));
    }

    public String getScheme() {
        throw new RuntimeException("Should be implemented by subclasses");
    }

    public void setParameter(String name, String value) {
        if (this._parameters == null) {
            this._parameters = new ParameterByteMap(';');
        }
        this._parameters.put(name, value);
    }

    public void removeParameter(String name) {
        if (this._parameters != null) {
            this._parameters.remove(name);
        }
    }

    public Iterator<String> getParameterNames() {
        if (this._parameters == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this._parameters.getKeys();
    }

    public boolean isSipURI() {
        return true;
    }

    public Object clone() {
        throw new RuntimeException("Should be implemented by subclasses");
    }

    public int getFragmentId() {
        String id = this.getParameter(FRAGID_PARAM);
        if (id == null) {
            return 1;
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException nfx) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "parsing of fragment-id failed, substituting 666");
            }
            return 666;
        }
    }
}

