/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.BasicMandatoryHeaderValidator;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.ViaImpl;

public class ViaHeaderValidator
extends BasicMandatoryHeaderValidator {
    public ViaHeaderValidator() {
        super("Via");
    }

    public boolean validate(SipServletMessageImpl message) {
        Header header = message.getRawHeader("Via");
        if (header == null || header.getValue() == null || header.getValue().length() == 0) {
            return false;
        }
        String headerValue = header.getValue();
        String[] viaParts = headerValue.split(",");
        if (viaParts.length < 1) {
            return false;
        }
        for (String part : viaParts) {
            if (this.validatePart(message.getMethod(), part)) continue;
            return false;
        }
        return true;
    }

    private boolean validatePart(String method, String part) {
        try {
            ViaImpl impl = new ViaImpl(part);
            return this.validateTransport(impl.getTransport()) && this.validateHost(impl.getHost()) && this.validateBranchParameter(method, impl.getParameter("branch"));
        }
        catch (StringIndexOutOfBoundsException e) {
            return false;
        }
    }

    private boolean validateTransport(String transport) {
        return this.isToken(transport);
    }

    private boolean validateHost(String host) {
        return host != null;
    }

    private boolean validateBranchParameter(String method, String branch) {
        return branch != null && (branch.startsWith("z9hG4bK") || method.equals("ACK"));
    }
}

