/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

public class ViaImpl {
    public static final String PARAM_MADDR = "maddr";
    public static final String PARAM_BRANCH = "branch";
    public static final String PARAM_TTL = "ttl";
    public static final String PARAM_RECEIVED = "received";
    public static final String PARAM_RPORT = "rport";
    private String _transport = null;
    private String _host = null;
    private String _protocol = null;
    private int _port = 5060;
    private Map<String, String> _parameters = new HashMap<String, String>();

    public ViaImpl(String protocol, String transport, String host, int port) {
        this._protocol = protocol;
        this._transport = transport;
        this._host = host;
        this._port = port;
    }

    public ViaImpl(String protocol, String transport, String host) {
        this(protocol, transport, host, -1);
    }

    public ViaImpl(String header) {
        int offset;
        byte[] via = header.getBytes();
        int slashCnt = 0;
        int colonIndex = -1;
        boolean inIPv6Addr = false;
        for (offset = 0; slashCnt < 2 && offset < via.length; ++offset) {
            if (via[offset] != 47) continue;
            ++slashCnt;
        }
        try {
            int semiIndex;
            this._transport = new String(via, offset, 3, "UTF-8");
            boolean foundSemi = false;
            for (semiIndex = offset += 4; semiIndex < via.length; ++semiIndex) {
                if (via[semiIndex] == 59) {
                    foundSemi = true;
                    break;
                }
                if (!inIPv6Addr && via[semiIndex] == 91) {
                    inIPv6Addr = true;
                    continue;
                }
                if (inIPv6Addr && via[semiIndex] == 93) {
                    inIPv6Addr = false;
                    continue;
                }
                if (inIPv6Addr || via[semiIndex] != 58) continue;
                colonIndex = semiIndex;
            }
            int endHost = semiIndex;
            if (colonIndex > 0) {
                endHost = colonIndex;
                try {
                    String port = new String(via, colonIndex + 1, semiIndex - (colonIndex + 1), "UTF-8");
                    this._port = Integer.parseInt(port);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this._host = new String(via, offset, endHost - offset, "UTF-8");
            if (foundSemi) {
                String param = null;
                String value = "";
                int equalIndex = -1;
                for (int i = ++semiIndex; i < via.length; ++i) {
                    if (via[i] == 59) {
                        if (equalIndex > 0) {
                            value = new String(via, equalIndex + 1, i - (equalIndex + 1), "UTF-8");
                        } else if (param == null) {
                            param = new String(via, semiIndex, i - semiIndex, "UTF-8");
                        }
                        if (param != null) {
                            this._parameters.put(param, value);
                        }
                        param = null;
                        value = "";
                        equalIndex = -1;
                        semiIndex = i + 1;
                        continue;
                    }
                    if (via[i] != 61) continue;
                    param = new String(via, semiIndex, i - semiIndex, "UTF-8");
                    equalIndex = i;
                }
                if (equalIndex > 0) {
                    value = new String(via, equalIndex + 1, via.length - (equalIndex + 1), "UTF-8");
                } else {
                    param = new String(via, semiIndex, via.length - semiIndex, "UTF-8");
                }
                this._parameters.put(param, value);
            }
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SIP/2.0");
        sb.append('/');
        sb.append(this._transport);
        sb.append(' ');
        sb.append(this._host);
        if (this._port > -1) {
            sb.append(':');
            sb.append(this._port);
        }
        for (String name : this._parameters.keySet()) {
            String value = this._parameters.get(name);
            sb.append(';');
            sb.append(name);
            if (value == null || value.length() <= 0) continue;
            sb.append('=');
            sb.append(value);
        }
        return sb.toString();
    }

    public InetSocketAddress getNextHop() {
        return new InetSocketAddress(this._host, this._port);
    }

    public String getNextTransport() {
        return this._transport;
    }

    public String getTransport() {
        return this._transport;
    }

    public int getPort() {
        return this._port;
    }

    public String getHost() {
        return this._host;
    }

    public String getParameter(String param) {
        return this._parameters.get(param);
    }

    public String setParameter(String param, String value) {
        return this._parameters.put(param, value);
    }
}

