/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.dns;

import com.ericsson.eas.telurl.TelUrlResolver;
import com.ericsson.eas.telurl.TelUrlResolverException;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipURIImpl;
import com.ericsson.ssa.sip.dns.DnsLookupFailedException;
import com.ericsson.ssa.sip.dns.DnsServerUnavailableException;
import com.ericsson.ssa.sip.dns.EnumUtil;
import com.ericsson.ssa.sip.dns.NaptrComparator;
import com.ericsson.ssa.sip.dns.SipTransports;
import com.ericsson.ssa.sip.dns.SrvComparator;
import com.ericsson.ssa.sip.dns.SrvPrioLevelNoValidIpException;
import com.ericsson.ssa.sip.dns.TargetFailedRegister;
import com.ericsson.ssa.sip.dns.TargetResolver;
import com.ericsson.ssa.sip.dns.TargetTuple;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TelURL;
import javax.servlet.sip.URI;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnsResolver
implements TelUrlResolver {
    protected static DnsResolver myInstance = null;
    private Random myRandomInstance = new Random();
    private TargetFailedRegister myFailedTargets = new TargetFailedRegister();
    private Logger logger = Logger.getLogger("SipContainer");
    private String myEnumTopDomain = "e164.arpa";

    public static synchronized DnsResolver getInstance() {
        if (myInstance == null) {
            myInstance = new DnsResolver();
        }
        return myInstance;
    }

    public void setTargetFailed(TargetTuple target, int expireValue) {
        this.myFailedTargets.registerFailed(target, expireValue);
    }

    public boolean isTargetFailed(TargetTuple target) {
        return this.myFailedTargets.isFailed(target);
    }

    public TargetTuple lookupNameFromSRV(SRVRecord record, SipTransports theProtocol) throws DnsLookupFailedException, SrvPrioLevelNoValidIpException {
        TargetTuple tuple;
        String srvTarget = record.getTarget().toString();
        if (TargetResolver.isNumericIp(srvTarget)) {
            TargetTuple tuple2 = new TargetTuple(theProtocol, srvTarget, record.getPort());
            if (this.myFailedTargets.isFailed(tuple2)) {
                return null;
            }
            return tuple2;
        }
        String[] ips = this.lookupNameRecords(srvTarget);
        if (ips.length == 1) {
            TargetTuple tuple3 = new TargetTuple(theProtocol, ips[0], record.getPort());
            if (this.myFailedTargets.isFailed(tuple3)) {
                return null;
            }
            return tuple3;
        }
        int randomIndexToUse = 0;
        for (int attempts = 0; attempts < ips.length; ++attempts) {
            randomIndexToUse = this.getRandomIndex(ips.length);
            String ip = ips[randomIndexToUse];
            tuple = new TargetTuple(theProtocol, ip, record.getPort());
            if (this.myFailedTargets.isFailed(tuple)) continue;
            return tuple;
        }
        for (int i = 0; i < ips.length; ++i) {
            tuple = new TargetTuple(theProtocol, ips[i], record.getPort());
            if (this.myFailedTargets.isFailed(tuple)) continue;
            return tuple;
        }
        throw new SrvPrioLevelNoValidIpException("found no valid ip adress for this srv record:" + srvTarget);
    }

    public Record[] doLookup(String domainNameToLookup, int type) throws DnsLookupFailedException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "doLookup: " + domainNameToLookup + " " + Type.string((int)type));
            this.logger.log(Level.FINE, "current #cacheentries: " + Lookup.getDefaultCache((int)1).getSize());
        }
        if (domainNameToLookup.charAt(domainNameToLookup.length() - 1) != '.') {
            domainNameToLookup = domainNameToLookup + ".";
        }
        Lookup lkup = null;
        try {
            lkup = new Lookup(domainNameToLookup, type);
        }
        catch (TextParseException e) {
            throw new DnsLookupFailedException("Failed to lookup domain:" + domainNameToLookup + " error:" + e.getMessage());
        }
        Record[] records = lkup.run();
        int res = lkup.getResult();
        if (res == 2) {
            throw new DnsServerUnavailableException(lkup.getErrorString());
        }
        if (lkup.getResult() != 0) {
            throw new DnsLookupFailedException("no such domain:" + domainNameToLookup + " error:" + lkup.getErrorString());
        }
        return records;
    }

    public TargetTuple lookupSRVRecord(SipTransports theProtocol, String domainNameToLookup) {
        block10: {
            try {
                Record[] records = this.doLookup(domainNameToLookup, 33);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "number of DNS/SRV records:" + records.length);
                }
                Arrays.sort(records, new SrvComparator());
                int[] runningSum = new int[records.length];
                int deltaSum = 0;
                int numPriorityGroups = 0;
                int[] priorityGroupBoundaries = new int[records.length];
                int lastPrio = -1;
                int prioIndex = 0;
                for (int i = 0; i < records.length; ++i) {
                    SRVRecord srv = (SRVRecord)records[i];
                    if (srv.getPriority() != lastPrio) {
                        lastPrio = srv.getPriority();
                        deltaSum = 0;
                        priorityGroupBoundaries[prioIndex] = i;
                        ++prioIndex;
                        ++numPriorityGroups;
                    }
                    runningSum[i] = deltaSum += srv.getWeight();
                    if (!this.logger.isLoggable(Level.FINE)) continue;
                    this.logger.log(Level.FINE, "SRVRecord.toString():" + srv.toString());
                }
                for (prioIndex = 0; prioIndex < numPriorityGroups; ++prioIndex) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "SRV priolevel:" + prioIndex);
                    }
                    try {
                        return this.lookupSRVPrioLevel(prioIndex, theProtocol, runningSum, records, numPriorityGroups, priorityGroupBoundaries);
                    }
                    catch (SrvPrioLevelNoValidIpException noValidIPExc) {
                        continue;
                    }
                }
            }
            catch (DnsLookupFailedException dLookupEx) {
                if (!this.logger.isLoggable(Level.FINE)) break block10;
                this.logger.log(Level.FINE, dLookupEx.getMessage());
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "DNS/SRV No record found: " + domainNameToLookup);
        }
        return null;
    }

    public TargetTuple lookupSRVPrioLevel(int prioIndex, SipTransports theProtocol, int[] runningSum, Record[] records, int numPriorityGroups, int[] priorityGroupBoundaries) throws DnsLookupFailedException, SrvPrioLevelNoValidIpException {
        int firstIndex = priorityGroupBoundaries[prioIndex];
        int lastIndex = prioIndex + 1 < numPriorityGroups ? priorityGroupBoundaries[prioIndex + 1] - 1 : records.length - 1;
        int maxValue = runningSum[lastIndex] + 1;
        int testValue = this.getRandomIndex(maxValue);
        for (int i = firstIndex; i < lastIndex + 1; ++i) {
            SRVRecord srv = (SRVRecord)records[i];
            if (runningSum[i] < testValue) continue;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "found srv:" + srv.toString());
            }
            return this.lookupNameFromSRV(srv, theProtocol);
        }
        return null;
    }

    public TargetTuple lookupSRVDirect(SipTransports protocol, String domainNameToLookup) throws DnsLookupFailedException {
        return this.lookupSRVDirect(protocol, domainNameToLookup, false);
    }

    public TargetTuple lookupSRVDirect(SipTransports protocol, String domainNameToLookup, boolean isUdpMTUExceeded) throws DnsLookupFailedException {
        if (isUdpMTUExceeded && protocol == SipTransports.UDP_PROT) {
            protocol = SipTransports.TCP_PROT;
        }
        try {
            switch (protocol.ordinal()) {
                case 1: 
                case 2: {
                    return this.lookupSRVRecord(protocol, this.getSrvDirectLookupId(protocol, domainNameToLookup));
                }
            }
            TargetTuple target = null;
            if (!isUdpMTUExceeded && (target = this.lookupSRVDirect(SipTransports.UDP_PROT, domainNameToLookup)) != null || (target = this.lookupSRVDirect(SipTransports.TCP_PROT, domainNameToLookup)) != null) {
                // empty if block
            }
            return target;
        }
        catch (DnsLookupFailedException dnfe) {
            return null;
        }
    }

    private String getSrvDirectLookupId(SipTransports protocol, String domainNameToLookup) throws DnsLookupFailedException {
        String lookupStr = protocol.getSRVToken() + "." + domainNameToLookup;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "getDirectSrvLookupString:" + lookupStr);
        }
        return lookupStr;
    }

    public void clearLocalCache() {
        Cache cache = Lookup.getDefaultCache((int)1);
        cache.clearCache();
    }

    public String lookupName(String domainNameToLookup) throws Exception {
        String ip = this.lookupARecord(domainNameToLookup);
        if (ip != null) {
            return ip;
        }
        ip = this.lookupAAAARecord(domainNameToLookup);
        if (ip != null) {
            return ip;
        }
        return null;
    }

    public String[] lookupNameRecords(String domainNameToLookup) throws DnsLookupFailedException {
        String[] ips = null;
        ips = this.lookupARecords(domainNameToLookup);
        if (ips != null) {
            return ips;
        }
        ips = this.lookupAAAARecords(domainNameToLookup);
        if (ips != null) {
            return ips;
        }
        return null;
    }

    public String lookupARecord(String domainNameToLookup) throws DnsLookupFailedException {
        String[] ips = this.lookupARecords(domainNameToLookup);
        if (ips == null) {
            return null;
        }
        int indexToUse = 0;
        if (ips.length > 1) {
            indexToUse = this.getRandomIndex(ips.length);
        }
        return ips[indexToUse];
    }

    public String[] lookupAAAARecords(String domainNameToLookup) throws DnsLookupFailedException {
        try {
            Record[] records = this.doLookup(domainNameToLookup, 28);
            String[] ips = new String[records.length];
            for (int i = 0; i < records.length; ++i) {
                ips[i] = ((AAAARecord)records[i]).getAddress().toString();
            }
            return ips;
        }
        catch (DnsLookupFailedException dLookupEx) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, dLookupEx.getMessage());
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "DNS/A No record found: " + domainNameToLookup);
            }
            return null;
        }
    }

    public String[] lookupARecords(String domainNameToLookup) throws DnsLookupFailedException {
        try {
            Record[] records = this.doLookup(domainNameToLookup, 1);
            String[] ips = new String[records.length];
            for (int i = 0; i < records.length; ++i) {
                ips[i] = ((ARecord)records[i]).getAddress().getHostAddress();
            }
            return ips;
        }
        catch (DnsLookupFailedException dLookupEx) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, dLookupEx.getMessage());
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "DNS/A No record found: " + domainNameToLookup);
            }
            return null;
        }
    }

    public String lookupAAAARecord(String domainNameToLookup) throws DnsLookupFailedException {
        try {
            Record[] records = this.doLookup(domainNameToLookup, 28);
            int indexToUse = 0;
            if (records.length > 1) {
                indexToUse = this.getRandomIndex(records.length);
            }
            return ((AAAARecord)records[indexToUse]).getAddress().toString();
        }
        catch (DnsLookupFailedException dLookupEx) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, dLookupEx.getMessage());
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "DNS/AAAA No record found: " + domainNameToLookup);
            }
            return null;
        }
    }

    private int getRandomIndex(int upperIndex) {
        int indexToUse = this.myRandomInstance.nextInt(upperIndex);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Picked a random value between 0 and:" + upperIndex + " (excl). Random:" + indexToUse);
        }
        return indexToUse;
    }

    public TargetTuple lookupNAPTRRecord(String domainNameToLookup, boolean isUdpMTUExceeded) {
        block7: {
            try {
                Record[] records = this.doLookup(domainNameToLookup, 35);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "number of DNS/NAPTR records:" + records.length);
                }
                Arrays.sort(records, new NaptrComparator());
                for (int i = 0; i < records.length; ++i) {
                    NAPTRRecord record = (NAPTRRecord)records[i];
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "NAPTRRecord.toString():" + record.toString());
                    }
                    String service = record.getService();
                    if (SipTransports.UDP_PROT.isSupported() && service.equals(SipTransports.UDP_PROT.getNAPTRId()) && !isUdpMTUExceeded) {
                        return this.lookupSRVRecord(SipTransports.UDP_PROT, record.getReplacement().toString());
                    }
                    if (!SipTransports.TCP_PROT.isSupported() || !service.equals(SipTransports.TCP_PROT.getNAPTRId())) continue;
                    return this.lookupSRVRecord(SipTransports.TCP_PROT, record.getReplacement().toString());
                }
            }
            catch (DnsLookupFailedException dLookupEx) {
                if (!this.logger.isLoggable(Level.FINE)) break block7;
                this.logger.log(Level.FINE, dLookupEx.getMessage());
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "DNS/NAPTR No record found: " + domainNameToLookup);
        }
        return null;
    }

    public TelURL convertToTelURL(SipURI sipuri) throws TelUrlResolverException {
        String userParam = sipuri.getParameter("user");
        if (userParam == null || !userParam.equals("phone")) {
            throw new TelUrlResolverException("Missing parameter user=phone");
        }
        StringBuilder userTelUrl = new StringBuilder();
        userTelUrl.append("tel");
        userTelUrl.append(':');
        userTelUrl.append(sipuri.getUser());
        try {
            return (TelURL)SipFactoryImpl.getInstance().createURI(userTelUrl.toString());
        }
        catch (ServletParseException e) {
            throw new TelUrlResolverException((Exception)((Object)e));
        }
    }

    public SipURI lookupSipURI(URI uri) throws TelUrlResolverException, IOException {
        try {
            return this.doLookupSipURI(uri);
        }
        catch (DnsServerUnavailableException e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean isTelephoneNumber(URI uri) {
        if (uri.isSipURI()) {
            String userParam = ((SipURI)uri).getParameter("user");
            return userParam != null && userParam.equals("phone");
        }
        return uri.getScheme().equals("tel");
    }

    protected SipURI doLookupSipURI(URI uri) throws TelUrlResolverException {
        if (!this.isTelephoneNumber(uri)) {
            throw new TelUrlResolverException("The uri is not a phone number:" + uri);
        }
        TelURL telUrl = null;
        if (uri.isSipURI()) {
            telUrl = this.convertToTelURL((SipURI)uri);
        } else if (uri.getScheme().equals("tel")) {
            telUrl = (TelURL)uri;
        }
        if (!telUrl.isGlobal()) {
            throw new TelUrlResolverException("The number is not a global number");
        }
        try {
            String AUS = EnumUtil.getAUSValue(telUrl.getPhoneNumber());
            String domainNameToLookup = EnumUtil.toDomain(AUS, this.myEnumTopDomain);
            return this.lookupTelUrlNAPTRRecord(AUS, domainNameToLookup, new HashSet<String>(), 1);
        }
        catch (DnsServerUnavailableException dnsue) {
            throw dnsue;
        }
        catch (RuntimeException rte) {
            throw new TelUrlResolverException((Exception)rte);
        }
    }

    protected SipURI lookupTelUrlNAPTRRecord(String AUS, String e164arpa_domain, Set<String> visited, int depth) throws TelUrlResolverException {
        block15: {
            if (depth > 5 || !visited.add(e164arpa_domain)) {
                throw new TelUrlResolverException("Loop detected when resolving:" + AUS);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "depth:" + depth + " AUS:" + AUS + " domain:" + e164arpa_domain);
            }
            try {
                Record[] records = this.doLookup(e164arpa_domain, 35);
                Arrays.sort(records, new NaptrComparator());
                for (Record record : records) {
                    NAPTRRecord naptrRecord = (NAPTRRecord)record;
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "number of DNS/NAPTR records:" + records.length);
                        this.logger.log(Level.FINE, "NAPTRRecord.toString():" + record.toString());
                    }
                    String flag = naptrRecord.getFlags();
                    String service = naptrRecord.getService();
                    Name replacement = naptrRecord.getReplacement();
                    if (!service.equalsIgnoreCase("E2U+sip") && !service.equalsIgnoreCase("sip+E2U")) continue;
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "flag:" + naptrRecord.getFlags() + " flaglength:" + naptrRecord.getFlags().length());
                        this.logger.log(Level.FINE, "regexp:" + naptrRecord.getRegexp() + " replacement:" + replacement);
                    }
                    if (!EnumUtil.isEmpty(replacement) && flag.length() == 0) {
                        return this.lookupTelUrlNAPTRRecord(AUS, replacement.toString(), visited, ++depth);
                    }
                    String substitution = EnumUtil.applyRegExp(AUS, naptrRecord.getRegexp());
                    if (substitution == null) continue;
                    if (flag.equals("u")) {
                        int separator = substitution.indexOf(58);
                        if (separator == -1) {
                            throw new TelUrlResolverException("The regexp substitution result is not any supported uri:" + substitution);
                        }
                        String schemePart = substitution.substring(0, separator);
                        String theUriPart = substitution.substring(separator + 1);
                        if (schemePart.equals("tel")) {
                            return this.lookupTelUrlNAPTRRecord(AUS, EnumUtil.toDomain(theUriPart, this.myEnumTopDomain), visited, ++depth);
                        }
                        if (schemePart.equals("sip") || schemePart.equals("sips")) {
                            try {
                                SipURIImpl sipuri = new SipURIImpl(schemePart, theUriPart.getBytes(), 0);
                                String userParam = sipuri.getParameter("user");
                                if (userParam != null && userParam.equals("phone")) {
                                    String userTelUrl = sipuri.getUser();
                                    return this.lookupTelUrlNAPTRRecord(AUS, EnumUtil.toDomain(userTelUrl, this.myEnumTopDomain), visited, ++depth);
                                }
                                return sipuri;
                            }
                            catch (ServletParseException e) {
                                throw new TelUrlResolverException((Exception)((Object)e));
                            }
                        }
                        throw new TelUrlResolverException("The regexp substitution result is not any supported uri:" + substitution);
                    }
                    if (flag.length() != 0) continue;
                    return this.lookupTelUrlNAPTRRecord(AUS, substitution, visited, ++depth);
                }
            }
            catch (DnsLookupFailedException dLookupEx) {
                if (!this.logger.isLoggable(Level.FINE)) break block15;
                this.logger.log(Level.FINE, dLookupEx.getMessage());
            }
        }
        return null;
    }

    public void setEnumTopDomain(String topDomain) {
        this.myEnumTopDomain = topDomain;
    }

    public String getEnumTopDomain() {
        return this.myEnumTopDomain;
    }
}

