/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.dns;

import com.ericsson.ssa.container.TransportNotSupportedException;
import com.ericsson.ssa.dd.SessionCase;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.LayerHelper;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.URIImpl;
import com.ericsson.ssa.sip.ViaImpl;
import com.ericsson.ssa.sip.dns.DnsResolver;
import com.ericsson.ssa.sip.dns.TargetResolver;
import com.ericsson.ssa.sip.dns.TargetTuple;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;

public class ResolverManager
implements Layer {
    private static DnsResolver myDnsResolver = DnsResolver.getInstance();
    private static ResolverManager myResolverManager = new ResolverManager();
    private static TargetResolver myTargetResolver = TargetResolver.getInstance();
    private Layer _nextLayer;
    private Logger logger = Logger.getLogger("SipContainer");
    private final int UNDEFINED_SIZE = -1;
    private boolean defaultTCPTransport;
    private boolean _eas_503_disabled = false;

    private ResolverManager() {
    }

    public static ResolverManager getInstance() {
        return myResolverManager;
    }

    public synchronized boolean isDefaultTCPTransport() {
        return this.defaultTCPTransport;
    }

    public synchronized void setDefaultTCPTransport(Boolean defaultTCPTransport) {
        this.defaultTCPTransport = defaultTCPTransport;
    }

    public void next(SipServletRequestImpl req) {
        String rport;
        ViaImpl via = new ViaImpl(req.getHeader("Via"));
        if (via == null) {
            throw new IllegalAccessError("Missing via in request");
        }
        String host = via.getHost();
        String packetSourceAddress = req.getRemote().getIP();
        boolean isViaModified = false;
        if (TargetResolver.isNumericIp(host)) {
            if (!host.equals(packetSourceAddress)) {
                via.setParameter("received", packetSourceAddress);
                isViaModified = true;
            }
        } else {
            via.setParameter("received", packetSourceAddress);
            isViaModified = true;
        }
        if ((rport = via.getParameter("rport")) != null) {
            via.setParameter("rport", new Integer(req.getRemote().getPort()).toString());
            via.setParameter("received", packetSourceAddress);
            isViaModified = true;
        }
        if (isViaModified) {
            Header v = req.getRawHeader("Via");
            v.setReadOnly(false);
            ListIterator<String> it = v.getValues();
            it.next();
            it.set(via.toString());
            v.setReadOnly(true);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Updating via = " + via.toString());
            }
        }
        this.checkRouteHeader(req, true);
        req.pushTransactionDispatcher(this);
        req.pushApplicationDispatcher(this);
        LayerHelper.next(req, (Layer)this, this._nextLayer);
    }

    public void next(SipServletResponseImpl resp) {
        boolean shouldForwardResponseToApplication;
        block11: {
            if (resp.isRedirect()) {
                this.dispatch(resp);
                return;
            }
            shouldForwardResponseToApplication = true;
            if (resp.getStatus() == 503 && !this._eas_503_disabled) {
                int expireTime = 30;
                String retryAfterHeaderStr = resp.getHeader("Retry-After");
                String retryAfter = this.getRetryAfterValue(retryAfterHeaderStr);
                if (retryAfter != null) {
                    try {
                        expireTime = Integer.parseInt(retryAfter);
                    }
                    catch (NumberFormatException ignored) {
                        // empty catch block
                    }
                }
                try {
                    TargetResolver resolver = TargetResolver.getInstance();
                    SipServletRequestImpl req = (SipServletRequestImpl)resp.getRequest();
                    resolver.setTargetFailed(req.getRemote(), expireTime);
                    TargetTuple newDestination = resolver.resolveRequest(req, req.getMessageSize());
                    if (newDestination == null) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.log(Level.FINE, "List of available targets is exhausted");
                        }
                        shouldForwardResponseToApplication = true;
                    } else {
                        req.setRemote(newDestination);
                        req.popDispatcher().dispatch(req);
                        shouldForwardResponseToApplication = false;
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isLoggable(Level.FINE)) break block11;
                    this.logger.log(Level.FINE, "failed during response processing:", e);
                }
            }
        }
        if (shouldForwardResponseToApplication) {
            LayerHelper.next(resp, (Layer)this, this._nextLayer);
        }
    }

    public void registerNext(Layer layer) {
        this._nextLayer = layer;
    }

    public void dispatch(SipServletRequestImpl req) {
        block3: {
            try {
                if (this.doResolve(req, req.getMessageSize())) {
                    req.popDispatcher().dispatch(req);
                }
            }
            catch (TransportNotSupportedException noSuppExc) {
                if (!this.doResolve(req, -1)) break block3;
                req.popDispatcher().dispatch(req);
            }
        }
    }

    private boolean doResolve(SipServletRequestImpl req, int msgSize) {
        TargetTuple destination = null;
        try {
            destination = myTargetResolver.resolveRequest(req, msgSize);
        }
        catch (Throwable t) {
            this.logger.log(Level.INFO, "failed during request processing:", t);
        }
        if (destination == null) {
            this.handleResolvError(req);
            return false;
        }
        req.setRemote(destination);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "resolving req:\n" + destination.toString());
        }
        return true;
    }

    private void handleResolvError(SipServletRequestImpl req) {
        SipServletResponseImpl failureResp = req.createTerminatingResponse(408);
        if (failureResp == null) {
            return;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "failed to resolve req, send 408 response");
        }
        failureResp.popDispatcher().dispatch(failureResp);
    }

    public void dispatch(SipServletResponseImpl resp) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "sending response");
        }
        TargetTuple remote = null;
        try {
            remote = myTargetResolver.resolveResponse(resp);
            if (remote == null && this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "Ignoring response. Cannot resolve target for:" + resp);
                return;
            }
            resp.setRemote(remote);
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "Exception when resolving via header:", e);
            return;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "resolving via:\n" + remote.toString());
        }
        resp.popDispatcher().dispatch(resp);
    }

    public void checkRouteHeader(SipServletRequestImpl req, boolean remove) {
        Header r = req.getRawHeader("Route");
        if (r == null) {
            req.setFragmentId(((URIImpl)req.getRequestURI()).getFragmentId());
            req.setSessionCase(SessionCase.EXTERNAL);
        } else {
            r.setReadOnly(false);
            ListIterator<Address> it_a = null;
            try {
                it_a = r.getAddressValues();
            }
            catch (ServletParseException e) {
                SipServletResponseImpl failureResp = req.createTerminatingResponse(400);
                if (failureResp == null) {
                    return;
                }
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "failed to parse top route , send 400 response");
                }
                failureResp.popDispatcher().dispatch(failureResp);
                return;
            }
            Address a = it_a.next();
            URIImpl uri = (URIImpl)a.getURI();
            String CALL_PARAM = "call";
            String CALL_PARAM_ORIG = "orig";
            String CALL_PARAM_TERMINATING = "term_registered";
            String CALL_PARAM_TERMINATING_UNREG = "term_unregistered";
            String callParam = uri.getParameter("call");
            if (callParam == null) {
                req.setSessionCase(SessionCase.EXTERNAL);
            } else if (callParam.equals("orig")) {
                req.setSessionCase(SessionCase.ORIGINATING);
            } else if (callParam.equals("term_registered")) {
                req.setSessionCase(SessionCase.TERMINATING);
            } else if (callParam.equals("term_unregistered")) {
                req.setSessionCase(SessionCase.TERMINATING_UNREGISTERED);
            } else {
                req.setSessionCase(SessionCase.EXTERNAL);
                this.logger.log(Level.WARNING, "Assigned SessionCase external due to unknown value of call :" + callParam);
            }
            if (uri.getLrParam()) {
                req.setFragmentId(((URIImpl)a.getURI()).getFragmentId());
                if (remove) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "Removing route = " + a);
                    }
                    it_a.remove();
                    req.setPoppedRoute(a);
                    req.setRecordRouteURI(uri);
                }
            } else {
                throw new IllegalAccessError("we do not support strict routes yet");
            }
            r.setReadOnly(true);
        }
    }

    private String getRetryAfterValue(String retry_after) {
        int stopIndex;
        if (retry_after == null) {
            return null;
        }
        int length = retry_after.length();
        for (stopIndex = 0; stopIndex < length && Character.isDigit(retry_after.charAt(stopIndex)); ++stopIndex) {
        }
        return retry_after.substring(0, stopIndex);
    }

    public void setEnumTopDomain(String topDomain) {
        myDnsResolver.setEnumTopDomain(topDomain);
    }

    public String getEnumTopDomain() {
        return myDnsResolver.getEnumTopDomain();
    }

    public Boolean isEas503Disabled() {
        return this._eas_503_disabled;
    }

    public void setEas503Disabled(Boolean disabled) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Eas503Disabled property is set to " + disabled);
        }
        this._eas_503_disabled = disabled;
    }
}

