/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.dns;

import com.ericsson.ssa.sip.dns.TargetTuple;
import java.util.Date;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TargetFailedRegister
extends TimerTask {
    private ConcurrentHashMap<String, Long> myHashMap = new ConcurrentHashMap();
    private final int myTimerInterval = 60;
    private Timer myTimer;
    private Logger logger = Logger.getLogger("SipContainer");
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFailed(TargetTuple target, int expireValue) {
        String failedEntryKey = target.key();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "registerFailed :" + failedEntryKey);
        }
        this.myHashMap.put(failedEntryKey, new Long(new Date().getTime() + (long)(expireValue * 1000)));
        Object object = this.lock;
        synchronized (object) {
            if (this.myTimer == null) {
                this.myTimer = new Timer();
                this.myTimer.scheduleAtFixedRate((TimerTask)this, 0L, 60000L);
            }
        }
    }

    public boolean isFailed(TargetTuple target) {
        String failedEntryKey = target.key();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "check if target failed:" + failedEntryKey);
        }
        boolean targetIsFailed = false;
        Long o = this.myHashMap.get(failedEntryKey);
        if (o != null) {
            long now;
            long expireAt = o;
            if (expireAt > (now = new Date().getTime())) {
                targetIsFailed = true;
            } else {
                this.myHashMap.remove(o);
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "check if target failed:" + targetIsFailed);
        }
        return targetIsFailed;
    }

    public void debugRegister() {
        this.logger.log(Level.FINE, "____________________________");
        this.logger.log(Level.FINE, "Debug status in failed targets register\n");
        Enumeration<Long> e = this.myHashMap.elements();
        Enumeration<String> f = this.myHashMap.keys();
        while (e.hasMoreElements() && f.hasMoreElements()) {
            this.logger.log(Level.FINE, f.nextElement() + " timestamp:" + e.nextElement());
        }
        this.logger.log(Level.FINE, "____________________________");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Cleaning the TargetFailedRegister");
        }
        Enumeration<Long> e = this.myHashMap.elements();
        Enumeration<String> f = this.myHashMap.keys();
        while (e.hasMoreElements()) {
            Long entry = e.nextElement();
            long now = new Date().getTime();
            if (entry > now) continue;
            String key = f.nextElement();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "removing " + key + " timestamp:" + entry);
            }
            this.myHashMap.remove(key);
        }
        if (this.myHashMap.size() == 0) {
            Object object = this.lock;
            synchronized (object) {
                this.myTimer.cancel();
                this.myTimer = null;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Cancel the TargetFailedRegister timer");
                }
            }
        }
    }

    public void run() {
        this.clean();
    }
}

