/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.dns;

import com.ericsson.ssa.sip.AddressImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.ViaImpl;
import com.ericsson.ssa.sip.dns.DnsLookupFailedException;
import com.ericsson.ssa.sip.dns.DnsResolver;
import com.ericsson.ssa.sip.dns.ResolverManager;
import com.ericsson.ssa.sip.dns.SipTransports;
import com.ericsson.ssa.sip.dns.TargetTuple;
import com.ericsson.ssa.sip.dns.UDPProtocol;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;

public class TargetResolver {
    private static TargetResolver myInstance = new TargetResolver();
    private static DnsResolver myDnsResolver = DnsResolver.getInstance();
    private static final int UNDEFINED_PORTNO = -1;
    public static final int DEFAULT_RETRYTIME = 30;
    private final int MAX_MTU_SIZE_EXCL_VIA = 1250;
    private Logger logger = Logger.getLogger("SipContainer");

    private TargetResolver() {
    }

    public static TargetResolver getInstance() {
        return myInstance;
    }

    public void setFailed(TargetTuple target) {
        this.setTargetFailed(target, 30);
    }

    public void setTargetFailed(TargetTuple target, int expireValue) {
        myDnsResolver.setTargetFailed(target, expireValue);
    }

    public TargetTuple resolveResponse(SipServletResponseImpl resp) throws Exception {
        ViaImpl via = new ViaImpl(resp.getHeader("Via"));
        SipTransports transport = SipTransports.getTransport(via.getTransport());
        if (transport == SipTransports.UDP_PROT) {
            return this.resolveRespUDP(resp, via);
        }
        return this.resolveRespTCP(resp, via, transport);
    }

    public TargetTuple resolveRespUDP(SipServletResponseImpl resp, ViaImpl via) throws Exception {
        UDPProtocol transport = SipTransports.UDP_PROT;
        String maddr = null;
        maddr = via.getParameter("maddr");
        if (maddr != null) {
            return this.resolveRespMaddr(maddr, via, transport);
        }
        String received = via.getParameter("received");
        if (received != null) {
            return this.resolveRespReceived(received, via, transport);
        }
        return this.resolveResp3263_5(via);
    }

    public TargetTuple resolveRespTCP(SipServletResponseImpl resp, ViaImpl via, SipTransports transport) throws Exception {
        String received = via.getParameter("received");
        if (received != null) {
            return this.resolveRespReceived(received, via, transport);
        }
        return this.resolveResp3263_5(via);
    }

    public TargetTuple resolveRespAlternate(SipServletResponseImpl resp) throws Exception {
        ViaImpl via = new ViaImpl(resp.getHeader("Via"));
        return this.resolveResp3263_5(via);
    }

    private TargetTuple resolveRespReceived(String received_ip, ViaImpl via, SipTransports transport) throws Exception {
        int port = via.getPort();
        String rport = null;
        rport = via.getParameter("rport");
        if (rport != null) {
            port = Integer.parseInt(rport);
        } else if (port == -1) {
            port = transport.getDefaultPort();
        }
        return new TargetTuple(transport, received_ip, port);
    }

    private TargetTuple resolveRespMaddr(String maddr, ViaImpl via, SipTransports transport) throws Exception {
        int port = via.getPort();
        if (port == -1) {
            port = transport.getDefaultPort();
        }
        if (!TargetResolver.isNumericIp(maddr)) {
            String ip = myDnsResolver.lookupName(maddr);
            if (ip == null) {
                throw new DnsLookupFailedException("Dns A lookup failed for host:" + maddr);
            }
            maddr = ip;
        }
        return new TargetTuple(transport, maddr, port);
    }

    public TargetTuple resolveResp3263_5(ViaImpl via) throws Exception {
        SipTransports transport;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "TargetResolver.resolve():\n VIA:" + via.toString() + "\n");
        }
        if (!(transport = SipTransports.getTransport(via.getTransport())).isSupported()) {
            throw new Exception("This transport is disabled in configuration: " + via.getTransport());
        }
        int port = via.getPort();
        String host = via.getHost();
        if (TargetResolver.isNumericIp(host)) {
            if (port == -1) {
                port = transport.getDefaultPort();
            }
        } else if (port != -1) {
            String ip = myDnsResolver.lookupName(host);
            if (ip == null) {
                throw new DnsLookupFailedException("Dns A lookup failed for host:" + host);
            }
            host = ip;
        } else {
            TargetTuple target = null;
            target = myDnsResolver.lookupSRVDirect(transport, host);
            if (target != null) {
                return target;
            }
            throw new Exception("Failed to find a valid SRV record for via:" + via);
        }
        return new TargetTuple(transport, host, port);
    }

    public TargetTuple resolveRequest(SipServletRequestImpl req, int msgSize) throws Exception {
        SipURI sipuri;
        URI uri = null;
        String uriStr = null;
        uriStr = req.getHeader("Route");
        if (uriStr != null) {
            AddressImpl address = new AddressImpl(uriStr);
            uri = address.getURI();
        } else {
            uri = req.getRequestURI();
        }
        if (myDnsResolver.isTelephoneNumber(uri)) {
            sipuri = myDnsResolver.doLookupSipURI(uri);
            if (sipuri == null) {
                return null;
            }
            this.updateDefaultTransportParameter((URI)sipuri);
            return this.resolveReq3263_4(sipuri, msgSize);
        }
        if (uri.isSipURI()) {
            sipuri = (SipURI)uri;
            this.updateDefaultTransportParameter((URI)sipuri);
            return this.resolveReq3263_4(sipuri, msgSize);
        }
        throw new Exception("Unknown type of uri :" + uri);
    }

    public void updateDefaultTransportParameter(URI uri) {
        if (!uri.isSipURI()) {
            return;
        }
        SipURI sipURI = (SipURI)uri;
        if (sipURI.isSecure() || sipURI.getTransportParam() != null) {
            return;
        }
        boolean isDefaultTCPTransport = ResolverManager.getInstance().isDefaultTCPTransport();
        if (isDefaultTCPTransport) {
            sipURI.setTransportParam(SipTransports.TCP_PROT.name());
        }
    }

    public TargetTuple resolveReq3263_4(SipURI sipuri, int msgSize) throws Exception {
        TargetTuple tuple;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "TargetResolver.resolve():\n URI:" + sipuri.toString() + "\n");
        }
        String host = sipuri.getHost();
        String maddr = sipuri.getMAddrParam();
        if (maddr != null) {
            host = maddr;
        }
        SipTransports theTransport = SipTransports.UNDEFINED_PROT;
        int thePort = sipuri.getPort();
        boolean isUdpMTUExceeded = false;
        if (msgSize > 1250) {
            isUdpMTUExceeded = true;
        }
        String transport = sipuri.getTransportParam();
        TargetTuple target = null;
        if (transport != null) {
            theTransport = SipTransports.getTransport(transport);
        } else if (TargetResolver.isNumericIp(host) && theTransport == SipTransports.UNDEFINED_PROT) {
            theTransport = sipuri.isSecure() ? SipTransports.TLS_PROT : SipTransports.UDP_PROT;
        } else if (thePort != -1) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "port specified in URI:" + sipuri.getPort());
            }
            if (theTransport == SipTransports.UNDEFINED_PROT) {
                theTransport = SipTransports.UDP_PROT;
            }
        } else {
            target = myDnsResolver.lookupNAPTRRecord(host, isUdpMTUExceeded);
            if (target != null) {
                return target;
            }
            target = myDnsResolver.lookupSRVDirect(theTransport, host, isUdpMTUExceeded);
            if (target != null) {
                return target;
            }
            theTransport = SipTransports.UDP_PROT;
        }
        if (thePort == -1) {
            thePort = theTransport.getDefaultPort();
        }
        if (!TargetResolver.isNumericIp(host)) {
            String ip = myDnsResolver.lookupName(host);
            if (ip == null) {
                return null;
            }
            host = ip;
        }
        if (theTransport == SipTransports.UDP_PROT && isUdpMTUExceeded) {
            theTransport = SipTransports.TCP_PROT;
        }
        if (myDnsResolver.isTargetFailed(tuple = new TargetTuple(theTransport, host, thePort))) {
            return null;
        }
        return tuple;
    }

    public static boolean isIPV6(String ipAddress) {
        return ipAddress.charAt(0) == '[' && ipAddress.indexOf(93) != -1;
    }

    public static boolean isNumericIp(String host) {
        return Character.isDigit(host.charAt(0)) || host.charAt(0) == '[';
    }
}

