/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.dns;

import com.ericsson.ssa.sip.dns.SipTransports;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class TargetTuple
implements Externalizable {
    private static final long serialVersionUID = 3257289110686283316L;
    private static final int UNDEFINED_PORTNO = -1;
    private String myIp;
    private int myPort;
    private SipTransports myProtocol;

    public TargetTuple() {
    }

    public TargetTuple(SipTransports transportProtocol, InetSocketAddress socketAddress) {
        this.myProtocol = transportProtocol;
        this.myIp = socketAddress.getAddress().getHostAddress();
        this.myPort = socketAddress.getPort();
    }

    public TargetTuple(SipTransports transportProtocol, String ip, int port) {
        this.myProtocol = transportProtocol;
        this.myIp = ip;
        this.myPort = port;
    }

    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeUTF(this.myIp);
        output.writeInt(this.myPort);
        output.writeObject(this.myProtocol);
    }

    public void readExternal(ObjectInput input) throws IOException {
        this.myIp = input.readUTF();
        this.myPort = input.readInt();
        try {
            this.myProtocol = (SipTransports)input.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public String getIP() {
        return this.myIp;
    }

    public InetSocketAddress getSocketAddress() {
        try {
            return new InetSocketAddress(InetAddress.getByName(this.myIp), this.myPort);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public InetAddress getAddress() {
        try {
            return InetAddress.getByName(this.myIp);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public int getPort() {
        return this.myPort;
    }

    public SipTransports getProtocol() {
        return this.myProtocol;
    }

    public boolean equals(Object org) {
        if (!(org instanceof TargetTuple)) {
            return false;
        }
        TargetTuple tt = (TargetTuple)org;
        if (this.myPort != tt.myPort) {
            return false;
        }
        if (this.myIp != null && !this.myIp.equals(tt.myIp)) {
            return false;
        }
        return this.myProtocol == null || this.myProtocol.equals(tt.myProtocol);
    }

    public int hashCode() {
        return this.myIp.hashCode() ^ this.myPort;
    }

    public String key() {
        return this.myProtocol.name() + ":" + this.myIp + ":" + this.myPort;
    }

    public String toString() {
        String protocolString = this.myProtocol.name();
        return "________________________\n\nip:" + this.myIp + "\nport:" + this.myPort + "\ntransportProtocol:" + protocolString + "\n______________________\n";
    }
}

