/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.timer;

import com.ericsson.ssa.container.SipContainerThreadPool;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipSessionManager;
import com.ericsson.ssa.sip.timer.ServletTimerImpl;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.TimerService;

public class TimerServiceImpl
implements TimerService,
TimerListener {
    private static TimerServiceImpl _instance = new TimerServiceImpl();
    private static Logger logger = Logger.getLogger("SipContainer");
    private SipContainerThreadPool _schedPool = null;

    private TimerServiceImpl() {
    }

    public static TimerServiceImpl getInstance() {
        return _instance;
    }

    public ServletTimer createTimer(SipApplicationSession appSession, long delay, boolean isPersistent, Serializable info) {
        SipApplicationSessionImpl as = (SipApplicationSessionImpl)appSession;
        SipSessionManager ssm = as.getSipSessionManager();
        if (null == ssm || !as.isValid()) {
            throw new IllegalStateException("Invalid SipApplicationSession");
        }
        TimerListener tl = as.getTimerListener();
        if (tl == null) {
            throw new IllegalStateException("No TimerListener is configured ");
        }
        ServletTimerImpl st = this.createTimer(ssm, as, tl, delay, isPersistent, info);
        return st;
    }

    public ServletTimer createTimer(SipApplicationSession appSession, long delay, long period, boolean fixedDelay, boolean isPersistent, Serializable info) {
        if (period < 1L) {
            throw new IllegalArgumentException("Period should be greater than 0");
        }
        SipApplicationSessionImpl as = (SipApplicationSessionImpl)appSession;
        SipSessionManager ssm = as.getSipSessionManager();
        if (null == ssm || !as.isValid()) {
            throw new IllegalStateException("Invalid SipApplicationSession");
        }
        TimerListener tl = as.getTimerListener();
        if (tl == null) {
            throw new IllegalStateException("No TimerListener is configured ");
        }
        ServletTimerImpl st = this.createTimer(ssm, as, tl, delay, period, fixedDelay, isPersistent, info);
        return st;
    }

    public ServletTimerImpl createTimer(TimerListener listener, long delay, boolean isPersistent, Serializable info) {
        return this.createTimer(null, null, listener, delay, isPersistent, info);
    }

    public ServletTimerImpl createTimer(TimerListener listener, long delay, long period, boolean fixedDelay, boolean isPersistent, Serializable info) {
        return this.createTimer(null, null, listener, delay, period, fixedDelay, isPersistent, info);
    }

    private ServletTimerImpl createTimer(SipSessionManager ssm, SipApplicationSessionImpl sas, TimerListener listener, long delay, boolean isPersistent, Serializable info) {
        this.setupScheduller();
        ServletTimerImpl st = null;
        st = ssm != null ? ssm.createServletTimer(sas, info, delay, listener) : new ServletTimerImpl(info, delay, listener);
        ScheduledFuture<?> f = this._schedPool.schedule(st, delay, TimeUnit.MILLISECONDS);
        st.setFuture(f);
        if (isPersistent) {
            // empty if block
        }
        return st;
    }

    private ServletTimerImpl createTimer(SipSessionManager ssm, SipApplicationSessionImpl sas, TimerListener listener, long delay, long period, boolean fixedDelay, boolean isPersistent, Serializable info) {
        this.setupScheduller();
        ServletTimerImpl st = null;
        st = ssm != null ? ssm.createServletTimer(sas, info, delay, fixedDelay, period, listener) : new ServletTimerImpl(info, delay, fixedDelay, period, listener);
        ScheduledFuture<?> f = null;
        f = fixedDelay ? this._schedPool.scheduleWithFixedDelay(st, delay, period, TimeUnit.MILLISECONDS) : this._schedPool.scheduleAtFixedRate(st, delay, period, TimeUnit.MILLISECONDS);
        st.setFuture(f);
        if (isPersistent) {
            // empty if block
        }
        return st;
    }

    public void deserializeTimer(ServletTimerImpl timer, long initDelay) {
        TimerListener l = timer.getListener();
        ServletTimerImpl st = timer;
        this.setupScheduller();
        ScheduledFuture<?> f = null;
        f = !st.isRepeatingTimer() ? this._schedPool.schedule(st, initDelay, TimeUnit.MILLISECONDS) : (st.isFixedDelay() ? this._schedPool.scheduleWithFixedDelay(st, initDelay, st.getPeriod(), TimeUnit.MILLISECONDS) : this._schedPool.scheduleAtFixedRate(st, initDelay, st.getPeriod(), TimeUnit.MILLISECONDS));
        st.setFuture(f);
    }

    private void setupScheduller() {
        if (this._schedPool == null) {
            this._schedPool = SipContainerThreadPool.getInstance();
            if (this._schedPool == null) {
                throw new IllegalStateException("Failed to get access to the ThreadPool");
            }
            this.createTimer(this, 10000L, 10000L, false, false, null);
        }
    }

    public void timeout(ServletTimer timer) {
        this._schedPool.purge();
    }
}

