/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.transaction;

import com.ericsson.ssa.container.NetworkManager;
import com.ericsson.ssa.container.startup.PerformanceMBeanListener;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.MultiLineHeader;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.ViaImpl;
import com.ericsson.ssa.sip.timer.ServletTimerImpl;
import com.ericsson.ssa.sip.transaction.ClientTransaction;
import com.ericsson.ssa.sip.transaction.TransactionState;
import com.ericsson.ssa.sip.transaction.TransactionTimer;
import java.io.Serializable;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.servlet.sip.ServletTimer;

public class InviteClientTransaction
extends ClientTransaction {
    private ServletTimerImpl _timerA;
    private ServletTimerImpl _timerB;
    private ServletTimerImpl _timerC;
    private ServletTimerImpl _timerD;
    private ServletTimerImpl _timerRemoveTransaction;
    private SipServletRequestImpl _ack = null;
    private boolean _has101To199Response = false;

    public InviteClientTransaction(String id, SipServletRequestImpl req) {
        super(id, TransactionState.CALLING, req);
        this._request.saveRetransmissionApplicationStack();
        if (!this._request.isContactIndicated()) {
            this._timerC = _timerService.createTimer(this, 200000L, false, (Serializable)((Object)TransactionTimer.TimerC));
        }
        this._timerB = _timerService.createTimer(this, 64L * T1, false, (Serializable)((Object)TransactionTimer.TimerB));
        if (!this._reliableTransport) {
            this._timerA = _timerService.createTimer(this, T1, false, (Serializable)((Object)TransactionTimer.TimerA));
        }
    }

    public synchronized boolean handle(SipServletResponseImpl resp) {
        resp.setRequest(this._request);
        int status = resp.getStatus() / 100;
        int xx = resp.getStatus() % 100;
        switch (this._state) {
            case CALLING: {
                if (status == 1) {
                    if (this._timerA != null) {
                        this._timerA.cancel();
                        this._timerA = null;
                    }
                    if (this._timerB != null) {
                        this._timerB.cancel();
                        this._timerB = null;
                    }
                    this.resetTimerC(xx);
                    this._state = TransactionState.PROCEEDING;
                    break;
                }
                if (status == 2) {
                    this.toEstablished(resp);
                    break;
                }
                this.toCompleted(resp);
                break;
            }
            case PROCEEDING: {
                if (status == 1) {
                    this.resetTimerC(xx);
                    break;
                }
                if (status == 2) {
                    this.toEstablished(resp);
                    break;
                }
                this.toCompleted(resp);
                break;
            }
            case COMPLETED: {
                if (status >= 2 && status <= 6) {
                    this.createHopAck(resp);
                }
                return true;
            }
            case ESTABLISHED: {
                break;
            }
            case TERMINATED: {
                break;
            }
            default: {
                _log.log(Level.FINE, "IllegalState in ICT = " + (Object)((Object)this._state));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(ServletTimer timer) {
        TransactionTimer tt = (TransactionTimer)((Object)timer.getInfo());
        Dispatcher d = null;
        SipServletResponseImpl resp = null;
        SipServletRequestImpl req = null;
        switch (tt) {
            case TimerA: {
                InviteClientTransaction inviteClientTransaction = this;
                synchronized (inviteClientTransaction) {
                    if (this._state == TransactionState.CALLING) {
                        long delay = ((ServletTimerImpl)timer).getDelay();
                        this._timerA = _timerService.createTimer(this, delay *= 2L, false, (Serializable)((Object)TransactionTimer.TimerA));
                        this._request.restoreRetransmissionApplicationStack();
                        req = (SipServletRequestImpl)this._request.clone();
                    }
                }
                if (req == null) break;
                d = req.popDispatcher();
                if (d != null) {
                    d.dispatch(req);
                }
                if (!PerformanceMBeanListener.isEnabled()) break;
                this.updateLastAccessTimestamp();
                break;
            }
            case TimerB: {
                if (_log.isLoggable(Level.FINE)) {
                    _log.log(Level.FINE, "Timer B fired - terminating()");
                }
                InviteClientTransaction inviteClientTransaction = this;
                synchronized (inviteClientTransaction) {
                    resp = this.sendRequestTimeout();
                    this.terminate();
                }
                d = resp.popDispatcher();
                if (d == null) break;
                d.dispatch(resp);
                break;
            }
            case TimerC: {
                if (_log.isLoggable(Level.FINE)) {
                    _log.log(Level.FINE, "Timer C fired - terminating()");
                }
                InviteClientTransaction inviteClientTransaction = this;
                synchronized (inviteClientTransaction) {
                    if (this._state == TransactionState.CALLING || this._state == TransactionState.PROCEEDING) {
                        if (this._has101To199Response) {
                            req = this.sendCancel();
                        } else {
                            resp = this.sendRequestTimeout();
                            this.terminate();
                        }
                    }
                }
                if (this._has101To199Response) {
                    if (req == null || (d = req.popDispatcher()) == null) break;
                    d.dispatch(req);
                    break;
                }
                if (_log.isLoggable(Level.INFO)) {
                    _log.log(Level.INFO, "Timer C fired - send 408 Request Timeout");
                }
                if ((d = resp.popDispatcher()) == null) break;
                d.dispatch(resp);
                break;
            }
            case TimerD: {
                this.terminate();
                break;
            }
            case TimerRemoveTransaction: {
                if (_log.isLoggable(Level.FINE)) {
                    _log.log(Level.FINE, "Timer RemoveTransaction fired - terminating()");
                }
                this.terminate();
                break;
            }
            default: {
                _log.log(Level.FINE, "IllegalTimer in ICT = " + (Object)((Object)tt));
            }
        }
    }

    private void resetTimerC(int xx) {
        if (!this._request.isContactIndicated() && xx != 0) {
            if (this._timerC != null) {
                this._timerC.cancel();
            }
            this._timerC = _timerService.createTimer(this, 200000L, false, (Serializable)((Object)TransactionTimer.TimerC));
            this._has101To199Response = true;
        }
    }

    private SipServletRequestImpl sendCancel() {
        Header via = this._request.getRawHeader("Via");
        ListIterator<String> li = via.getValues();
        String topVia = li.next();
        if (topVia != null) {
            SipServletRequestImpl cancel = this._request.createCancelImpl();
            MultiLineHeader viaOfCancel = new MultiLineHeader("Via", true);
            ViaImpl v = new ViaImpl(topVia);
            ((Header)viaOfCancel).setValue(v.toString(), true);
            cancel.setHeader(viaOfCancel);
            return cancel;
        }
        _log.log(Level.SEVERE, "Can not send CANCEL because INVITE does not have via: " + this._request.toString());
        return null;
    }

    private SipServletResponseImpl sendRequestTimeout() {
        SipServletResponseImpl resp = this._request.createTerminatingResponse(408);
        Header via = resp.getRawHeader("Via");
        via.setReadOnly(false);
        ListIterator<String> li = via.getValues();
        li.next();
        li.remove();
        via.setReadOnly(true);
        SipServletRequestImpl req = this._request.getTransactionRequest();
        if (req != null && resp != null) {
            resp.setRequest(req);
            resp.setSession(req.getSessionImpl());
        }
        return resp;
    }

    protected synchronized void terminate() {
        super.terminate();
        if (this._timerA != null) {
            this._timerA.cancel();
            this._timerA = null;
        }
        if (this._timerB != null) {
            this._timerB.cancel();
            this._timerB = null;
        }
        if (this._timerC != null) {
            this._timerC.cancel();
            this._timerC = null;
        }
        if (this._timerD != null) {
            this._timerD.cancel();
            this._timerD = null;
        }
        if (this._timerRemoveTransaction != null) {
            this._timerRemoveTransaction.cancel();
            this._timerRemoveTransaction = null;
        }
        this._state = TransactionState.TERMINATED;
    }

    private void toCompleted(SipServletResponseImpl resp) {
        this.createHopAck(resp);
        if (this._timerB != null) {
            this._timerB.cancel();
            this._timerB = null;
        }
        if (this._timerC != null) {
            this._timerC.cancel();
            this._timerC = null;
        }
        if (!this._reliableTransport) {
            if (PerformanceMBeanListener.isEnabled()) {
                this.updateLastAccessTimestamp();
            }
            if (this._timerA != null) {
                this._timerA.cancel();
                this._timerA = null;
            }
            this._state = TransactionState.COMPLETED;
            this._timerD = _timerService.createTimer(this, 64L * T1, false, (Serializable)((Object)TransactionTimer.TimerD));
        } else {
            this._state = TransactionState.TERMINATED;
            super.terminate();
        }
    }

    private void toEstablished(SipServletResponseImpl resp) {
        if (this._timerB != null) {
            this._timerB.cancel();
            this._timerB = null;
        }
        if (!this._reliableTransport) {
            if (PerformanceMBeanListener.isEnabled()) {
                this.updateLastAccessTimestamp();
            }
            if (this._timerA != null) {
                this._timerA.cancel();
                this._timerA = null;
            }
        }
        this._timerRemoveTransaction = _timerService.createTimer(this, 64L * T1, false, (Serializable)((Object)TransactionTimer.TimerRemoveTransaction));
        this._state = TransactionState.ESTABLISHED;
    }

    private void createHopAck(SipServletResponseImpl response) {
        if (this._ack == null) {
            this._ack = response.createHopAckImpl(this._request);
        }
        NetworkManager.getInstance().dispatch(this._ack);
    }
}

