/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.transaction;

import com.ericsson.ssa.container.startup.PerformanceMBeanListener;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.timer.ServletTimerImpl;
import com.ericsson.ssa.sip.transaction.ClientTransaction;
import com.ericsson.ssa.sip.transaction.TransactionState;
import com.ericsson.ssa.sip.transaction.TransactionTimer;
import java.io.Serializable;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.servlet.sip.ServletTimer;

public class NonInviteClientTransaction
extends ClientTransaction {
    private ServletTimerImpl _timerE;
    private ServletTimerImpl _timerF;
    private ServletTimerImpl _timerK;

    public NonInviteClientTransaction(String id, SipServletRequestImpl req) {
        super(id, TransactionState.TRYING, req);
        this._request.saveRetransmissionApplicationStack();
        this._timerF = _timerService.createTimer(this, 64L * T1, false, (Serializable)((Object)TransactionTimer.TimerF));
        if (!this._reliableTransport) {
            this._timerE = _timerService.createTimer(this, T1, false, (Serializable)((Object)TransactionTimer.TimerE));
        }
    }

    public synchronized boolean handle(SipServletResponseImpl resp) {
        resp.setRequest(this._request);
        int status = resp.getStatus() / 100;
        switch (this._state) {
            case TRYING: {
                if (status == 1) {
                    if (this._timerE != null) {
                        this._timerE.cancel();
                        this._timerE = _timerService.createTimer(this, T2, false, (Serializable)((Object)TransactionTimer.TimerE));
                    }
                    this._state = TransactionState.PROCEEDING;
                    break;
                }
                this.toCompleted(resp);
                break;
            }
            case PROCEEDING: {
                if (status == 1) break;
                this.toCompleted(resp);
                break;
            }
            case COMPLETED: {
                break;
            }
            case TERMINATED: {
                break;
            }
            default: {
                _log.log(Level.FINE, "IllegalState in ICT = " + (Object)((Object)this._state));
            }
        }
        return resp.getMethod().equals("CANCEL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(ServletTimer timer) {
        TransactionTimer tt = (TransactionTimer)((Object)timer.getInfo());
        SipServletRequestImpl req = null;
        Dispatcher d = null;
        switch (tt) {
            case TimerE: {
                NonInviteClientTransaction nonInviteClientTransaction = this;
                synchronized (nonInviteClientTransaction) {
                    if (this._state == TransactionState.TRYING || this._state == TransactionState.PROCEEDING) {
                        long delay = T2;
                        if (this._state == TransactionState.TRYING) {
                            delay = ((ServletTimerImpl)timer).getDelay();
                            long l = delay = delay * 2L <= T2 ? delay * 2L : T2;
                        }
                        if (this._timerE != null) {
                            this._timerE.cancel();
                        }
                        this._timerE = _timerService.createTimer(this, delay, false, (Serializable)((Object)TransactionTimer.TimerE));
                        this._request.restoreRetransmissionApplicationStack();
                        req = (SipServletRequestImpl)this._request.clone();
                    }
                }
                if (req == null) break;
                d = req.popDispatcher();
                if (d != null) {
                    d.dispatch(req);
                }
                if (!PerformanceMBeanListener.isEnabled()) break;
                this.updateLastAccessTimestamp();
                break;
            }
            case TimerF: {
                SipServletResponseImpl resp = null;
                NonInviteClientTransaction delay = this;
                synchronized (delay) {
                    if (this._state == TransactionState.TRYING || this._state == TransactionState.PROCEEDING) {
                        resp = this._request.createTerminatingResponse(408);
                        req = this._request.getTransactionRequest();
                        if (req != null && resp != null) {
                            resp.setRequest(req);
                            resp.setSession(req.getSessionImpl());
                        }
                    }
                    this.terminate();
                }
                if (resp == null) break;
                Header via = resp.getRawHeader("Via");
                via.setReadOnly(false);
                ListIterator<String> li = via.getValues();
                li.next();
                li.remove();
                via.setReadOnly(true);
                if (_log.isLoggable(Level.INFO)) {
                    _log.log(Level.INFO, "Timer F fired - send 408 Request Timeout " + (Object)((Object)this._state) + " , response = " + resp.toDebugString());
                }
                if ((d = resp.popDispatcher()) == null) break;
                d.dispatch(resp);
                break;
            }
            case TimerK: {
                this.terminate();
                break;
            }
            default: {
                _log.log(Level.FINE, "IllegalTimer in ICT = " + (Object)((Object)tt));
            }
        }
    }

    protected synchronized void terminate() {
        super.terminate();
        if (this._timerE != null) {
            this._timerE.cancel();
            this._timerE = null;
        }
        if (this._timerF != null) {
            this._timerF.cancel();
            this._timerF = null;
        }
        if (this._timerK != null) {
            this._timerK.cancel();
            this._timerK = null;
        }
        this._state = TransactionState.TERMINATED;
    }

    private void toCompleted(SipServletResponseImpl resp) {
        if (this._timerF != null) {
            this._timerF.cancel();
            this._timerF = null;
        }
        if (!this._reliableTransport) {
            if (PerformanceMBeanListener.isEnabled()) {
                this.updateLastAccessTimestamp();
            }
            if (this._timerE != null) {
                this._timerE.cancel();
                this._timerE = null;
            }
            this._state = TransactionState.COMPLETED;
            this._timerK = _timerService.createTimer(this, T4, false, (Serializable)((Object)TransactionTimer.TimerK));
        } else {
            this._state = TransactionState.TERMINATED;
            super.terminate();
        }
    }
}

