/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.transaction;

import com.ericsson.ssa.container.startup.PerformanceMBeanListener;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.timer.TimerServiceImpl;
import com.ericsson.ssa.sip.transaction.TransactionManager;
import com.ericsson.ssa.sip.transaction.TransactionState;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.TimerListener;

public abstract class Transaction
implements TimerListener {
    public static final String MAGIC_COOKIE = "z9hG4bK";
    protected static TimerServiceImpl _timerService;
    private static final String _udpTransport = "udp";
    protected static final Logger _log;
    protected static TransactionManager _transactionManager;
    static long T1;
    static long T2;
    static long T4;
    protected TransactionState _state;
    protected String _transactionId;
    protected SipServletRequestImpl _request;
    protected boolean _reliableTransport = true;
    private long _transactionStartedTimestamp = 0L;
    private long _lastAccessTimestamp = 0L;

    public Transaction(String id, TransactionState state, SipServletRequestImpl req) {
        if (PerformanceMBeanListener.isEnabled()) {
            this._transactionStartedTimestamp = System.currentTimeMillis();
        }
        this._transactionId = id;
        this._state = state;
        this._request = req;
        if (req.getTransport().equalsIgnoreCase(_udpTransport)) {
            this._reliableTransport = false;
        }
        _timerService = TimerServiceImpl.getInstance();
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "Created Transaction = " + this.getClass().getName());
        }
    }

    public static String generateBranch() {
        StringBuilder sb = new StringBuilder(MAGIC_COOKIE).append(UUID.randomUUID().toString());
        return sb.toString();
    }

    public String getTransactionId() {
        return this._transactionId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransactionID = ").append(this._transactionId);
        return sb.toString();
    }

    protected void updateLastAccessTimestamp() {
        this._lastAccessTimestamp = System.currentTimeMillis();
    }

    protected synchronized void terminate() {
        if (PerformanceMBeanListener.isEnabled()) {
            if (this._lastAccessTimestamp == 0L) {
                this._lastAccessTimestamp = System.currentTimeMillis();
            }
            long transactionTime = this._lastAccessTimestamp - this._transactionStartedTimestamp;
            _transactionManager.recordTransactionTime(transactionTime);
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "TransactionTime:" + transactionTime);
            }
        }
        this._request = null;
    }

    static {
        _log = Logger.getLogger("SipContainer");
        _transactionManager = TransactionManager.getInstance();
        T1 = _transactionManager.getTimerT1();
        T2 = _transactionManager.getTimerT2();
        T4 = _transactionManager.getTimerT4();
    }
}

