/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.util.os.linux;

import com.ericsson.util.os.OSUtilSunspecific;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OSUtilLinux
extends OSUtilSunspecific {
    private static final Logger _log = Logger.getLogger("SipContainer");
    private Double _lastIdle = 0.0;
    private Double _lastTime = 0.0;
    private FileInputStream _file = null;
    private long _lastVisit = 0L;
    private int _savedBusy = 0;

    public String getInfo() {
        return this.getClass().getName() + ": linux operating system extension";
    }

    public int cpuBusy() {
        long now = System.currentTimeMillis();
        if (now - this._lastVisit > 1000L) {
            this._lastVisit = now;
            try {
                byte[] buf = new byte[1024];
                if (this._file == null) {
                    this._file = new FileInputStream("/proc/uptime");
                }
                if (this._file.markSupported()) {
                    this._file.reset();
                    this._file.read(buf);
                } else {
                    this._file.read(buf);
                    this._file.close();
                    this._file = null;
                }
                String[] b = new String(buf).split("[ ]+");
                Double new_time = Double.parseDouble(b[0]);
                Double new_idle = Double.parseDouble(b[1]);
                if (this._lastTime == 0.0) {
                    this._lastTime = new_time;
                    this._lastIdle = new_idle;
                    this._savedBusy = 0;
                    return this._savedBusy;
                }
                Double busyPercent = 100.0 - 100.0 * (new_idle - this._lastIdle) / (new_time - this._lastTime);
                if (busyPercent < 0.0) {
                    busyPercent = 0.0;
                }
                if (busyPercent > 100.0) {
                    busyPercent = 100.0;
                }
                this._lastTime = new_time;
                this._lastIdle = new_idle;
                this._savedBusy = busyPercent.intValue();
                return this._savedBusy;
            }
            catch (IOException e) {
                _log.log(Level.WARNING, "Error while reading cpu information.", e);
                return this._savedBusy;
            }
        }
        return this._savedBusy;
    }
}

