/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.annotations;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.annotation.SipApplicationKey;

public class SipAnnotationDescriptor {
    Method anno_SipApplicationKey = null;
    private ClassLoader loader = null;
    private String classRepository = null;
    private ArrayList<String> repositoryClasses = new ArrayList();

    public SipAnnotationDescriptor(ClassLoader cl, String repository) {
        this.loader = cl;
        this.classRepository = repository;
    }

    public void processAnnotations() {
        this.scanDirectory(new File(this.classRepository), null);
        for (String element : this.repositoryClasses) {
            try {
                Class<?> clazz = this.loader.loadClass(element);
                Method[] method = clazz.getMethods();
                for (int i = 0; i < method.length; ++i) {
                    Annotation[] methodAnnotation = method[i].getDeclaredAnnotations();
                    for (int j = 0; j < methodAnnotation.length; ++j) {
                        Class<? extends Annotation> annotationType = methodAnnotation[j].annotationType();
                        if (!annotationType.getName().equals(SipApplicationKey.class.getName())) continue;
                        this.anno_SipApplicationKey = method[i];
                    }
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void scanDirectory(File file, String pckage) {
        if (pckage == null) {
            pckage = "";
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File aFile = files[i];
                if (aFile.isDirectory()) {
                    this.scanDirectory(aFile, pckage + aFile.getName() + ".");
                    continue;
                }
                String fileName = aFile.getName();
                if (!fileName.endsWith(".class")) continue;
                fileName = fileName.substring(0, fileName.indexOf(".class"));
                String deployedClass = pckage + fileName;
                this.repositoryClasses.add(deployedClass);
            }
        } else if (file.isFile()) {
            String deployedClass = pckage + file.getName();
            this.repositoryClasses.add(deployedClass);
        }
    }

    public boolean hasSipApplicationKey() {
        return this.anno_SipApplicationKey != null;
    }

    public Method getSipApplicationKeyMethod() {
        return this.anno_SipApplicationKey;
    }

    public String invokeSipApplicationKey(SipServletRequest request) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String result = "";
        result = (String)this.anno_SipApplicationKey.invoke(null, request);
        return result;
    }
}

