/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.config.ConvergedContext;
import com.ericsson.ssa.config.ConvergedSessionManagerConfigurationHelper;
import com.ericsson.ssa.config.SipFactoryFacade;
import com.ericsson.ssa.config.SipPersistenceStrategyBuilder;
import com.ericsson.ssa.config.SipPersistenceStrategyBuilderFactory;
import com.ericsson.ssa.config.SipRequestDispatcher;
import com.ericsson.ssa.container.sim.ServletDispatcher;
import com.ericsson.ssa.container.sim.SipServletWrapper;
import com.ericsson.ssa.dd.SipApplication;
import com.ericsson.ssa.dd.SipApplicationListeners;
import com.ericsson.ssa.fm.FmEventSender;
import com.ericsson.ssa.sip.ConvergedHttpSessionFacade;
import com.ericsson.ssa.sip.PersistentSipSessionManagerBase;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipApplicationSessionStore;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipSessionManager;
import com.ericsson.ssa.sip.SipSessionManagerBase;
import com.ericsson.ssa.sip.SipSessionsUtilImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.web.PersistenceStrategyBuilder;
import com.sun.enterprise.web.PersistenceStrategyBuilderFactory;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.session.PersistenceType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StandardSessionFacade;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteResponse;

public class ConvergedContextImpl
extends WebModule
implements ConvergedContext {
    private static Logger logger = Logger.getLogger("SipContainer");
    private SipApplication sipApplication;
    private ServletDispatcher dispatcher;
    private SipFactoryFacade sipFactory;
    private SipApplicationListeners sipApplicationListeners;
    private SipSessionManager sipSessionManager;

    public ConvergedContextImpl(WebContainer wc) {
        super(wc);
    }

    public void loadOnStartup(Container[] children) {
        this.loadOnStartupHttp(children);
        this.loadOnStartupSip();
    }

    private void loadOnStartupSip() {
        if (this.dispatcher != null) {
            logger.log(Level.FINE, "Loading SIP servlets on startup");
            this.dispatcher.loadServletsMarkedOnStartup();
        }
    }

    private void loadOnStartupHttp(Container[] children) {
        TreeMap<Integer, ArrayList<Wrapper>> map = new TreeMap<Integer, ArrayList<Wrapper>>();
        for (int i = 0; i < children.length; ++i) {
            Integer key;
            ArrayList<Wrapper> list;
            Wrapper wrapper = (Wrapper)children[i];
            int loadOnStartup = wrapper.getLoadOnStartup();
            if (loadOnStartup < 0) continue;
            if (loadOnStartup == 0) {
                loadOnStartup = Integer.MAX_VALUE;
            }
            if ((list = (ArrayList<Wrapper>)map.get(key = new Integer(loadOnStartup))) == null) {
                list = new ArrayList<Wrapper>();
                map.put(key, list);
            }
            list.add(wrapper);
        }
        for (Integer key : map.keySet()) {
            ArrayList list = (ArrayList)map.get(key);
            for (Wrapper wrapper : list) {
                try {
                    wrapper.load();
                }
                catch (ServletException e) {
                    logger.log(Level.SEVERE, String.format("Servlet '%1$s' threw an exception during initialization.", wrapper.getName()), StandardWrapper.getRootCause((ServletException)e));
                    FmEventSender.servletInitializationFailed(this.getName(), wrapper.getName(), e.getMessage());
                }
            }
        }
    }

    public void addAttributeToServletContext(String attributeName, Object attributeValue) {
        if (attributeName != null && attributeValue != null) {
            ServletContext servletContext = this.getServletContext();
            servletContext.setAttribute(attributeName, attributeValue);
        }
    }

    public ServletDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(ServletDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public SipApplication getSipApplication() {
        return this.sipApplication;
    }

    public void setSipApplication(SipApplication sipApplication) {
        this.sipApplication = sipApplication;
    }

    public SipApplicationListeners getSipApplicationListeners() {
        return this.sipApplicationListeners;
    }

    public void setSipApplicationListeners(SipApplicationListeners sipApplicationListeners) {
        this.sipApplicationListeners = sipApplicationListeners;
    }

    public SipFactoryFacade getSipFactory() {
        return this.sipFactory;
    }

    public void setSipFactory(SipFactoryFacade sipFactory) {
        this.sipFactory = sipFactory;
    }

    private String getBasePath() {
        ConvergedContextImpl container;
        String docBase = null;
        for (container = this; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        File file = new File(this.getDocBase());
        if (!file.isAbsolute()) {
            if (container == null) {
                docBase = new File(this.engineBase(), this.getDocBase()).getPath();
            } else {
                String appBase = ((Host)container).getAppBase();
                file = new File(appBase);
                if (!file.isAbsolute()) {
                    file = new File(this.engineBase(), appBase);
                }
                docBase = new File(file, this.getDocBase()).getPath();
            }
        } else {
            docBase = file.getPath();
        }
        return docBase;
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ConvergedApplicationContext(this.getBasePath(), (StandardContext)this);
            if (this.getAltDDName() != null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", (Object)this.getAltDDName());
            }
        }
        return ((ConvergedApplicationContext)this.context).getConvergedFacade();
    }

    public StandardSessionFacade createSessionFacade(StandardSession session) {
        return new ConvergedHttpSessionFacade(session, this.sipSessionManager);
    }

    protected void managerStart() throws LifecycleException {
        super.managerStart();
        if (this.sipSessionManager != null && this.sipSessionManager instanceof Lifecycle) {
            ((Lifecycle)this.sipSessionManager).start();
        }
    }

    protected void managerStop() throws LifecycleException {
        super.managerStop();
        if (this.sipSessionManager != null && this.sipSessionManager instanceof Lifecycle) {
            ((Lifecycle)this.sipSessionManager).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipSessionManager getSipSessionManager() {
        try {
            this.readLock.lock();
            if (this.sipSessionManager != null) {
                SipSessionManager sipSessionManager = this.sipSessionManager;
                return sipSessionManager;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSipSessionManager(SipSessionManager sipSessionManager) {
        SipSessionManager oldSipSessionManager;
        block11: {
            try {
                this.writeLock.lock();
                oldSipSessionManager = this.sipSessionManager;
                if (oldSipSessionManager == sipSessionManager) {
                    return;
                }
                this.sipSessionManager = sipSessionManager;
                if (this.started && oldSipSessionManager != null && oldSipSessionManager instanceof Lifecycle) {
                    try {
                        ((Lifecycle)oldSipSessionManager).stop();
                    }
                    catch (LifecycleException e) {
                        logger.log(Level.SEVERE, "ContainerBase.setSipSessionManager: stop: ", e);
                    }
                }
                if (sipSessionManager == null) break block11;
                sipSessionManager.setContext(this);
                if (this.started && sipSessionManager instanceof Lifecycle) {
                    try {
                        ((Lifecycle)sipSessionManager).start();
                    }
                    catch (LifecycleException e) {
                        logger.log(Level.SEVERE, "ContainerBase.setSipSessionManager: start: ", e);
                    }
                }
                SipSessionsUtilImpl util = new SipSessionsUtilImpl((SipSessionManagerBase)sipSessionManager);
                this.getServletContext().setAttribute("javax.servlet.sip.SipSessionsUtil", (Object)util);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        this.support.firePropertyChange("sipSessionManager", oldSipSessionManager, this.sipSessionManager);
    }

    public void addResponseCookie(CoyoteRequest request, CoyoteResponse response) {
        if (!this.getCookies()) {
            return;
        }
        String value = request.getHeader("proxy-beroute");
        if (value != null) {
            Cookie cookie = new Cookie("BERoute", value);
            request.configureSessionCookie(cookie);
            response.addCookie(cookie);
        } else {
            value = request.getHeader("proxy-bekey");
            if (value != null) {
                Cookie cookie = new Cookie("BEKey", value);
                request.configureSessionCookie(cookie);
                response.addCookie(cookie);
            }
        }
    }

    public void encodeRequestHeader(CoyoteRequest request, StringBuffer sb) {
        String value = request.getHeader("proxy-beroute");
        if (value != null) {
            sb.append(";BERoute=");
            sb.append(value);
        } else {
            value = request.getHeader("proxy-bekey");
            if (value != null) {
                sb.append(";BEKey=");
                sb.append(value);
            }
        }
    }

    public void saveSipApplicationSession(Session s) throws IOException {
        SipApplicationSessionImpl sas;
        ConvergedHttpSessionFacade facade;
        if (!(this.sipSessionManager instanceof PersistentSipSessionManagerBase)) {
            return;
        }
        PersistentSipSessionManagerBase ps = (PersistentSipSessionManagerBase)this.sipSessionManager;
        StandardSession session = (StandardSession)s;
        String sasId = session.getSipApplicationSessionId();
        if (sasId != null && (facade = (ConvergedHttpSessionFacade)session.getSession()) != null && (sas = (SipApplicationSessionImpl)facade.getApplicationSession()) != null) {
            SipApplicationSessionStore store = ps.getSipApplicationSessionStore();
            store.save(sas);
        }
    }

    protected void configureSessionManager(SessionManager smBean, WebBundleDescriptor wbd, WebModuleConfig wmInfo) {
        ConvergedSessionManagerConfigurationHelper configHelper = new ConvergedSessionManagerConfigurationHelper(this, smBean, wbd, wmInfo);
        PersistenceType httpType = configHelper.getPersistenceType();
        String httpFrequency = configHelper.getPersistenceFrequency();
        String httpScope = configHelper.getPersistenceScope();
        PersistenceStrategyBuilderFactory httpFactory = new PersistenceStrategyBuilderFactory();
        PersistenceStrategyBuilder httpBuilder = httpFactory.createPersistenceStrategyBuilder(httpType.getType(), httpFrequency, httpScope, (Context)this);
        httpBuilder.setLogger(logger);
        httpBuilder.initializePersistenceStrategy((Context)this, smBean);
        PersistenceType sipType = configHelper.getSipPersistenceType();
        String sipFrequency = configHelper.getSipPersistenceFrequency();
        String sipScope = configHelper.getSipPersistenceScope();
        SipPersistenceStrategyBuilderFactory sipFactory = new SipPersistenceStrategyBuilderFactory();
        SipPersistenceStrategyBuilder sipBuilder = sipFactory.createPersistenceStrategyBuilder(sipType, sipFrequency, sipScope, this);
        sipBuilder.setLogger(logger);
        sipBuilder.initializePersistenceStrategy(this, configHelper.getSipContainerAvailability());
    }

    public class ConvergedApplicationContext
    extends ApplicationContext {
        public ConvergedApplicationContext(String basePath, StandardContext context) {
            super(basePath, context);
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            if (name == null) {
                return null;
            }
            Container child = ConvergedContextImpl.this.findChild(name);
            if (child instanceof SipServletWrapper) {
                return new SipRequestDispatcher(name, SipFactoryImpl.getInstance().getServiceHandler());
            }
            return super.getNamedDispatcher(name);
        }

        public ServletContext getConvergedFacade() {
            return this.getFacade();
        }
    }
}

