/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.config;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ExtensionModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.SipContainerAvailability;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.session.PersistenceType;

public class ConvergedServerConfigLookup
extends ServerConfigLookup {
    public PersistenceType getSipPersistenceTypeFromConfig() {
        SipContainerAvailability sca = this.getSipContainerAvailability();
        if (sca == null) {
            return null;
        }
        String persistenceTypeString = sca.getPersistenceType();
        PersistenceType persistenceType = null;
        if (persistenceTypeString != null) {
            persistenceType = PersistenceType.parseType((String)persistenceTypeString);
        }
        return persistenceType;
    }

    public String getSipPersistenceFrequencyFromConfig() {
        SipContainerAvailability sca = this.getSipContainerAvailability();
        if (sca == null) {
            return null;
        }
        return sca.getPersistenceFrequency();
    }

    public String getSipPersistenceScopeFromConfig() {
        SipContainerAvailability sca = this.getSipContainerAvailability();
        if (sca == null) {
            return null;
        }
        return sca.getPersistenceScope();
    }

    public boolean getSipContainerAvailabilityEnabledFromConfig() {
        boolean globalAvailabilityEnabled = this.getAvailabilityEnabledFromConfig();
        SipContainerAvailability sca = this.getSipContainerAvailability();
        if (sca == null) {
            return globalAvailabilityEnabled;
        }
        String value = sca.getAvailabilityEnabled();
        if (value == null) {
            return globalAvailabilityEnabled;
        }
        return ConfigBean.toBoolean((String)value);
    }

    public boolean getSipContainerAvailabilityEnabledFromConfig(boolean inheritedValue) {
        SipContainerAvailability sca = this.getSipContainerAvailability();
        if (sca == null) {
            return inheritedValue;
        }
        String value = sca.getAvailabilityEnabled();
        if (value == null) {
            return inheritedValue;
        }
        return ConfigBean.toBoolean((String)value);
    }

    public SipContainerAvailability getSipContainerAvailability() {
        AvailabilityService availabilityServiceBean = this.getAvailabilityService();
        if (availabilityServiceBean == null) {
            return null;
        }
        return availabilityServiceBean.getSipContainerAvailability();
    }

    public boolean calculateSipAvailabilityEnabledFromConfig(WebModule ctx) {
        boolean globalAvailability = this.getAvailabilityEnabledFromConfig();
        boolean sipContainerAvailability = this.getSipContainerAvailabilityEnabledFromConfig(globalAvailability);
        boolean sipModuleAvailability = false;
        J2eeApplication j2eeApp = ctx.getApplicationBean();
        if (j2eeApp == null) {
            ExtensionModule bean = (ExtensionModule)ctx.getBean();
            sipModuleAvailability = bean.isAvailabilityEnabled();
        } else {
            sipModuleAvailability = j2eeApp.isAvailabilityEnabled();
        }
        return globalAvailability && sipContainerAvailability && sipModuleAvailability;
    }

    private ElementProperty[] getSipContainerAvailabilityProperties() {
        SipContainerAvailability sca = this.getSipContainerAvailability();
        if (sca == null) {
            return new ElementProperty[0];
        }
        return sca.getElementProperty();
    }
}

