/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.config.ConvergedServerConfigLookup;
import com.ericsson.ssa.dd.ConvergedDescriptor;
import com.ericsson.ssa.dd.SipApplication;
import com.sun.enterprise.config.serverbeans.SipContainerAvailability;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.web.SessionManagerConfigurationHelper;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.session.PersistenceType;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConvergedSessionManagerConfigurationHelper
extends SessionManagerConfigurationHelper {
    private static final Logger SIP_LOGGER = Logger.getLogger("SipContainer");
    private PersistenceType sipPersistenceType = PersistenceType.MEMORY;
    private String sipPersistenceFrequency = null;
    private String sipPersistenceScope = null;
    private ConvergedServerConfigLookup lookup = new ConvergedServerConfigLookup();

    public ConvergedSessionManagerConfigurationHelper(WebModule ctx, SessionManager smBean, WebBundleDescriptor wbd, WebModuleConfig wmInfo) {
        super(ctx, smBean, wbd, wmInfo);
    }

    public void initializeConfiguration() {
        PersistenceType domainPersistenceType;
        ConvergedDescriptor cd;
        SipApplication sipApp;
        super.initializeConfiguration();
        boolean isSipAppDistributable = false;
        if (this._wbd instanceof ConvergedDescriptor && (sipApp = (cd = (ConvergedDescriptor)this._wbd).getSipApplication()) != null) {
            isSipAppDistributable = sipApp.isDistributable();
        }
        PersistenceType persistenceType = PersistenceType.MEMORY;
        String persistenceFrequency = null;
        String persistenceScope = null;
        boolean isAvailabilityEnabled = this.lookup.calculateSipAvailabilityEnabledFromConfig(this._ctx);
        if (isAvailabilityEnabled) {
            persistenceType = PersistenceType.REPLICATED;
            persistenceFrequency = "sip-transaction";
            persistenceScope = "session";
        }
        if ((domainPersistenceType = this.lookup.getSipPersistenceTypeFromConfig()) != null) {
            persistenceType = domainPersistenceType;
            persistenceFrequency = this.lookup.getSipPersistenceFrequencyFromConfig();
            persistenceScope = this.lookup.getSipPersistenceScopeFromConfig();
        }
        String frequency = null;
        String scope = null;
        if (persistenceType != PersistenceType.MEMORY) {
            frequency = persistenceFrequency;
            scope = persistenceScope;
        }
        if (!isSipAppDistributable && persistenceType != PersistenceType.MEMORY) {
            String sipAppName = this.getApplicationId(this._ctx);
            if (isAvailabilityEnabled && !sipAppName.equals("__default-web-module") && !this.isSystemApp(sipAppName)) {
                Object[] params = new Object[]{sipAppName, persistenceType.getType(), frequency, scope};
                _logger.log(Level.WARNING, "webcontainer.invalidSessionManagerConfig2", params);
            }
            persistenceType = PersistenceType.MEMORY;
            frequency = null;
            scope = null;
        }
        this.sipPersistenceType = persistenceType;
        this.sipPersistenceFrequency = frequency;
        this.sipPersistenceScope = scope;
        if (this.sipPersistenceType == PersistenceType.REPLICATED && this._persistence != PersistenceType.REPLICATED || this.sipPersistenceType != PersistenceType.REPLICATED && this._persistence == PersistenceType.REPLICATED) {
            SIP_LOGGER.log(Level.WARNING, "Inconsistent SIP and HTTP persistence configuration for converged app " + this.getApplicationId(this._ctx) + ", falling back to memory-only");
            this.sipPersistenceType = PersistenceType.MEMORY;
            this.sipPersistenceFrequency = null;
            this.sipPersistenceScope = null;
            this._persistence = PersistenceType.MEMORY;
            this._persistenceFrequency = null;
            this._persistenceScope = null;
        }
    }

    public PersistenceType getSipPersistenceType() {
        this.checkInitialization();
        return this.sipPersistenceType;
    }

    public String getSipPersistenceFrequency() {
        this.checkInitialization();
        return this.sipPersistenceFrequency;
    }

    public String getSipPersistenceScope() {
        this.checkInitialization();
        return this.sipPersistenceScope;
    }

    public SipContainerAvailability getSipContainerAvailability() {
        return this.lookup.getSipContainerAvailability();
    }
}

