/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.config;

import com.sun.org.apache.commons.digester.Rule;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.xml.sax.Attributes;

final class CreateLoaderRule
extends Rule {
    private static Logger logger = Logger.getLogger("SipContainer");
    private String attributeName;
    private String loaderClass;

    public CreateLoaderRule(String loaderClass, String attributeName) {
        this.loaderClass = loaderClass;
        this.attributeName = attributeName;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        String value;
        ClassLoader parentClassLoader = null;
        Object ojb = this.digester.peek();
        if (ojb instanceof Container) {
            parentClassLoader = ((Container)ojb).getParentClassLoader();
        }
        String className = this.loaderClass;
        if (this.attributeName != null && (value = attributes.getValue(this.attributeName)) != null) {
            className = value;
        }
        Class<?> clazz = Class.forName(className);
        Class[] types = new Class[]{ClassLoader.class};
        Object[] args = new Object[]{parentClassLoader};
        Constructor<?> constructor = clazz.getDeclaredConstructor(types);
        Loader loader = (Loader)constructor.newInstance(args);
        this.digester.push((Object)loader);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "new " + loader.getClass().getName());
        }
    }

    public void end(String namespace, String name) throws Exception {
        Loader loader = (Loader)this.digester.pop();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "pop " + loader.getClass().getName());
        }
    }
}

