/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.config.LayerHandler;
import com.ericsson.ssa.sip.Layer;
import com.sun.org.apache.commons.digester.Rule;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.util.IntrospectionUtils;
import org.xml.sax.Attributes;

public class LayerRule
extends Rule {
    private static final Logger m_Log = Logger.getLogger("SipContainer");
    private String m_classNameAttribute = "className";
    Layer layer = null;

    public void begin(String ns, String n, Attributes attributes) throws Exception {
        String className = attributes.getValue(this.m_classNameAttribute);
        if (className == null) {
            throw new Exception("Attribute " + this.m_classNameAttribute + " is missing");
        }
        try {
            Class<?> layerClass = Class.forName(className);
            HashMap<String, String> attribs = new HashMap<String, String>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getLocalName(i);
                if ("".equals(name)) {
                    name = attributes.getQName(i);
                }
                String parameter = attributes.getValue(i);
                if (name.equals("objectName")) {
                    this.registerComponent(null, parameter);
                    continue;
                }
                if (name.equals(this.m_classNameAttribute)) continue;
                if (name.equals("registerInFactory")) {
                    Class<?> singletonClass = Class.forName(parameter);
                    Class[] input = new Class[]{Class.class};
                    Object[] inObj = new Object[]{layerClass};
                    Method m = singletonClass.getMethod("initInstance", input);
                    if (m_Log.isLoggable(Level.FINE)) {
                        m_Log.log(Level.FINE, "about to invoke method 'initInstance' of class " + singletonClass);
                    }
                    m.invoke(singletonClass, inObj);
                }
                attribs.put(name, parameter);
            }
            Method method = layerClass.getMethod("getInstance", null);
            Object object = method.invoke((Object)null, (Object[])null);
            if (object != null && object instanceof Layer) {
                this.layer = (Layer)object;
                LayerHandler.getInstance().addLayer(this.layer);
                for (String name : attribs.keySet()) {
                    String parameter = (String)attribs.get(name);
                    this.setAttribute(name, parameter);
                }
            }
        }
        catch (Exception e) {
            m_Log.log(Level.SEVERE, "tried to invoke " + className + ".getInstance(), caught exception: " + e + ", underlying cause: " + e.getCause().getMessage());
            throw new Exception("Exception invoking getInstance for class " + className);
        }
    }

    public void registerComponent(Object bean, String objectName) {
    }

    public void setAttribute(String attribute, String value) {
        IntrospectionUtils.setProperty((Object)this.layer, (String)attribute, (String)value);
    }
}

