/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.config.ConvergedContext;
import com.ericsson.ssa.dd.SipApplication;
import com.ericsson.ssa.dd.SipApplicationListeners;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipSessionManager;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.jvnet.glassfish.comms.security.auth.impl.AuthInfoImpl;

public class SipFactoryFacade
implements SipFactory {
    private static Logger logger = Logger.getLogger("SipContainer");
    private String m_ApplicationName;
    private SipFactoryImpl m_ConcreteSipFactory;
    private SipApplicationListeners m_sipApplicationListeners;
    private SipApplication m_SipApplication;
    private SipSessionManager m_SipSessionManager;
    private Method sessionKey = null;

    public SipFactoryFacade(ConvergedContext ctxt, SipFactoryImpl sipfactory, SipApplicationListeners sipApplicationListeners, SipApplication sipApplication) {
        this.m_ApplicationName = ctxt.getName();
        this.m_SipSessionManager = ctxt.getSipSessionManager();
        this.m_ConcreteSipFactory = sipfactory;
        this.m_sipApplicationListeners = sipApplicationListeners;
        this.m_SipApplication = sipApplication;
    }

    public SipURI createSipURI(String user, String host) {
        return this.m_ConcreteSipFactory.createSipURI(user, host);
    }

    public URI createURI(String uri) throws ServletParseException {
        return this.m_ConcreteSipFactory.createURI(uri);
    }

    public Address createAddress(String address) throws ServletParseException {
        return this.m_ConcreteSipFactory.createAddress(address);
    }

    public Address createAddress(URI uri) {
        return this.m_ConcreteSipFactory.createAddress(uri);
    }

    public Address createAddress(URI uri, String string) {
        return this.m_ConcreteSipFactory.createAddress(uri, string);
    }

    public Parameterable createParameterable(String s) {
        return this.m_ConcreteSipFactory.createParameterable(s);
    }

    public SipServletRequest createRequest(SipApplicationSession appSession, String method, Address from, Address to) {
        SipServletRequestImpl request = this.m_ConcreteSipFactory.createRequest(appSession, method, from, to);
        this.postCreateRequest(request);
        return request;
    }

    public SipServletRequest createRequest(SipApplicationSession appSession, String method, URI from, URI to) {
        SipServletRequestImpl request = this.m_ConcreteSipFactory.createRequest(appSession, method, from, to);
        this.postCreateRequest(request);
        return request;
    }

    public SipServletRequest createRequest(SipApplicationSession appSession, String method, String from, String to) throws ServletParseException {
        SipServletRequestImpl request = this.m_ConcreteSipFactory.createRequest(appSession, method, from, to);
        this.postCreateRequest(request);
        return request;
    }

    public SipServletRequest createRequest(SipServletRequest origRequest, boolean sameCallId) {
        SipServletRequestImpl request = this.m_ConcreteSipFactory.createRequest(origRequest, sameCallId);
        this.postCreateRequest(request);
        return request;
    }

    public SipApplicationSessionImpl createApplicationSession() {
        SipApplicationSessionImpl as = this.m_SipSessionManager.createApplicationSession(this.m_sipApplicationListeners);
        return as;
    }

    public void initKeyMethod(Method m) {
        this.sessionKey = m;
    }

    public SipApplicationListeners getSipApplicationListeners() {
        return this.m_sipApplicationListeners;
    }

    public void setSipApplicationListeners(SipApplicationListeners applicationListeners) {
        this.m_sipApplicationListeners = applicationListeners;
    }

    private void postCreateRequest(SipServletRequestImpl request) {
        request.setRole(this.m_ApplicationName);
        if (request.getSessionImpl().getHandler() == null) {
            try {
                request.getSessionImpl().setHandler(this.m_SipApplication.getDefaultServlet());
            }
            catch (ServletException servletException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipApplicationSessionImpl createApplicationSession(SipServletRequestImpl request) {
        if (this.sessionKey != null) {
            SipApplicationSessionImpl ref;
            String key;
            block7: {
                key = null;
                try {
                    key = (String)this.sessionKey.invoke(null, request);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "SessionKey for application not working!", e);
                }
                finally {
                    if (key != null) break block7;
                    return this.createApplicationSession();
                }
            }
            if ((ref = this.m_SipSessionManager.findApplicationSession(key)) != null) {
                return ref;
            }
            SipApplicationSessionImpl sas = this.m_SipSessionManager.createApplicationSession(key, this.m_sipApplicationListeners);
            return sas;
        }
        return this.createApplicationSession();
    }

    public AuthInfo createAuthInfo() {
        return new AuthInfoImpl();
    }
}

