/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.config.ConvergedContext;
import com.ericsson.ssa.config.MemoryStrategyBuilder;
import com.ericsson.ssa.config.SipPersistenceStrategyBuilder;
import com.sun.enterprise.web.session.PersistenceType;

public class SipPersistenceStrategyBuilderFactory {
    private static String sipReplicationBuilderPath = null;

    SipPersistenceStrategyBuilder createPersistenceStrategyBuilder(PersistenceType type, String frequency, String scope, ConvergedContext ctxt) {
        SipPersistenceStrategyBuilder builder = new MemoryStrategyBuilder();
        if (type != PersistenceType.MEMORY) {
            String className = this.createBuilderClassNameFrom(type.getType(), frequency, scope);
            try {
                builder = (SipPersistenceStrategyBuilder)Class.forName(className).newInstance();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return builder;
    }

    private String createBuilderClassNameFrom(String type, String frequency, String scope) {
        StringBuilder sb = new StringBuilder();
        sb.append(sipReplicationBuilderPath + ".");
        sb.append(this.camelCase(type));
        if (frequency != null) {
            sb.append(this.camelCase(frequency));
        }
        if (scope != null) {
            sb.append(this.camelCase(scope));
        }
        sb.append("StrategyBuilder");
        return sb.toString();
    }

    private String camelCase(String s) {
        boolean toUpper = true;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char nextChar = s.charAt(i);
            if (toUpper) {
                nextChar = Character.toUpperCase(nextChar);
                toUpper = false;
            }
            if (Character.isLetter(nextChar)) {
                sb.append(nextChar);
                continue;
            }
            toUpper = true;
        }
        return sb.toString();
    }

    static {
        try {
            sipReplicationBuilderPath = Class.forName("org.jvnet.glassfish.comms.replication.initialization.ReplicatedSipTransactionModifiedSessionStrategyBuilder").getPackage().getName();
        }
        catch (ClassNotFoundException cnfe) {
            throw new ExceptionInInitializerError(cnfe);
        }
    }
}

