/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.sip.ServiceHandler;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

class SipRequestDispatcher
implements RequestDispatcher {
    private String servletName;
    private ServiceHandler serviceHandler;

    public SipRequestDispatcher(String servletName, ServiceHandler serviceHandler) {
        this.servletName = servletName;
        this.serviceHandler = serviceHandler;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        SipApplicationSessionImpl session = null;
        if (request != null) {
            if (request instanceof SipServletRequestImpl) {
                session = (SipApplicationSessionImpl)((SipServletRequestImpl)request).getApplicationSession();
            } else {
                throw new IllegalArgumentException("Only SIP requests are allowed.");
            }
        }
        if (response != null) {
            if (response instanceof SipServletResponseImpl) {
                if (session == null) {
                    session = (SipApplicationSessionImpl)((SipServletResponseImpl)response).getApplicationSession();
                }
            } else {
                throw new IllegalArgumentException("Only SIP responses are allowed.");
            }
        }
        if (session == null) {
            throw new IllegalArgumentException("A SIP request or a SIP response must be supplied.");
        }
        this.serviceHandler.getHandler(session.getName(), this.servletName).service(request, response);
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        throw new UnsupportedOperationException("This method have no meaning for SIP servlets");
    }
}

