/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.container.MessageProcessorFilter;
import com.ericsson.ssa.container.NetworkManager;
import com.ericsson.ssa.container.SipContainerThreadPool;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.LayerHelper;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.dns.TargetTuple;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultPipeline;
import com.sun.grizzly.DefaultProtocolChain;
import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SSLCallbackHandler;
import com.sun.grizzly.SSLConnectorHandler;
import com.sun.grizzly.SSLSelectorHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPConnectorHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.UDPConnectorHandler;
import com.sun.grizzly.UDPSelectorHandler;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.filter.SSLReadFilter;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.WorkerThread;
import com.sun.grizzly.util.net.SSLImplementation;
import com.sun.grizzly.util.net.ServerSocketFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;

public class GrizzlyNetworkManager
extends NetworkManager
implements Runnable {
    public static final String SIP_CERTS = "Sip.Certs";
    private static ConcurrentLinkedQueue<ByteBuffer> byteBuffersPool = new ConcurrentLinkedQueue();
    private final Logger logger = Logger.getLogger("SipContainer");
    private Controller tcpController = new Controller();
    private Controller udpController = new Controller();
    private Controller tlsController = new Controller();
    private Controller tcpClientController = new Controller();
    private Controller udpClientController = new Controller();
    private Controller tlsClientController = new Controller();
    private Pipeline<Callable> ericssonThreadPoolWrapper = null;
    private Pipeline<Callable> clientPipeline = null;
    private Layer nextLayer = null;
    private SSLContext sslContext;
    private Config _config = ConfigFactory.getConfig();
    private ConnectionManager connectionManager = null;
    private int threadPoolSize = 10;

    public GrizzlyNetworkManager() {
        this.initPipeline();
    }

    public synchronized void start() throws IOException {
        try {
            int keepAliveTimeoutInSeconds = 600;
            InetAddress inet = InetAddress.getByName(this._config.get("HOST"));
            Integer port = Integer.parseInt(this._config.get("SIP_PORT"));
            this.logger.info("Starting Grizzly SIP TCP Listener on port " + port);
            TCPSelectorHandler tcpSelector = this.createTcpEndpoint(new InetSocketAddress(inet, (int)port));
            this.tcpController.addSelectorHandler((SelectorHandler)tcpSelector);
            this.logger.info("Starting Grizzly SIP UDP Listener on port " + port);
            UDPSelectorHandler udpSelector = this.createUdpEndpoint(new InetSocketAddress(inet, (int)port));
            this.udpController.addSelectorHandler((SelectorHandler)udpSelector);
            this.logger.info("Starting Grizzly SIP TLS Listener on port " + (port + 1));
            SSLSelectorHandler tlsSelector = this.createTLSEndpoint(new InetSocketAddress(inet, port + 1));
            this.tlsController.addSelectorHandler((SelectorHandler)tlsSelector);
            DefaultSelectionKeyHandler keyHandler = new DefaultSelectionKeyHandler(){

                public void expire(Iterator<SelectionKey> keys) {
                }
            };
            keyHandler.setLogger(this.logger);
            tcpSelector.setSelectionKeyHandler((SelectionKeyHandler)keyHandler);
            udpSelector.setSelectionKeyHandler((SelectionKeyHandler)keyHandler);
            tlsSelector.setSelectionKeyHandler((SelectionKeyHandler)keyHandler);
            final DefaultProtocolChain protocolChain = new DefaultProtocolChain();
            protocolChain.setContinuousExecution(false);
            ReadFilter readFilter = new ReadFilter(){
                private int bufferSize = 131072;

                public boolean execute(Context ctx) throws IOException {
                    SelectableChannel channel = ctx.getSelectionKey().channel();
                    ctx.removeAttribute("succes_read");
                    if (!channel.isOpen()) {
                        ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                        return false;
                    }
                    WorkerThread workerThread = (WorkerThread)Thread.currentThread();
                    if (workerThread.getByteBuffer().capacity() != this.bufferSize) {
                        try {
                            this.bufferSize = ctx.getProtocol() == Controller.Protocol.TCP ? ((SocketChannel)channel).socket().getReceiveBufferSize() : ((DatagramChannel)channel).socket().getReceiveBufferSize();
                        }
                        catch (IOException ex) {
                            GrizzlyNetworkManager.this.logger.log(Level.WARNING, "Bad Socket State: ", ex);
                            this.bufferSize = 131072;
                        }
                        workerThread.setByteBuffer(ByteBuffer.allocate(this.bufferSize));
                    }
                    return super.execute(ctx);
                }
            };
            readFilter.setContinuousExecution(false);
            protocolChain.addFilter((ProtocolFilter)readFilter);
            protocolChain.addFilter((ProtocolFilter)new MessageProcessorFilter(this));
            ProtocolChainInstanceHandler instanceHandler = new ProtocolChainInstanceHandler(){

                public ProtocolChain poll() {
                    return protocolChain;
                }

                public boolean offer(ProtocolChain instance) {
                    return true;
                }
            };
            this.tcpController.setProtocolChainInstanceHandler(instanceHandler);
            this.tcpController.setPipeline(this.ericssonThreadPoolWrapper);
            this.udpController.setProtocolChainInstanceHandler(instanceHandler);
            this.udpController.setPipeline(this.ericssonThreadPoolWrapper);
            this.tlsController.setProtocolChainInstanceHandler(instanceHandler);
            this.tlsController.setPipeline(this.ericssonThreadPoolWrapper);
            this.tcpClientController.setProtocolChainInstanceHandler(instanceHandler);
            TCPSelectorHandler tcpClientSelectorHandler = new TCPSelectorHandler(true);
            tcpClientSelectorHandler.setSelectionKeyHandler((SelectionKeyHandler)keyHandler);
            this.tcpClientController.addSelectorHandler((SelectorHandler)tcpClientSelectorHandler);
            this.tcpClientController.setPipeline(this.clientPipeline);
            this.udpClientController.setProtocolChainInstanceHandler(instanceHandler);
            UDPSelectorHandler udpClientSelectorHandler = new UDPSelectorHandler(true);
            udpClientSelectorHandler.setSelectionKeyHandler((SelectionKeyHandler)keyHandler);
            this.udpClientController.addSelectorHandler((SelectorHandler)udpClientSelectorHandler);
            this.udpClientController.setPipeline(this.clientPipeline);
            ServerSocketFactory serverSF = null;
            try {
                SSLImplementation sslHelper = SSLImplementation.getInstance();
                serverSF = sslHelper.getServerSocketFactory();
                serverSF.setAttribute("keystoreType", (Object)"JKS");
                serverSF.setAttribute("keystore", (Object)System.getProperty("javax.net.ssl.keyStore"));
                serverSF.setAttribute("truststoreType", (Object)"JKS");
                serverSF.setAttribute("truststore", (Object)System.getProperty("javax.net.ssl.trustStore"));
                String keyAlias = System.getProperty("sip.network.tls.keyAlias", "s1as");
                serverSF.setAttribute("keyAlias", (Object)keyAlias);
                serverSF.init();
            }
            catch (ClassNotFoundException t) {
                throw new RuntimeException(t);
            }
            this.sslContext = serverSF.getSSLContext();
            SSLReadFilter sslReadFilter = new SSLReadFilter(){

                public boolean execute(Context ctx) throws IOException {
                    SelectableChannel channel = ctx.getSelectionKey().channel();
                    ctx.removeAttribute("succes_read");
                    if (!channel.isOpen()) {
                        ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                        return false;
                    }
                    boolean continueExecution = super.execute(ctx);
                    if (continueExecution && this.isNeedClientAuth()) {
                        Object[] x509Cert = 4.doPeerCertificateChain((SelectionKey)ctx.getSelectionKey(), (boolean)this.isNeedClientAuth());
                        ctx.setAttribute(GrizzlyNetworkManager.SIP_CERTS, (Object)x509Cert);
                    }
                    return continueExecution;
                }
            };
            sslReadFilter.setSSLContext(this.sslContext);
            Boolean clientAuth = new Boolean(System.getProperty("sip.network.tls.clientAuth", Boolean.FALSE.toString()));
            sslReadFilter.setNeedClientAuth(clientAuth.booleanValue());
            DefaultProtocolChain tlsProtocolChain = new DefaultProtocolChain();
            tlsProtocolChain.addFilter((ProtocolFilter)sslReadFilter);
            tlsProtocolChain.addFilter((ProtocolFilter)new MessageProcessorFilter(this));
            ProtocolChainInstanceHandler tlsProtocolChainHandler = new ProtocolChainInstanceHandler((ProtocolChain)tlsProtocolChain){
                final /* synthetic */ ProtocolChain val$tlsProtocolChain;
                {
                    this.val$tlsProtocolChain = protocolChain;
                }

                public ProtocolChain poll() {
                    return this.val$tlsProtocolChain;
                }

                public boolean offer(ProtocolChain instance) {
                    return true;
                }
            };
            tlsSelector.setProtocolChainInstanceHandler(tlsProtocolChainHandler);
            this.tlsClientController.setProtocolChainInstanceHandler(tlsProtocolChainHandler);
            SSLSelectorHandler tlsClientSelectorHandler = new SSLSelectorHandler(true);
            tlsClientSelectorHandler.setSelectionKeyHandler((SelectionKeyHandler)keyHandler);
            this.tlsClientController.addSelectorHandler((SelectorHandler)tlsClientSelectorHandler);
            this.tlsClientController.setPipeline(this.clientPipeline);
            this.connectionManager = new ConnectionManager();
            this.ericssonThreadPoolWrapper.initPipeline();
            this.ericssonThreadPoolWrapper.startPipeline();
            this.clientPipeline.initPipeline();
            this.clientPipeline.startPipeline();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Failed to start Grizzly", e);
            throw e;
        }
    }

    public synchronized void stop() throws IOException {
        this.tcpController.stop();
        this.udpController.stop();
        this.tlsController.stop();
        this.tcpClientController.stop();
        this.udpClientController.stop();
        this.tlsClientController.stop();
    }

    void initPipeline() {
        Integer port = Integer.parseInt(this._config.get("SIP_PORT"));
        this.ericssonThreadPoolWrapper = new DefaultPipeline(this.threadPoolSize, this.threadPoolSize, "SipContainer", port.intValue());
        this.clientPipeline = new DefaultPipeline(this.threadPoolSize, this.threadPoolSize, "SipContainer-Client", port.intValue());
        ((DefaultPipeline)this.ericssonThreadPoolWrapper).setByteBufferType(ByteBufferFactory.ByteBufferType.HEAP);
        ((DefaultPipeline)this.ericssonThreadPoolWrapper).setQueueSizeInBytes(-1);
        this.clientPipeline.setQueueSizeInBytes(-1);
        SipContainerThreadPool tp = SipContainerThreadPool.getInstance();
        tp.initialize(this.ericssonThreadPoolWrapper);
    }

    public void next(SipServletRequestImpl req) {
        LayerHelper.next(req, (Layer)this, this.nextLayer);
    }

    public void next(SipServletResponseImpl resp) {
        LayerHelper.next(resp, (Layer)this, this.nextLayer);
    }

    public void registerNext(Layer layer) {
        this.nextLayer = layer;
    }

    public void dispatch(SipServletRequestImpl req) {
        try {
            this.connectionManager.send(req);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Failed to send response : " + req.toDebugString(), e);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Done sending req : " + req.toDebugString());
        }
    }

    public void dispatch(SipServletResponseImpl resp) {
        try {
            this.connectionManager.send(resp);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Failed to send response : " + resp.toDebugString(), e);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Done sending resp : " + resp.toDebugString());
        }
    }

    TCPSelectorHandler createTcpEndpoint(InetSocketAddress addr) {
        int keepAliveTimeoutInSeconds = 600;
        int linger = -1;
        TCPSelectorHandler selectorHandler = new TCPSelectorHandler();
        selectorHandler.setPort(addr.getPort());
        selectorHandler.setInet(addr.getAddress());
        selectorHandler.setLinger(linger);
        selectorHandler.setLogger(this.logger);
        selectorHandler.setReuseAddress(true);
        selectorHandler.setSocketTimeout(keepAliveTimeoutInSeconds * 1000);
        return selectorHandler;
    }

    SSLSelectorHandler createTLSEndpoint(InetSocketAddress addr) {
        int keepAliveTimeoutInSeconds = 600;
        int linger = -1;
        SSLSelectorHandler selectorHandler = new SSLSelectorHandler();
        selectorHandler.setPort(addr.getPort());
        selectorHandler.setInet(addr.getAddress());
        selectorHandler.setLinger(linger);
        selectorHandler.setLogger(this.logger);
        selectorHandler.setReuseAddress(true);
        selectorHandler.setSocketTimeout(keepAliveTimeoutInSeconds * 1000);
        return selectorHandler;
    }

    UDPSelectorHandler createUdpEndpoint(InetSocketAddress addr) {
        int keepAliveTimeoutInSeconds = 600;
        int linger = -1;
        UDPSelectorHandler selectorHandler = new UDPSelectorHandler();
        selectorHandler.setPort(addr.getPort());
        selectorHandler.setInet(addr.getAddress());
        selectorHandler.setLogger(this.logger);
        selectorHandler.setReuseAddress(true);
        return selectorHandler;
    }

    public void run() {
        try {
            new Thread(){

                public void run() {
                    try {
                        GrizzlyNetworkManager.this.tcpClientController.start();
                    }
                    catch (IOException ex) {
                        GrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Exception, RUN ON GNM called!", ex);
                    }
                }
            }.start();
            new Thread(){

                public void run() {
                    try {
                        GrizzlyNetworkManager.this.udpClientController.start();
                    }
                    catch (IOException ex) {
                        GrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Exception, RUN ON GNM called!", ex);
                    }
                }
            }.start();
            new Thread(){

                public void run() {
                    try {
                        GrizzlyNetworkManager.this.udpController.start();
                    }
                    catch (IOException ex) {
                        GrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Exception, RUN ON GNM called!", ex);
                    }
                }
            }.start();
            new Thread(){

                public void run() {
                    try {
                        GrizzlyNetworkManager.this.tlsController.start();
                    }
                    catch (IOException ex) {
                        GrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Exception, RUN ON GNM called!", ex);
                    }
                }
            }.start();
            new Thread(){

                public void run() {
                    try {
                        GrizzlyNetworkManager.this.tlsClientController.start();
                    }
                    catch (IOException ex) {
                        GrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Exception, RUN ON GNM called!", ex);
                    }
                }
            }.start();
            this.tcpController.start();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Exception, RUN ON GNM called!", e);
        }
    }

    public Integer getThreadPoolSize() {
        return new Integer(this.threadPoolSize);
    }

    public void setThreadPoolSize(Integer threadPoolSize) {
        if (threadPoolSize > 0) {
            // empty if block
        }
    }

    class ConnectionManager {
        private static final int DEFAULT_BB_SIZE = 131072;
        private ConcurrentHashMap<TargetTuple, ConnectorHandler> streams = new ConcurrentHashMap();
        private int socketBufferSize = 131072;
        private ConcurrentHashMap<ConnectorHandler, ArrayList<ByteBuffer>> asyncWriteQueue = new ConcurrentHashMap();

        private void send(SipServletMessageImpl sipServletMessage) throws IOException {
            this.send(sipServletMessage, true, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void send(SipServletMessageImpl sipServletMessage, boolean useCache, ByteBuffer bb) throws IOException {
            boolean blocking;
            TargetTuple tt = sipServletMessage.getRemote();
            ConnectorHandler handler = null;
            if (useCache && (handler = this.streams.get(tt)) != null && handler.getUnderlyingChannel() != null && !handler.getUnderlyingChannel().isOpen()) {
                this.streams.remove(tt);
                handler = null;
            }
            int protocol = tt.getProtocol().ordinal();
            if (handler == null && protocol == 2) {
                handler = this.createHandlerTCP(tt);
            } else if (handler == null && protocol == 3) {
                handler = this.createHandlerTLS(tt);
            } else if (handler == null) {
                handler = this.createHandlerUDP(tt);
            }
            if (handler == null) {
                throw new ConnectException("Connection refused to: " + tt.getSocketAddress());
            }
            boolean isConnected = true;
            if (protocol == 2) {
                isConnected = ((TCPConnectorHandler)handler).isConnected();
            } else if (protocol == 1) {
                isConnected = ((UDPConnectorHandler)handler).isConnected();
            } else if (protocol == 3) {
                isConnected = ((SSLConnectorHandler)handler).isConnected();
            }
            boolean bl = blocking = protocol != 1;
            if (bb == null) {
                if (isConnected && this.socketBufferSize == 131072) {
                    try {
                        this.socketBufferSize = protocol == 1 ? ((DatagramChannel)handler.getUnderlyingChannel()).socket().getSendBufferSize() : ((SocketChannel)handler.getUnderlyingChannel()).socket().getSendBufferSize();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                bb = this.toBuffer(sipServletMessage, this.socketBufferSize);
            }
            boolean cacheBuffer = true;
            try {
                try {
                    if (isConnected) {
                        handler.write(bb, blocking);
                    } else {
                        cacheBuffer = false;
                        ArrayList<ByteBuffer> bbs = this.asyncWriteQueue.get(handler);
                        if (bbs == null) {
                            bbs = new ArrayList();
                        }
                        bbs.add(bb);
                        this.asyncWriteQueue.put(handler, bbs);
                    }
                }
                catch (IOException ex) {
                    try {
                        handler.close();
                    }
                    finally {
                        this.streams.remove(tt);
                    }
                    if (useCache) {
                        cacheBuffer = false;
                        this.send(sipServletMessage, false, bb);
                        if (bb != null && bb.capacity() != 131072 && cacheBuffer) {
                            bb.clear();
                            byteBuffersPool.offer(bb);
                        }
                        return;
                    }
                    throw ex;
                }
            }
            finally {
                if (bb != null && bb.capacity() != 131072 && cacheBuffer) {
                    bb.clear();
                    byteBuffersPool.offer(bb);
                }
            }
        }

        private final ByteBuffer toBuffer(SipServletMessageImpl sipServletMessage, int size) throws UnsupportedEncodingException {
            ByteBuffer bb = (ByteBuffer)byteBuffersPool.poll();
            if (bb == null) {
                bb = ByteBuffer.allocate(size);
            }
            sipServletMessage.toBuffer(bb);
            bb.flip();
            return bb;
        }

        private synchronized ConnectorHandler createHandlerTCP(final TargetTuple tt) throws IOException {
            final InetSocketAddress remote = tt.getSocketAddress();
            final TCPConnectorHandler connectorHandler = (TCPConnectorHandler)GrizzlyNetworkManager.this.tcpClientController.acquireConnectorHandler(Controller.Protocol.TCP);
            ConnectorHandler cached = this.streams.putIfAbsent(tt, (ConnectorHandler)connectorHandler);
            if (cached != null) {
                return cached;
            }
            CallbackHandler<Context> callbackHandler = new CallbackHandler<Context>(){

                public void onConnect(IOEvent<Context> ioEvent) {
                    block7: {
                        SelectionKey key = ((Context)ioEvent.attachment()).getSelectionKey();
                        try {
                            if (!((SocketChannel)key.channel()).isConnectionPending()) {
                                return;
                            }
                            connectorHandler.finishConnect(key);
                            GrizzlyNetworkManager.this.tcpClientController.registerKey(key, 1, Controller.Protocol.TCP);
                            ArrayList bbs = (ArrayList)ConnectionManager.this.asyncWriteQueue.remove(connectorHandler);
                            if (bbs == null) break block7;
                            try {
                                Iterator i = bbs.iterator();
                                while (i.hasNext()) {
                                    ByteBuffer bb = (ByteBuffer)i.next();
                                    connectorHandler.write(bb, true);
                                    i.remove();
                                    bb.clear();
                                    byteBuffersPool.offer(bb);
                                }
                            }
                            catch (IOException ex) {
                                GrizzlyNetworkManager.this.logger.log(Level.WARNING, "Write failed", ex);
                            }
                        }
                        catch (IOException ex) {
                            if (GrizzlyNetworkManager.this.logger.isLoggable(Level.FINE)) {
                                GrizzlyNetworkManager.this.logger.log(Level.FINE, "Connect failed" + remote, ex);
                            }
                            ConnectionManager.this.streams.remove(tt);
                            GrizzlyNetworkManager.this.tcpClientController.getSelectorHandler(Controller.Protocol.TCP).getSelectionKeyHandler().cancel(key);
                        }
                    }
                }

                public void onRead(IOEvent<Context> ioEvent) {
                    try {
                        Context ctx = (Context)ioEvent.attachment();
                        SelectionKey key = ctx.getSelectionKey();
                        if (!key.isValid()) {
                            ConnectionManager.this.streams.remove(tt);
                            return;
                        }
                        key.interestOps(key.interestOps() & 0xFFFFFFFE);
                        ctx.getProtocolChain().execute((Context)ioEvent.attachment());
                    }
                    catch (Throwable e) {
                        GrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Read failed: ", e);
                    }
                }

                public void onWrite(IOEvent<Context> ioEvent) {
                    throw new IllegalStateException("Should not end up here!");
                }
            };
            try {
                connectorHandler.connect((SocketAddress)remote, (CallbackHandler)callbackHandler);
                return connectorHandler;
            }
            catch (Throwable t) {
                if (GrizzlyNetworkManager.this.logger.isLoggable(Level.FINE)) {
                    GrizzlyNetworkManager.this.logger.log(Level.FINE, "Connect failed" + remote, t);
                }
                return null;
            }
        }

        private final void waitOnLatch(CountDownLatch latch, int timeout, TimeUnit timeUnit) throws InterruptedException {
            latch.await(timeout, timeUnit);
        }

        private synchronized ConnectorHandler createHandlerTLS(final TargetTuple tt) throws IOException {
            final InetSocketAddress remote = tt.getSocketAddress();
            final SSLConnectorHandler connectorHandler = new SSLConnectorHandler(GrizzlyNetworkManager.this.sslContext);
            ConnectorHandler cached = this.streams.putIfAbsent(tt, (ConnectorHandler)connectorHandler);
            if (cached != null) {
                return cached;
            }
            connectorHandler.setController(GrizzlyNetworkManager.this.tlsClientController);
            final ByteBuffer inBuffer = ByteBufferFactory.allocateView((boolean)false);
            final CountDownLatch handshakeDoneLatch = new CountDownLatch(1);
            SSLCallbackHandler<Context> sslCallbackHander = new SSLCallbackHandler<Context>(){

                public void onConnect(IOEvent<Context> ioEvent) {
                    block8: {
                        SelectionKey key = ((Context)ioEvent.attachment()).getSelectionKey();
                        try {
                            if (!((SocketChannel)key.channel()).isConnectionPending()) {
                                return;
                            }
                            connectorHandler.finishConnect(key);
                            key.attach(connectorHandler.getSSLEngine());
                            if (connectorHandler.handshake(inBuffer, true)) {
                                this.onHandshake(ioEvent);
                            }
                            connectorHandler.getSSLEngine().getSession().putValue("handshake", Boolean.TRUE);
                            GrizzlyNetworkManager.this.tlsClientController.registerKey(key, 1, Controller.Protocol.TLS);
                            ArrayList bbs = (ArrayList)ConnectionManager.this.asyncWriteQueue.remove(connectorHandler);
                            if (bbs == null) break block8;
                            try {
                                Iterator i = bbs.iterator();
                                while (i.hasNext()) {
                                    ByteBuffer bb = (ByteBuffer)i.next();
                                    connectorHandler.write(bb, true);
                                    i.remove();
                                    bb.clear();
                                    byteBuffersPool.offer(bb);
                                }
                            }
                            catch (IOException ex) {
                                GrizzlyNetworkManager.this.logger.log(Level.WARNING, "Write failed", ex);
                            }
                        }
                        catch (IOException ex) {
                            if (GrizzlyNetworkManager.this.logger.isLoggable(Level.FINE)) {
                                GrizzlyNetworkManager.this.logger.log(Level.FINE, "Connect failed" + remote, ex);
                            }
                            ConnectionManager.this.streams.remove(tt);
                            GrizzlyNetworkManager.this.tlsClientController.getSelectorHandler(Controller.Protocol.TLS).getSelectionKeyHandler().cancel(key);
                        }
                    }
                }

                public void onHandshake(IOEvent<Context> ioEvent) {
                    inBuffer.clear();
                    handshakeDoneLatch.countDown();
                }

                public void onRead(IOEvent<Context> ioEvent) {
                    try {
                        Context ctx = (Context)ioEvent.attachment();
                        SelectionKey key = ctx.getSelectionKey();
                        if (!key.isValid()) {
                            ConnectionManager.this.streams.remove(tt);
                            key.cancel();
                            return;
                        }
                        key.interestOps(key.interestOps() & 0xFFFFFFFE);
                        ctx.getProtocolChain().execute((Context)ioEvent.attachment());
                    }
                    catch (Throwable e) {
                        GrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Read failed: ", e);
                    }
                }

                public void onWrite(IOEvent<Context> ioEvent) {
                    throw new IllegalStateException("Should not end up here!");
                }
            };
            try {
                connectorHandler.connect((SocketAddress)remote, (SSLCallbackHandler)sslCallbackHander);
                this.waitOnLatch(handshakeDoneLatch, 10, TimeUnit.SECONDS);
                return connectorHandler;
            }
            catch (Throwable t) {
                if (GrizzlyNetworkManager.this.logger.isLoggable(Level.FINE)) {
                    GrizzlyNetworkManager.this.logger.log(Level.FINE, "Connect failed" + remote, t);
                }
                return null;
            }
        }

        private synchronized ConnectorHandler createHandlerUDP(final TargetTuple tt) throws IOException {
            final InetSocketAddress remote = tt.getSocketAddress();
            final UDPConnectorHandler connectorHandler = (UDPConnectorHandler)GrizzlyNetworkManager.this.udpClientController.acquireConnectorHandler(Controller.Protocol.UDP);
            ConnectorHandler cached = this.streams.putIfAbsent(tt, (ConnectorHandler)connectorHandler);
            if (cached != null) {
                return cached;
            }
            CallbackHandler<Context> callbackHandler = new CallbackHandler<Context>(){

                public void onConnect(IOEvent<Context> ioEvent) {
                    block6: {
                        SelectionKey key = ((Context)ioEvent.attachment()).getSelectionKey();
                        try {
                            connectorHandler.finishConnect(key);
                            GrizzlyNetworkManager.this.udpClientController.registerKey(key, 1, Controller.Protocol.UDP);
                            ArrayList bbs = (ArrayList)ConnectionManager.this.asyncWriteQueue.remove(connectorHandler);
                            if (bbs == null) break block6;
                            try {
                                Iterator i = bbs.iterator();
                                while (i.hasNext()) {
                                    ByteBuffer bb = (ByteBuffer)i.next();
                                    connectorHandler.write(bb, false);
                                    i.remove();
                                    bb.clear();
                                    byteBuffersPool.offer(bb);
                                }
                            }
                            catch (IOException ex) {
                                GrizzlyNetworkManager.this.logger.log(Level.WARNING, "Write failed", ex);
                            }
                        }
                        catch (IOException ex) {
                            if (GrizzlyNetworkManager.this.logger.isLoggable(Level.FINE)) {
                                GrizzlyNetworkManager.this.logger.log(Level.FINE, "Connect failed" + remote, ex);
                            }
                            ConnectionManager.this.streams.remove(tt);
                            GrizzlyNetworkManager.this.udpClientController.getSelectorHandler(Controller.Protocol.UDP).getSelectionKeyHandler().cancel(key);
                        }
                    }
                }

                public void onRead(IOEvent<Context> ioEvent) {
                    try {
                        Context ctx = (Context)ioEvent.attachment();
                        SelectionKey key = ctx.getSelectionKey();
                        if (!key.isValid()) {
                            ConnectionManager.this.streams.remove(tt);
                            return;
                        }
                        key.interestOps(key.interestOps() & 0xFFFFFFFE);
                        ctx.getProtocolChain().execute((Context)ioEvent.attachment());
                    }
                    catch (Throwable e) {
                        GrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Read failed: ", e);
                    }
                }

                public void onWrite(IOEvent<Context> ioEvent) {
                    throw new IllegalStateException("Should not end up here!");
                }
            };
            try {
                connectorHandler.connect((SocketAddress)remote, (CallbackHandler)callbackHandler);
                return connectorHandler;
            }
            catch (Throwable t) {
                if (GrizzlyNetworkManager.this.logger.isLoggable(Level.FINE)) {
                    GrizzlyNetworkManager.this.logger.log(Level.FINE, "Connect failed" + remote, t);
                }
                return null;
            }
        }
    }
}

