/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.container.HttpConnection;
import com.ericsson.ssa.container.HttpHost;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpConnectionPool {
    private static Logger log = Logger.getLogger("SipContainer");
    private static final int DEFAULT_NUM_CONNECTIONS = 2;
    private HttpHost host;
    private List<HttpConnection> allConnections;
    private BlockingQueue<HttpConnection> freeConnections;

    public HttpConnectionPool(HttpHost host) {
        this(host, 2);
    }

    public HttpConnectionPool(HttpHost host, int numConnections) {
        this(host, numConnections, -1);
    }

    public HttpConnectionPool(HttpHost host, int numConnections, int socketTimeout) {
        this.host = host;
        this.allConnections = new ArrayList<HttpConnection>();
        this.freeConnections = new LinkedBlockingQueue<HttpConnection>();
        this.createConnections(host, numConnections, socketTimeout);
    }

    public HttpConnection getConnection() {
        return this.getConnection(0);
    }

    public HttpConnection getConnection(int timeout) {
        while (true) {
            try {
                if (log.isLoggable(Level.FINE) && this.freeConnections.peek() == null) {
                    log.log(Level.FINE, "No connection is currently available. The current thread will block until another thread releases a connection.");
                }
                if (timeout > 0) {
                    return this.freeConnections.poll(timeout, TimeUnit.MILLISECONDS);
                }
                return this.freeConnections.take();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void releaseConnection(HttpConnection connection) throws IllegalArgumentException, IllegalStateException {
        if (!this.allConnections.contains(connection)) {
            throw new IllegalArgumentException("The connection cannot be releases since it is not managed by this pool.");
        }
        if (this.freeConnections.contains(connection)) {
            throw new IllegalStateException("The connection has already been released.");
        }
        this.freeConnections.offer(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IllegalStateException {
        try {
            if (this.freeConnections.size() < this.allConnections.size()) {
                throw new IllegalStateException("Some connections to host '" + this.host + "' are still active but will be closed anyway.");
            }
        }
        finally {
            for (HttpConnection connection : this.allConnections) {
                connection.close();
            }
            this.allConnections.clear();
            this.freeConnections.clear();
        }
    }

    private void createConnections(HttpHost host, int numConnections, int socketTimeout) {
        for (int i = 0; i < numConnections; ++i) {
            HttpConnection connection = socketTimeout < 0 ? new HttpConnection(host, this) : new HttpConnection(host, socketTimeout, this);
            this.allConnections.add(connection);
            this.freeConnections.add(connection);
        }
    }
}

