/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.container.HttpConnection;
import com.ericsson.ssa.container.HttpConnectionPool;
import com.ericsson.ssa.container.HttpFormData;
import com.ericsson.ssa.container.HttpHost;
import com.ericsson.ssa.container.HttpProxySettings;
import com.ericsson.ssa.container.MessageContent;
import com.ericsson.ssa.utils.ChunkedInputStream;
import com.ericsson.ssa.utils.ContentLengthInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteResponse;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProxy {
    private static final Logger log = Logger.getLogger("SipContainer");
    private static final String PROXY_REQUEST_BODY_NOTE = "ProxyRequestBody";
    private static final String EAS_HEADER_FRONTEND_IS_SECURE = "eas_schema";
    private static final String EAS_HEADER_FRONTEND_LOCAL_ADDRESS = "eas_localaddress";
    private static final String EAS_HEADER_FRONTEND_LOCAL_PORT = "eas_localport";
    private static HashMap<HttpHost, HttpConnectionPool> pools = new HashMap();
    private static HttpProxySettings settings;
    public static final ArrayList<String> droppedRequestHeaders;
    public static final ArrayList<String> droppedResponseHeaders;
    public static final Pattern statusLinePattern;

    private HttpProxy() {
    }

    public static void setProxySettings(HttpProxySettings settings) {
        HttpProxy.settings = settings;
    }

    public static void proxy(Request request, Response response, HttpHost host) throws IOException {
        HttpProxy.proxy(request, response, host, settings.getRetries());
    }

    /*
     * Exception decompiling
     */
    public static void proxy(Request request, Response response, HttpHost host, int retries) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void updateRequest(Request request) {
        CoyoteRequest cRequest = (CoyoteRequest)request;
        String exists = cRequest.getHeader(EAS_HEADER_FRONTEND_IS_SECURE);
        if (exists == null) {
            return;
        }
        org.apache.coyote.Request coyoteRequest = cRequest.getCoyoteRequest();
        MimeHeaders mimeHeaders = coyoteRequest.getMimeHeaders();
        String isSecure = cRequest.getHeader(EAS_HEADER_FRONTEND_IS_SECURE);
        String localAddress = cRequest.getHeader(EAS_HEADER_FRONTEND_LOCAL_ADDRESS);
        String localPort = cRequest.getHeader(EAS_HEADER_FRONTEND_LOCAL_PORT);
        mimeHeaders.removeHeader(EAS_HEADER_FRONTEND_IS_SECURE);
        mimeHeaders.removeHeader(EAS_HEADER_FRONTEND_LOCAL_ADDRESS);
        mimeHeaders.removeHeader(EAS_HEADER_FRONTEND_LOCAL_PORT);
        if ("true".equals(isSecure)) {
            request.setSecure(true);
            coyoteRequest.scheme().setBytes("https".getBytes(), 0, "https".length());
        }
        HttpProxy.setFieldValue(request, Integer.parseInt(localPort), "localPort");
        HttpProxy.setFieldValue(request, localAddress, "localAddr");
    }

    private static void setFieldValue(Object object, Object value, String fieldName) {
        try {
            Field f = HttpProxy.getPrivateField(object, fieldName);
            f.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getPrivateField(Object o, String fieldName) {
        Field[] fields = o.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fieldName.equals(fields[i].getName())) continue;
            fields[i].setAccessible(true);
            return fields[i];
        }
        throw new RuntimeException("Unable to lookup field=" + fieldName + " in object=" + o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        HashMap<HttpHost, HttpConnectionPool> hashMap = pools;
        synchronized (hashMap) {
            for (HttpConnectionPool pool : pools.values()) {
                try {
                    pool.shutdown();
                }
                catch (IllegalStateException e) {
                    log.log(Level.WARNING, "Problem when shutting down proxy connection pool: " + e.getMessage());
                }
            }
        }
    }

    private static void proxyInternal(HttpConnection connection, Request request, Response response, HttpHost host) throws IOException {
        HttpProxy.openConnection(connection);
        HttpProxy.proxyRequest(connection, request);
        int maxLoop = 3;
        do {
            HttpProxy.proxyResponse(connection, response);
        } while (--maxLoop > 0 && ((CoyoteResponse)response).getStatus() == 100);
    }

    private static HttpConnection getConnection(HttpHost host) {
        HttpConnectionPool pool = HttpProxy.getConnectionPool(host);
        return pool.getConnection(settings.getConnectionTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpConnectionPool getConnectionPool(HttpHost host) {
        HttpConnectionPool pool;
        HashMap<HttpHost, HttpConnectionPool> hashMap = pools;
        synchronized (hashMap) {
            pool = pools.get(host);
            if (pool == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Creating a new connection pool with " + settings.getPoolSize() + " connections to host '" + host + "'.");
                }
                pool = new HttpConnectionPool(host, settings.getPoolSize(), settings.getSocketTimeout());
                pools.put(host, pool);
            }
        }
        return pool;
    }

    private static void openConnection(HttpConnection connection) throws IOException {
        if (!connection.isOpen()) {
            connection.open();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "The connection was opened: " + connection);
            }
        } else if (connection.isStale()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "The connection to '" + connection.getHost() + "' appears to be stale. Reconnecting!");
            }
            connection.close();
            connection.open();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "The connection was reopened: " + connection);
            }
        }
    }

    private static void proxyRequest(HttpConnection connection, Request request) throws IOException {
        CoyoteRequest cRequest = (CoyoteRequest)request;
        String contentType = null;
        int contentLength = 0;
        connection.printLine(HttpProxy.createRequestLine(request));
        ArrayList<String> connectionToken = HttpProxy.checkConnectionsToken(cRequest.getHeader("Connection"));
        Enumeration hdrNames = cRequest.getHeaderNames();
        while (hdrNames.hasMoreElements()) {
            String headerName = (String)hdrNames.nextElement();
            String headerValue = cRequest.getHeader(headerName);
            if ("Content-Type".equalsIgnoreCase(headerName)) {
                contentType = headerValue;
            }
            if ("Content-Length".equalsIgnoreCase(headerName)) {
                contentLength = Integer.parseInt(headerValue);
            }
            if (droppedRequestHeaders.contains(headerName.toLowerCase()) || connectionToken != null && connectionToken.contains(headerName.toLowerCase())) continue;
            connection.printLine(headerName + ": " + headerValue);
        }
        HttpProxy.addEasHeaders(connection, request);
        MessageContent mc = (MessageContent)request.getNote(PROXY_REQUEST_BODY_NOTE);
        if (mc == null) {
            mc = new MessageContent(HttpProxy.getRequestInputStream(request, contentType, contentLength));
            request.setNote(PROXY_REQUEST_BODY_NOTE, (Object)mc);
        }
        if (mc.getContentLength() > 0) {
            connection.printLine("Content-Length: " + mc.getContentLength());
            connection.writeLine();
            if (mc.getContentLength() > 0) {
                connection.write(mc.getContentAsBytes(), 0, mc.getContentLength());
            }
        } else {
            connection.writeLine();
        }
        connection.flushOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void proxyResponse(HttpConnection connection, Response response) throws IOException {
        CoyoteResponse cResponse = (CoyoteResponse)response;
        boolean chunked = false;
        boolean forcedClose = false;
        int contentLength = -1;
        try {
            String header;
            int code = HttpProxy.setStatusCode(connection, response);
            if (code == 100) {
                cResponse.sendAcknowledgement();
                return;
            }
            MimeHeaders headers = cResponse.getCoyoteResponse().getMimeHeaders();
            while ((header = connection.readLine()) != null && header.trim().length() >= 1) {
                int colon = header.indexOf(":");
                if (colon < 0) continue;
                String hdr = header.substring(0, colon).trim();
                String val = new StringBuffer(header.substring(colon + 1).trim()).toString();
                if ("Content-Length".equalsIgnoreCase(hdr)) {
                    contentLength = Integer.parseInt(val);
                    response.getResponse().setContentLength(contentLength);
                }
                if ("Content-Type".equalsIgnoreCase(hdr)) {
                    response.getResponse().setContentType(val);
                }
                if ("Transfer-Encoding".equalsIgnoreCase(hdr) && "chunked".equalsIgnoreCase(val)) {
                    chunked = true;
                }
                if ("Connection".equalsIgnoreCase(hdr) && "close".equalsIgnoreCase(val)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Back-end wants to close this connection");
                    }
                    forcedClose = true;
                }
                if (droppedResponseHeaders.contains(hdr.toLowerCase()) || hdr == null || val == null) continue;
                MessageBytes mb = headers.addValue(hdr);
                mb.setString(val);
            }
            if (HttpProxy.isResponseWithBody(code)) {
                int length;
                ServletOutputStream os = response.getResponse().getOutputStream();
                InputStream is = connection.getInputStream();
                is = chunked ? new ChunkedInputStream(is) : new ContentLengthInputStream(is, contentLength);
                byte[] buffer = new byte[8192];
                while ((length = is.read(buffer)) > 0) {
                    os.write(buffer, 0, length);
                }
                os.flush();
            }
        }
        finally {
            if (forcedClose) {
                connection.close();
            }
        }
    }

    private static InputStream getRequestInputStream(Request request, String contentType, int contentLength) throws IOException {
        ContentLengthInputStream in;
        CoyoteRequest cRequest = (CoyoteRequest)request;
        if (contentType != null && contentType.toLowerCase().startsWith("application/x-www-form-urlencoded") && cRequest.getMethod().equalsIgnoreCase("POST")) {
            HttpFormData data = new HttpFormData(request);
            in = new ContentLengthInputStream(new ByteArrayInputStream(data.getData()), data.getLength());
        } else {
            in = new ContentLengthInputStream((InputStream)cRequest.getInputStream(), contentLength);
        }
        return in;
    }

    private static int setStatusCode(HttpConnection connection, Response response) throws IOException {
        CoyoteResponse cResponse = (CoyoteResponse)response;
        String statusLine = HttpProxy.readStatusLine(connection);
        try {
            Matcher matcher = statusLinePattern.matcher(statusLine);
            if (matcher.matches()) {
                int code = Integer.parseInt(matcher.group(1));
                String message = matcher.group(2);
                cResponse.getResponse().setStatus(code);
                cResponse.getCoyoteResponse().setMessage(message);
                return code;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        throw new IOException("Malformed response");
    }

    private static String readStatusLine(HttpConnection connection) throws IOException {
        String statusLine;
        do {
            if ((statusLine = connection.readLine()) != null) continue;
            throw new IOException("No response could be read.");
        } while (statusLine.trim().length() == 0);
        return statusLine;
    }

    private static boolean isResponseWithBody(int statusCode) {
        return (statusCode < 100 || statusCode > 199) && statusCode != 204 && statusCode != 304;
    }

    private static String createRequestLine(Request request) {
        CoyoteRequest cRequest = (CoyoteRequest)request;
        StringBuilder requestLine = new StringBuilder(cRequest.getMethod());
        requestLine.append(" ").append(cRequest.getRequestURI());
        if (cRequest.getQueryString() != null) {
            requestLine.append("?");
            requestLine.append(cRequest.getQueryString());
        }
        requestLine.append(" HTTP/1.1");
        return requestLine.toString();
    }

    private static void addEasHeaders(HttpConnection connection, Request request) throws IOException {
        CoyoteRequest cRequest = (CoyoteRequest)request;
        String contextValue = "clientip=" + cRequest.getRemoteAddr() + ",clientport=" + cRequest.getRemotePort() + ",serverip=" + cRequest.getLocalAddr() + ",serverport=" + cRequest.getLocalPort();
        connection.printLine("x-eas-usercentric-ipcontext: " + contextValue);
        connection.printLine("eas_schema: " + cRequest.isSecure());
        connection.printLine("eas_localaddress: " + cRequest.getLocalAddr());
        connection.printLine("eas_localport: " + cRequest.getLocalPort());
    }

    private static void sendInternalError(Request request, Response response, HttpHost host) throws IOException {
        CoyoteRequest cRequest = (CoyoteRequest)request;
        CoyoteResponse cResponse = (CoyoteResponse)response;
        if (!cResponse.isCommitted()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "The attempt to proxy '" + cRequest.getRequestURL() + "' to '" + host + "' failed. " + "Responding with 500 Internal Server Error.");
            }
            cResponse.sendError(500);
        }
    }

    protected static ArrayList<String> checkConnectionsToken(String connectionValue) {
        if (connectionValue == null) {
            return null;
        }
        if (!connectionValue.contains(",")) {
            ArrayList<String> al = new ArrayList<String>();
            al.add(connectionValue);
            return al;
        }
        ArrayList<String> connectionsTokens = new ArrayList<String>();
        if (connectionValue.contains(":") && connectionValue.toLowerCase().startsWith("connection:")) {
            int colon = connectionValue.indexOf(":");
            connectionValue = connectionValue.substring(colon + 1, connectionValue.length());
        }
        if (connectionValue.endsWith(";")) {
            connectionValue = connectionValue.substring(0, connectionValue.length() - 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(connectionValue, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            connectionsTokens.add(token.trim().toLowerCase());
        }
        return connectionsTokens;
    }

    static {
        droppedRequestHeaders = new ArrayList();
        droppedResponseHeaders = new ArrayList();
        droppedRequestHeaders.add("connection");
        droppedRequestHeaders.add("content-length");
        droppedResponseHeaders.add("connection");
        droppedResponseHeaders.add("transfer-encoding");
        droppedResponseHeaders.add("content-length");
        droppedResponseHeaders.add("content-type");
        droppedResponseHeaders.add("server");
        droppedResponseHeaders.add("date");
        statusLinePattern = Pattern.compile("HTTP/\\d+\\.\\d+ (\\d{3}) (.*)");
    }
}

