/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class MessageContent {
    private int bufferSize = 8192;
    private byte[] buffer = new byte[this.bufferSize];
    private int offset = 0;

    public MessageContent(InputStream is) throws IOException {
        this.parseMessageContent(is);
    }

    public void parseMessageContent(InputStream in) throws IOException {
        int len;
        int toRead = this.bufferSize;
        while ((len = in.read(this.buffer, this.offset, toRead)) >= 0) {
            toRead -= len;
            this.offset += len;
            if (this.offset < this.bufferSize) continue;
            this.bufferSize *= 2;
            byte[] newBuf = new byte[this.bufferSize];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.offset);
            this.buffer = newBuf;
            toRead = this.bufferSize - this.offset;
        }
    }

    public byte[] getContentAsBytes() {
        return this.buffer;
    }

    public String getContentAsString() {
        try {
            return new String(this.buffer, 0, this.offset, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public int getContentLength() {
        return this.offset;
    }
}

