/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.container.Link;
import com.ericsson.ssa.container.NetworkManager;
import com.ericsson.ssa.container.SipContainerThreadPool;
import com.ericsson.ssa.container.TCPLink;
import com.ericsson.ssa.container.TCPListener;
import com.ericsson.ssa.container.UDPListener;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.LayerHelper;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.dns.SipTransports;
import com.ericsson.ssa.sip.dns.TargetTuple;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OLDNetworkManager
extends NetworkManager
implements Runnable {
    private static OLDNetworkManager _singletonInstance = new OLDNetworkManager();
    protected Thread _activeThread = null;
    protected boolean _stopped = true;
    protected Selector _selector = null;
    private UDPListener _UDPListener = null;
    private TCPListener _TCPListener = null;
    private UDPListener _UDPSubsequentListener = null;
    private TCPListener _TCPSubsequentListener = null;
    private Logger _log = Logger.getLogger("SipContainer");
    private Layer _nextLayer = null;
    private SipContainerThreadPool _threadPool = SipContainerThreadPool.getInstance();
    private Dispatcher dispatcher = null;
    private int _threadPoolSize = 10;
    private Map<TargetTuple, Link> _activeConnections = new ConcurrentHashMap<TargetTuple, Link>(20);
    private Queue<Link> _registerConnections = new LinkedBlockingQueue<Link>();
    private List<Link> _acceptRegConnections = new ArrayList<Link>();
    private Object _acceptConnectionsLock = new Object();
    private Semaphore _sem = new Semaphore(0);
    private AtomicLong _EasInvalidSipMessages = new AtomicLong();
    private AtomicLong _EasReceivedSipRequests = new AtomicLong();
    private AtomicLong _EasReceivedSipResponses = new AtomicLong();
    private AtomicLong _EasSentSipRequests = new AtomicLong();
    private AtomicLong _EasSentSipResponses = new AtomicLong();
    private int _SipLinkTimeout = 10;
    private int _SipLinkTimeoutRetries = 25;
    private int _SipLinkMaxQueueLen = 50;
    private int _SipLinkWaitLockTimeout = 5000;
    private long _SipLinkAliveTimeout = 120L;
    private boolean _errorResponseEnabled = false;
    private Config _config = ConfigFactory.getConfig();

    void acquireSelectorSemaphore() {
        this._sem.acquireUninterruptibly();
    }

    void releaseSelectorSemaphore() {
        try {
            this._sem.release();
        }
        catch (Throwable fatal) {
            this._log.log(Level.SEVERE, "Unable to release semaphore of main read loop, restart server!", fatal);
        }
    }

    public void registerConnection(Link l) {
        this._registerConnections.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Link getActiveConnection(TargetTuple tt) throws IOException {
        if (tt == null || tt.getProtocol() == SipTransports.UDP_PROT) {
            return this._UDPListener;
        }
        Link link = this._activeConnections.get(tt);
        if (link == null) {
            Map<TargetTuple, Link> map = this._activeConnections;
            synchronized (map) {
                link = this._activeConnections.get(tt);
                if (link == null) {
                    link = new TCPLink(tt, this, this._nextLayer);
                    this.addActiveConnection(link);
                    if (this._log.isLoggable(Level.FINE)) {
                        this._log.log(Level.FINE, "No TCP connection, opening new to : " + link.getInfo());
                    }
                }
            }
            if (!link.isOpen()) {
                link.open();
            }
        } else {
            if (!link.isOpen()) {
                link.open();
            }
            if (this._log.isLoggable(Level.FINE)) {
                this._log.log(Level.FINE, "Reusing TCP connection to : " + link.getInfo());
            }
        }
        return link;
    }

    public void addActiveConnection(Link l) {
        Link replaced = this._activeConnections.put(l.getTargetTuple(), l);
        if (replaced != null && this._log.isLoggable(Level.INFO)) {
            this._log.log(Level.INFO, "Connected link already exist to destination: " + l.getInfo() + ".\n Connected links = " + this._activeConnections.size());
        }
        if (this._log.isLoggable(Level.FINE)) {
            this._log.log(Level.FINE, "Added connected link: " + l.getInfo() + ".\n Connected links = " + this._activeConnections.size());
        }
    }

    public Link removeActiveConnection(Link l) {
        Link toReturn = this._activeConnections.remove(l.getTargetTuple());
        if (toReturn != null) {
            if (this._log.isLoggable(Level.FINE)) {
                this._log.log(Level.FINE, "Removed connected link: " + l.getInfo() + ".\n Connected links = " + this._activeConnections.size());
            }
        } else if (this._log.isLoggable(Level.INFO)) {
            this._log.log(Level.INFO, "Connected link already removed: " + l.getInfo() + ".\n Connected links = " + this._activeConnections.size());
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAcceptedConnection(Link l) {
        Object object = this._acceptConnectionsLock;
        synchronized (object) {
            this._acceptRegConnections.add(l);
            if (this._log.isLoggable(Level.FINE)) {
                this._log.log(Level.FINE, "Added accepted link: " + l + ".\n Accepted links = " + this._acceptRegConnections.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAcceptedConnection(Link l) {
        Object object = this._acceptConnectionsLock;
        synchronized (object) {
            boolean isFound = this._acceptRegConnections.remove(l);
            if (isFound && this._log.isLoggable(Level.FINE)) {
                this._log.log(Level.FINE, "Removed accepted link: " + l + ".\n Accepted link = " + this._acceptRegConnections.size());
            }
        }
    }

    public Integer getThreadPoolSize() {
        return new Integer(this._threadPoolSize);
    }

    public void setThreadPoolSize(Integer threadPoolSize) {
        if (threadPoolSize > 0) {
            this._threadPoolSize = threadPoolSize;
        }
    }

    Selector getSelector() {
        return this._selector;
    }

    public void registerDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public synchronized void initialize() throws IOException {
        if (this.isRunning()) {
            throw new IOException("Network already running.");
        }
        this._threadPool.initialize(this._threadPoolSize);
        this.debugParameters();
    }

    public synchronized void start() throws Exception {
        if (this.isRunning()) {
            throw new IOException("Network already running.");
        }
        this._stopped = false;
        if (this._threadPool != null && this._threadPool.isShutdown()) {
            this._threadPool.initialize(this._threadPoolSize);
        }
        this._selector = Selector.open();
        this._UDPListener = new UDPListener(Integer.parseInt(this._config.get("SIP_PORT")), this, this._nextLayer);
        this._UDPListener.open();
        this._TCPListener = new TCPListener(Integer.parseInt(this._config.get("SIP_PORT")), this, this._nextLayer, true);
        this._TCPListener.open();
    }

    public synchronized void stop() throws IOException {
        if (this._stopped) {
            throw new IOException("Network is not running.");
        }
        this._stopped = true;
        this._selector.wakeup();
        while (this._activeThread != null) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException ie) {}
        }
        for (Link l : this._activeConnections.values()) {
            l.close();
        }
        this._activeConnections.clear();
        for (Link l : this._registerConnections) {
            l.close();
        }
        this._registerConnections.clear();
        this._TCPListener.close();
        this._UDPListener.close();
        this._selector.close();
        this._threadPool.shutdown();
    }

    public boolean isRunning() {
        return !this._stopped;
    }

    public void run() {
        Link newLink = null;
        while (!this._stopped) {
            try {
                if (this._selector.select() > 0) {
                    Iterator<SelectionKey> i = this._selector.selectedKeys().iterator();
                    while (i.hasNext()) {
                        SelectionKey key = i.next();
                        i.remove();
                        Link link = null;
                        if (!key.isValid()) {
                            if (this._log.isLoggable(Level.FINE)) {
                                this._log.log(Level.FINE, "Key is not valid " + key);
                            }
                            if (link == null || !link.isOpen()) continue;
                            link.close();
                            if (!this._log.isLoggable(Level.FINE)) continue;
                            this._log.log(Level.FINE, "Closing link = " + link.getInfo());
                            continue;
                        }
                        if (key.isAcceptable()) {
                            if (this._log.isLoggable(Level.FINE)) {
                                this._log.log(Level.FINE, "Key isAcceptable()" + key);
                            }
                            try {
                                link = (Link)key.attachment();
                                link.run();
                            }
                            catch (Exception e) {
                                key.cancel();
                                if (link == null) continue;
                                link.close();
                                this._log.log(Level.SEVERE, "Closing link = " + link.getInfo(), e);
                            }
                            continue;
                        }
                        if (key.isReadable()) {
                            if (this._log.isLoggable(Level.FINE)) {
                                this._log.log(Level.FINE, "Key isReadable()" + key);
                            }
                            try {
                                link = (Link)key.attachment();
                                link.markAsActive();
                                this.execute(link);
                                this.acquireSelectorSemaphore();
                            }
                            catch (Exception e) {
                                key.cancel();
                                if (link == null) continue;
                                link.close();
                                this._log.log(Level.SEVERE, "Closing link = " + link.getInfo(), e);
                            }
                            continue;
                        }
                        if (!key.isWritable() || !this._log.isLoggable(Level.FINE)) continue;
                        this._log.log(Level.FINE, "Key isWritable()" + key);
                    }
                }
                while ((newLink = this._registerConnections.poll()) != null) {
                    try {
                        SelectableChannel sc = newLink.getSelectableChannel();
                        if (!sc.isOpen()) continue;
                        if (this._log.isLoggable(Level.INFO)) {
                            this._log.log(Level.INFO, "Adding new open channel : " + newLink.getInfo() + ", current number of keys in selector = " + this._selector.keys().size());
                        }
                        sc.register(this._selector, 1, newLink);
                    }
                    catch (Exception e) {
                        this._log.log(Level.WARNING, "Failed to register link.", e);
                    }
                }
            }
            catch (IOException ioe) {
                this._log.log(Level.SEVERE, "", ioe);
            }
            catch (RuntimeException re) {
                this._log.log(Level.SEVERE, "", re);
            }
        }
    }

    public void execute(Runnable r) {
        this._threadPool.execute(r);
    }

    public void next(SipServletRequestImpl req) {
        req.pushTransactionDispatcher(this);
        req.pushApplicationDispatcher(this);
        LayerHelper.next(req, (Layer)this, this._nextLayer);
    }

    public void next(SipServletResponseImpl resp) {
        LayerHelper.next(resp, (Layer)this, this._nextLayer);
    }

    public void registerNext(Layer layer) {
        this._nextLayer = layer;
    }

    public void dispatch(SipServletRequestImpl req) {
        block5: {
            try {
                Link link = this.getActiveConnection(req.getRemote());
                if (link != null) {
                    link.dispatch(req);
                } else if (this._log.isLoggable(Level.INFO)) {
                    this._log.log(Level.INFO, "Failed to get link to + " + req.getRemote() + ", dropping request " + req.toString());
                }
            }
            catch (IOException ioe) {
                if (!this._log.isLoggable(Level.FINE)) break block5;
                this._log.log(Level.FINE, "" + req.getRemote(), ioe);
            }
        }
    }

    public void dispatch(SipServletResponseImpl resp) {
        block5: {
            try {
                Link link = this.getActiveConnection(resp.getRemote());
                if (link != null) {
                    link.dispatch(resp);
                } else if (this._log.isLoggable(Level.INFO)) {
                    this._log.log(Level.INFO, "Failed to get Link to + " + resp.getRemote() + ", dropping response " + resp.toString());
                }
            }
            catch (IOException ioe) {
                if (!this._log.isLoggable(Level.INFO)) break block5;
                this._log.log(Level.INFO, "" + resp.getRemote(), ioe);
            }
        }
    }

    public static OLDNetworkManager getInstance() {
        return _singletonInstance;
    }

    void incrEasInvalidSipMessages() {
        this._EasInvalidSipMessages.incrementAndGet();
    }

    void incrEasReceivedSipRequests() {
        this._EasReceivedSipRequests.incrementAndGet();
    }

    void incrEasReceivedSipResponses() {
        this._EasReceivedSipResponses.incrementAndGet();
    }

    void incrEasSentSipRequests() {
        this._EasSentSipRequests.incrementAndGet();
    }

    void incrEasSentSipResponses() {
        this._EasSentSipResponses.incrementAndGet();
    }

    public long getEasInvalidSipMessages() {
        return this._EasInvalidSipMessages.longValue();
    }

    public long getEasReceivedSipRequests() {
        return this._EasReceivedSipRequests.longValue();
    }

    public long getEasReceivedSipResponses() {
        return this._EasReceivedSipResponses.longValue();
    }

    public long getEasSentSipRequests() {
        return this._EasSentSipRequests.longValue();
    }

    public long getEasSentSipResponses() {
        return this._EasSentSipResponses.longValue();
    }

    public void setSipLinkTimeout(int timeout) {
        if (timeout > 0 && timeout <= 50) {
            this._SipLinkTimeout = timeout;
        } else {
            this._log.log(Level.WARNING, "Bad SipLinkTimeout = " + timeout + ", 0 < select <= 50 allowed");
        }
    }

    public int getSipLinkTimeout() {
        return this._SipLinkTimeout;
    }

    public long getSipLinkAliveTimeout() {
        return this._SipLinkAliveTimeout;
    }

    public void setSipLinkAliveTimeout(long timeout) {
        this._SipLinkAliveTimeout = timeout;
    }

    public void setSipLinkTimeoutRetries(int retries) {
        if (retries > 0 && retries <= 25) {
            this._SipLinkTimeoutRetries = retries;
        } else {
            this._log.log(Level.WARNING, "Bad SipLinkTimeoutRetries = " + retries + ", 0 < select <= 25 allowed");
        }
        this._SipLinkTimeoutRetries = retries;
    }

    public int getSipLinkTimeoutRetries() {
        return this._SipLinkTimeoutRetries;
    }

    public int getSipLinkMaxQueueLength() {
        return this._SipLinkMaxQueueLen;
    }

    public void setSipLinkMaxQueueLength(int length) {
        this._SipLinkMaxQueueLen = length;
    }

    public int getSipLinkWaitLockTimeout() {
        return this._SipLinkWaitLockTimeout;
    }

    public void setSipLinkWaitLockTimeout(int timeout) {
        this._SipLinkWaitLockTimeout = timeout;
    }

    private void debugParameters() {
        if (this._log.isLoggable(Level.FINE)) {
            this._log.log(Level.FINE, "sipLinkTimeout = " + this.getSipLinkTimeout());
        }
        if (this._log.isLoggable(Level.FINE)) {
            this._log.log(Level.FINE, "sipLinkTimeoutRetries = " + this.getSipLinkTimeoutRetries());
        }
        if (this._log.isLoggable(Level.FINE)) {
            this._log.log(Level.FINE, "sipLinkWaitLockTimeout = " + this.getSipLinkWaitLockTimeout());
        }
        if (this._log.isLoggable(Level.FINE)) {
            this._log.log(Level.FINE, "sipLinkMaxThreadQueueLength = " + this.getSipLinkMaxQueueLength());
        }
    }

    public Boolean isErrorResponseEnabled() {
        return this._errorResponseEnabled;
    }

    public void setErrorResponseEnabled(Boolean responseEnabled) {
        this._errorResponseEnabled = responseEnabled;
    }
}

