/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.container.OverloadManager;
import com.ericsson.ssa.fm.FmEventSender;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.LayerHelper;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.timer.ServletTimerImpl;
import com.ericsson.ssa.sip.timer.TimerServiceImpl;
import com.ericsson.util.os.OSUtil;
import com.ericsson.util.os.OSUtilFactory;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.TimerListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.coyote.tomcat5.CoyoteResponse;

public class OverloadProtectionManager
implements Layer,
TimerListener,
Valve {
    public static int IR_CPU_THRESHOLD = 70;
    public static int SR_CPU_THRESHOLD = 90;
    public static int MM_CPU_THRESHOLD = 99;
    public static int HTTP_CPU_THRESHOLD = 70;
    private static final Logger _log = Logger.getLogger("SipContainer");
    private static OverloadProtectionManager _singeltonInstance = new OverloadProtectionManager();
    private Layer _nextLayer = null;
    private Valve _nextValve = null;
    private ServletTimerImpl _timer = null;
    private boolean _overloadRegulationEnabled = false;
    private int _sampleRate = 2;
    private int _numberOfSamples = 2;
    private int _initialRequestCPUThreshold = IR_CPU_THRESHOLD;
    private int _subsequentRequestCPUThreshold = SR_CPU_THRESHOLD;
    private int _maxMessageCPUThreshold = MM_CPU_THRESHOLD;
    private int _httpCPUThreshold = HTTP_CPU_THRESHOLD;
    private final OSUtil _osUtil;
    private AtomicInteger _overloadDetectedInitialRequestCounter = new AtomicInteger(0);
    private AtomicInteger _overloadDetectedSubsequentRequestCounter = new AtomicInteger(0);
    private AtomicInteger _overloadDetectedMaxLevelCounter = new AtomicInteger(0);
    private AtomicInteger _overloadDetectedHttpCounter = new AtomicInteger(0);
    private boolean _alarmRaised = false;
    private String _hostName = "";
    private boolean started = false;

    private OverloadProtectionManager() {
        String allProcess = System.getProperty("AllProcess");
        if (allProcess == null) {
            allProcess = "true";
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "AllProcess is not set, will run default 'true'.");
            }
        }
        this._osUtil = OSUtilFactory.getOSUtil(allProcess);
        if (this._osUtil == null) {
            _log.log(Level.WARNING, "Overload detection failed to start.");
            this._overloadRegulationEnabled = false;
        }
    }

    public static OverloadProtectionManager getInstance() {
        return _singeltonInstance;
    }

    public void start() {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "Starting OverloadProtection");
        }
        if (this._overloadRegulationEnabled && this._osUtil != null && this._timer == null) {
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "Starting timer for CPU Load, SampleRate: " + this._sampleRate + " * 1000");
            }
            try {
                this._timer = TimerServiceImpl.getInstance().createTimer(this, (long)(this._sampleRate * 1000), false, null);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Caught exception when starting timer : " + e);
            }
        }
        this.started = true;
    }

    private boolean isOverloadDetectedInitialRequest() {
        return this._overloadDetectedInitialRequestCounter.get() >= this._numberOfSamples;
    }

    private boolean isOverloadDetectedSubsequentRequest() {
        return this._overloadDetectedSubsequentRequestCounter.get() >= this._numberOfSamples;
    }

    private boolean isOverloadDetectedHttpRequest() {
        return this._overloadDetectedHttpCounter.get() >= this._numberOfSamples;
    }

    private boolean isOverloadDetectedMaxLevel() {
        return this._overloadDetectedMaxLevelCounter.get() >= this._numberOfSamples;
    }

    private boolean isInitial(SipServletMessageImpl m) {
        try {
            return m.getAddressHeader("To").getParameter("tag") == null;
        }
        catch (ServletParseException e) {
            return true;
        }
    }

    public void next(SipServletRequestImpl req) {
        if (this._overloadRegulationEnabled) {
            if (!this.isOverloadDetectedMaxLevel()) {
                boolean initial = this.isInitial(req);
                if (initial) {
                    if (this.isOverloadDetectedInitialRequest()) {
                        SipServletResponseImpl resp = req.createTerminatingResponse(503);
                        if (_log.isLoggable(Level.FINE)) {
                            _log.log(Level.FINE, "Method next (req): initial request and isOverloadDetectedInitialRequest");
                            _log.log(Level.FINE, "Method next (req): Terminating response created (503)");
                        }
                        if (resp == null) {
                            return;
                        }
                        resp.setRemote(req.getRemote());
                        resp.popDispatcher().dispatch(resp);
                        this.incrEasOverloadRejectedSipResponses();
                        return;
                    }
                } else if (req.getMethod().equals("ACK")) {
                    if (this.isOverloadDetectedInitialRequest()) {
                        this.incrEasOverloadRejectedSipResponses();
                        return;
                    }
                } else if (this.isOverloadDetectedSubsequentRequest()) {
                    SipServletResponseImpl resp = req.createTerminatingResponse(503);
                    if (resp == null) {
                        return;
                    }
                    resp.setRemote(req.getRemote());
                    resp.popDispatcher().dispatch(resp);
                    this.incrEasOverloadRejectedSipResponses();
                    return;
                }
            } else {
                if (_log.isLoggable(Level.FINE)) {
                    _log.log(Level.FINE, "Max load, drop all sip requests");
                }
                this.incrEasOverloadRejectedSipResponses();
                return;
            }
        }
        LayerHelper.next(req, (Layer)this, this._nextLayer);
    }

    public void next(SipServletResponseImpl resp) {
        if (this._overloadRegulationEnabled && this.isOverloadDetectedMaxLevel()) {
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "Method next (resp): _overloadRegulationEnabled=true and isOverloadDetectedMaxLevel");
                _log.log(Level.FINE, "Max load, drop all sip responses");
            }
            return;
        }
        LayerHelper.next(resp, (Layer)this, this._nextLayer);
    }

    public void registerNext(Layer layer) {
        this._nextLayer = layer;
    }

    public void dispatch(SipServletRequestImpl req) {
        req.popDispatcher().dispatch(req);
    }

    public void dispatch(SipServletResponseImpl resp) {
        resp.peekDispatcher().dispatch(resp);
    }

    private void calculateThreshold(int cpuBusy, AtomicInteger levelCounter, Integer threshold) {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "calculateThreshold: cpuBusy=" + cpuBusy + " levelCounter=" + levelCounter.toString() + " threshold=" + threshold.toString());
        }
        if (cpuBusy >= threshold) {
            if (levelCounter.get() < this._numberOfSamples) {
                levelCounter.incrementAndGet();
            }
        } else {
            levelCounter.set(0);
        }
    }

    public void timeout(ServletTimer timer) {
        int busy = this.cpuBusy();
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "timeout - cpu: " + busy);
            _log.log(Level.FINE, "timeout - initialRequestCPUThreshold: " + this._initialRequestCPUThreshold);
            _log.log(Level.FINE, "timeout - overloadDetectedInitialRequestCounter: " + this._overloadDetectedInitialRequestCounter);
            _log.log(Level.FINE, "timeout - subsequentRequestCPUThreshold: " + this._subsequentRequestCPUThreshold);
            _log.log(Level.FINE, "timeout - overloadDetectedSubsequentRequestCounter: " + this._overloadDetectedSubsequentRequestCounter);
            _log.log(Level.FINE, "timeout - httpCPUThreshold: " + this._httpCPUThreshold);
            _log.log(Level.FINE, "timeout - overloadDetectedHttpCounter: " + this._overloadDetectedHttpCounter);
            _log.log(Level.FINE, "timeout - maxMessageCPUThreshold: " + this._maxMessageCPUThreshold);
            _log.log(Level.FINE, "timeout - overloadDetectedMaxLevelCounter: " + this._overloadDetectedMaxLevelCounter);
        }
        this.calculateThreshold(busy, this._overloadDetectedInitialRequestCounter, this._initialRequestCPUThreshold);
        this.calculateThreshold(busy, this._overloadDetectedSubsequentRequestCounter, this._subsequentRequestCPUThreshold);
        this.calculateThreshold(busy, this._overloadDetectedHttpCounter, this._httpCPUThreshold);
        this.calculateThreshold(busy, this._overloadDetectedMaxLevelCounter, this._maxMessageCPUThreshold);
        this.handleAlarm();
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, this.getClass().getName() + " - Restarting timer with _sampleRate: " + this._sampleRate + " * 1000");
        }
        this._timer = TimerServiceImpl.getInstance().createTimer(this, (long)(this._sampleRate * 1000), false, null);
    }

    private void handleAlarm() {
        if (this.isOverloadDetectedInitialRequest() || this.isOverloadDetectedSubsequentRequest() || this.isOverloadDetectedHttpRequest() || this.isOverloadDetectedMaxLevel()) {
            if (!this._alarmRaised) {
                if (_log.isLoggable(Level.INFO)) {
                    _log.log(Level.INFO, "The CPU overload limit is exceeded, will raise an alarm.");
                }
                this._alarmRaised = true;
                FmEventSender.raiseAlarmCpuLoadLimitExceeded(null);
            }
        } else if (this._alarmRaised) {
            if (_log.isLoggable(Level.INFO)) {
                _log.log(Level.INFO, "The CPU overload limit is below the threshold, will clear an alarm.");
            }
            FmEventSender.clearAlarmCpuLoadLimitExceeded();
            this._alarmRaised = false;
        }
    }

    private int cpuBusy() {
        return this._osUtil != null ? this._osUtil.cpuBusy() : 0;
    }

    public Integer getIrThreshold() {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "IrThreshold: " + this._initialRequestCPUThreshold);
        }
        return this._initialRequestCPUThreshold;
    }

    public void setIrThreshold(Integer threshold) {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "IrThreshold value will be set to " + threshold);
        }
        if (threshold >= 0 && threshold <= 100) {
            this._initialRequestCPUThreshold = threshold;
        }
    }

    public Integer getSrThreshold() {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "SrThreshold: " + this._subsequentRequestCPUThreshold);
        }
        return this._subsequentRequestCPUThreshold;
    }

    public void setSrThreshold(Integer threshold) {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "SrThreshold value will be set to " + threshold);
        }
        if (threshold >= 0 && threshold <= 100) {
            this._subsequentRequestCPUThreshold = threshold;
        }
    }

    public Integer getHttpThreshold() {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "HttpThreshold: " + this._httpCPUThreshold);
        }
        return this._httpCPUThreshold;
    }

    public void setHttpThreshold(Integer threshold) {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "HttpThreshold value will be set to " + threshold);
        }
        if (threshold >= 0 && threshold <= 100) {
            this._httpCPUThreshold = threshold;
        }
    }

    public Integer getMmThreshold() {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "MmThreshold: " + this._maxMessageCPUThreshold);
        }
        return this._maxMessageCPUThreshold;
    }

    public void setMmThreshold(Integer threshold) {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "MmThreshold value will be set to " + threshold);
        }
        if (threshold >= 0 && threshold <= 100) {
            this._maxMessageCPUThreshold = threshold;
        }
    }

    public Boolean getOverloadRegulation() {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "OverloadRegulation: " + this._overloadRegulationEnabled);
        }
        return this._overloadRegulationEnabled;
    }

    public void setOverloadRegulation(Boolean enabled) {
        if (this._overloadRegulationEnabled != enabled && this._osUtil != null) {
            if (enabled.booleanValue()) {
                if (_log.isLoggable(Level.INFO)) {
                    _log.log(Level.INFO, "OverloadRegulation was disabled, will be enabled");
                    _log.log(Level.INFO, "Starting timer for CPU Load, SampleRate: " + this._sampleRate + " * 1000");
                }
                try {
                    this._timer = TimerServiceImpl.getInstance().createTimer(this, (long)(this._sampleRate * 1000), false, null);
                    this._overloadRegulationEnabled = enabled;
                }
                catch (Exception e) {
                    if (this.started) {
                        _log.log(Level.SEVERE, "Caught exception when trying to start timer. Will re-try later.");
                    }
                }
            } else {
                if (_log.isLoggable(Level.INFO)) {
                    _log.log(Level.INFO, "OverloadRegulation was enabled, will be disabled");
                    _log.log(Level.INFO, "Cease alarm and stop OverloadRegulation timer");
                }
                if (this._alarmRaised) {
                    FmEventSender.clearAlarmCpuLoadLimitExceeded();
                    this._alarmRaised = false;
                }
                this._timer.cancel();
                this._timer = null;
                this._overloadRegulationEnabled = enabled;
            }
        }
    }

    public Integer getSampleRate() {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "SampleRate: " + this._sampleRate);
        }
        return this._sampleRate;
    }

    public void setSampleRate(Integer rate) {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "SampleRate value will be set to " + rate);
        }
        if (rate > 0) {
            this._sampleRate = rate;
        }
    }

    public Integer getNumberOfSamples() {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "NumberOfSamples: " + this._numberOfSamples);
        }
        return this._numberOfSamples;
    }

    public void setNumberOfSamples(Integer rate) {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "NumberOfSamples value will be set to " + rate);
        }
        this._numberOfSamples = rate < 2 ? 2 : rate;
    }

    public void backgroundProcess() {
    }

    public String getInfo() {
        return "Overload Regulation for SIP&HTTP";
    }

    public Valve getNext() {
        return this._nextValve;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        if (this._overloadRegulationEnabled) {
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "Method invoke: _overloadRegulationEnabled=true");
            }
            if (this.isOverloadDetectedMaxLevel()) {
                if (_log.isLoggable(Level.FINE)) {
                    _log.log(Level.FINE, "Method invoke: Max load, drop all http messages");
                }
                return 2;
            }
            if (this.isOverloadDetectedHttpRequest()) {
                if (_log.isLoggable(Level.FINE)) {
                    _log.log(Level.FINE, "Method invoke: isOverloadDetectedHttpRequest, return 503");
                }
                CoyoteResponse cResponse = (CoyoteResponse)response;
                cResponse.setStatus(503);
                ServletOutputStream out = cResponse.getOutputStream();
                out.flush();
                this.incrEasOverloadRejectedHttpResponses();
                return 2;
            }
        }
        if (this._nextValve == null) {
            _log.log(Level.SEVERE, "OverloadProtectionManager.invoke(Request,Response) method getNext() returned null, will throw ServletException.");
            throw new ServletException(OverloadProtectionManager.class.getName() + " getNext() return null.");
        }
        return 1;
    }

    public void postInvoke(Request request, Response response) throws IOException, ServletException {
    }

    public void setNext(Valve valve) {
        this._nextValve = valve;
    }

    void incrEasOverloadRejectedSipResponses() {
        OverloadManager.getInstance().incrEasOverloadRejectedSipResponses();
    }

    void incrEasOverloadRejectedHttpResponses() {
        OverloadManager.getInstance().incrEasOverloadRejectedHttpResponses();
    }
}

