/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.container.NetworkManager;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.LayerHelper;
import com.ericsson.ssa.sip.RemoteLayer;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SerialNetworkManager
implements Runnable,
Layer,
RemoteLayer {
    private static SerialNetworkManager _singeltonInstance = new SerialNetworkManager();
    private Logger _log = Logger.getLogger("SipContainer");
    private Layer _nextLayer = null;
    private ScheduledExecutorService _threadPool = null;
    protected boolean _stopped = true;
    private int _threadPoolSize = 10;

    private SerialNetworkManager() {
    }

    public static SerialNetworkManager getInstance() {
        return _singeltonInstance;
    }

    public synchronized void start() throws Exception {
        this._threadPool = Executors.newScheduledThreadPool(this._threadPoolSize);
        this._stopped = false;
    }

    public synchronized void stop() throws Exception {
        this._threadPool.shutdown();
        this._stopped = true;
    }

    public void run() {
        while (!this._stopped) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void next(SipServletRequestImpl req) {
        long startTime = 0L;
        long stopTime = 0L;
        if (this._log.isLoggable(Level.FINE)) {
            startTime = System.nanoTime();
        }
        if (req.peekDispatcher() != null) {
            req.pushTransactionDispatcher(this);
            req.pushApplicationDispatcher(this);
            LayerHelper.next(req, (Layer)this, this._nextLayer);
        } else {
            req.pushTransactionDispatcher(this);
            req.pushApplicationDispatcher(this);
            final SipServletRequestImpl r = req;
            final SerialNetworkManager l = this;
            this._threadPool.execute(new Runnable(){

                public void run() {
                    try {
                        LayerHelper.next(r, l, SerialNetworkManager.this._nextLayer);
                    }
                    catch (Exception e) {
                        SerialNetworkManager.this._log.log(Level.SEVERE, "", e);
                    }
                }
            });
        }
        if (this._log.isLoggable(Level.FINE)) {
            stopTime = System.nanoTime();
            this._log.log(Level.FINE, "Run of " + this.getClass().getName() + " took : " + (stopTime - startTime) / 1000L + " ms");
        }
    }

    public void next(SipServletResponseImpl resp) {
        if (resp.peekDispatcher() != null) {
            LayerHelper.next(resp, (Layer)this, this._nextLayer);
        } else {
            final SipServletResponseImpl r = resp;
            final SerialNetworkManager l = this;
            this._threadPool.execute(new Runnable(){

                public void run() {
                    LayerHelper.next(r, l, SerialNetworkManager.this._nextLayer);
                }
            });
        }
    }

    public void registerNext(Layer layer) {
        this._nextLayer = layer;
    }

    public void dispatch(SipServletRequestImpl req) {
        Dispatcher d = req.popDispatcher();
        while (d != null) {
            d = req.popDispatcher();
        }
        NetworkManager.getInstance().dispatch(req);
    }

    public void dispatch(SipServletResponseImpl resp) {
        Dispatcher d = resp.popDispatcher();
        while (d != null) {
            d = resp.popDispatcher();
        }
        NetworkManager.getInstance().dispatch(resp);
    }

    public void setThreadPoolSize(int threadPoolSize) {
        if (threadPoolSize > 0) {
            this._threadPoolSize = threadPoolSize;
        }
    }
}

