/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.PipelineFullException;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipContainerThreadPool {
    private static SipContainerThreadPool _singeltonInstance = new SipContainerThreadPool();
    private Pipeline grizzlyThreadPool;
    private ScheduledThreadPoolExecutor myThreadPool = null;
    private Logger _log = Logger.getLogger("SipContainer");

    public static SipContainerThreadPool getInstance() {
        return _singeltonInstance;
    }

    public boolean isShutdown() {
        if (this.myThreadPool == null) {
            return true;
        }
        return this.myThreadPool.isShutdown();
    }

    public void shutdown() {
        this.myThreadPool.shutdown();
    }

    public void initialize(int threadPoolSize) {
        this.myThreadPool = new ScheduledThreadPoolExecutor(threadPoolSize, new ThreadPoolExecutor.CallerRunsPolicy());
        this.myThreadPool.prestartAllCoreThreads();
    }

    public void initialize(Pipeline threadpool) {
        this.grizzlyThreadPool = threadpool;
        this.initialize(this.grizzlyThreadPool.getMaxThreads());
    }

    public void execute(Runnable r) {
        if (this.grizzlyThreadPool != null) {
            try {
                this.grizzlyThreadPool.execute((Object)new MyRunnable(r));
            }
            catch (PipelineFullException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.myThreadPool.execute(new MyRunnable(r));
        }
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.myThreadPool.schedule(new MyRunnable(command), delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.myThreadPool.scheduleAtFixedRate(new MyRunnable(command), initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.myThreadPool.scheduleWithFixedDelay(new MyRunnable(command), initialDelay, delay, unit);
    }

    public void purge() {
        this.myThreadPool.purge();
    }

    public Integer getThreadPoolSize() {
        if (this.grizzlyThreadPool != null) {
            return new Integer(this.grizzlyThreadPool.getCurrentThreadCount());
        }
        return new Integer(this.myThreadPool.getPoolSize());
    }

    private class MyRunnable
    implements Callable,
    Runnable {
        private Runnable myRunnable;

        MyRunnable(Runnable r) {
            this.myRunnable = r;
        }

        public Object call() throws Exception {
            try {
                this.myRunnable.run();
                SipServletMessageImpl.removeThreadLocalData();
            }
            catch (Throwable t) {
                SipContainerThreadPool.this._log.log(Level.SEVERE, "error while executing task:", t);
                throw new RuntimeException(t);
            }
            return null;
        }

        public void run() {
            try {
                this.myRunnable.run();
                SipServletMessageImpl.removeThreadLocalData();
            }
            catch (Throwable t) {
                SipContainerThreadPool.this._log.log(Level.SEVERE, "error while executing task:", t);
                throw new RuntimeException(t);
            }
        }
    }
}

