/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.container.OLDNetworkManager;
import com.ericsson.ssa.container.UDPListener;
import com.ericsson.ssa.container.startup.PerformanceMBeanListener;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.dns.SipTransports;
import com.ericsson.ssa.sip.dns.TargetTuple;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.logging.Level;

public class UDPBlockingListener
extends UDPListener {
    private Thread m_Thread = null;
    private Config _config = ConfigFactory.getConfig();

    public UDPBlockingListener(int port, OLDNetworkManager n, Layer l) {
        super(port, n, l);
    }

    public void open() throws IOException {
        this._dgramChannel = DatagramChannel.open();
        this._dgramChannel.configureBlocking(true);
        InetAddress ia = InetAddress.getByName(this._config.get("HOST"));
        InetSocketAddress local = new InetSocketAddress(ia, this._port);
        this._dgramChannel.socket().bind(local);
        this._readBuffer = ByteBuffer.allocate(65535);
        this._writeBuffer = ByteBuffer.allocate(65535);
        this.m_Thread = new Thread((Runnable)this, this.getClass().getName());
        this.m_Thread.start();
        this._networkManager.getSelector().wakeup();
    }

    protected void closeImpl() throws IOException {
        if (this.m_Thread != null) {
            this.m_Thread.interrupt();
        }
        if (this._dgramChannel != null) {
            this._dgramChannel.close();
            this._dgramChannel = null;
        }
    }

    public void run() {
        while (!Thread.interrupted()) {
            InetSocketAddress remote;
            block5: {
                remote = null;
                try {
                    remote = (InetSocketAddress)this._dgramChannel.receive(this._readBuffer);
                }
                catch (IOException ioe) {
                    if (!this._log.isLoggable(Level.FINE)) break block5;
                    this._log.log(Level.FINE, "", ioe);
                }
            }
            this._readBuffer.flip();
            if (this._readBuffer.hasRemaining()) {
                if (this._log.isLoggable(Level.FINE)) {
                    this._log.log(Level.FINE, "In Dgram :" + Thread.currentThread().getName());
                    this._log.log(Level.FINE, "Buffer = " + this._readBuffer.limit());
                }
                this.handleMessage(this._readBuffer, this.getLocal(), new TargetTuple(SipTransports.UDP_PROT, remote));
                continue;
            }
            if (!this._log.isLoggable(Level.FINE)) continue;
            this._log.log(Level.FINE, "Zero bytes in UDP ByteBuffer = " + this._readBuffer.limit());
        }
    }

    protected void handleMessage(ByteBuffer buffer, InetSocketAddress local, TargetTuple remote) {
        SipServletMessageImpl parsedMessage = null;
        try {
            int initialSize = 0;
            int remaining = buffer.remaining();
            while (remaining > 0 && initialSize != remaining) {
                initialSize = remaining;
                parsedMessage = this._parser.parseMessage(this._message, buffer, local, remote, null);
                remaining = buffer.remaining();
                if (parsedMessage != null && parsedMessage.isMessageComplete() && remaining > 0) {
                    final SipServletMessageImpl msg = parsedMessage;
                    parsedMessage = null;
                    this._threadPool.execute(new Runnable(){

                        public void run() {
                            UDPBlockingListener.this.processMessage(msg);
                        }
                    });
                }
                if (remaining <= 0 || initialSize == remaining) continue;
                this._message = parsedMessage;
                buffer.mark();
                buffer.compact();
                buffer.flip();
                if (!this._log.isLoggable(Level.FINE)) continue;
                this._log.log(Level.FINE, "Position = " + buffer.position() + " ,Remains = " + buffer.remaining());
            }
            if (parsedMessage == null) {
                if (this._log.isLoggable(Level.INFO)) {
                    this._log.log(Level.INFO, "The parsed request is null - not continuing!(" + buffer.position() + ')');
                }
                int p = buffer.limit();
                buffer.clear();
                buffer.position(p);
                this._message = null;
                if (PerformanceMBeanListener.isEnabled()) {
                    this._networkManager.incrEasInvalidSipMessages();
                }
                return;
            }
            if (!parsedMessage.isMessageComplete()) {
                if (this._log.isLoggable(Level.INFO)) {
                    this._log.log(Level.INFO, "The parsed request is not complete - not continuing! (" + buffer.position() + ')');
                }
                if (buffer.hasRemaining()) {
                    buffer.compact();
                } else {
                    buffer.clear();
                }
                this._message = parsedMessage;
                return;
            }
            buffer.clear();
            this._message = null;
        }
        catch (Exception e) {
            if (parsedMessage != null && parsedMessage.isMessageComplete() && parsedMessage instanceof SipServletRequestImpl) {
                try {
                    SipServletRequestImpl req = (SipServletRequestImpl)parsedMessage;
                    SipServletResponseImpl resp = req.createTerminatingResponse(500);
                    if (resp == null) {
                        return;
                    }
                    while (resp.popDispatcher() != null) {
                    }
                    this.dispatch(resp);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            if (this._log.isLoggable(Level.INFO)) {
                this._log.log(Level.INFO, "Exception processing request " + e.getMessage(), e);
            }
            if (PerformanceMBeanListener.isEnabled()) {
                this._networkManager.incrEasInvalidSipMessages();
            }
            return;
        }
        final SipServletMessageImpl sendParsedMessage = parsedMessage;
        this._threadPool.execute(new Runnable(){

            public void run() {
                UDPBlockingListener.this.processMessage(sendParsedMessage);
            }
        });
    }
}

