/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.container.Link;
import com.ericsson.ssa.container.LinkBase;
import com.ericsson.ssa.container.OLDNetworkManager;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.dns.SipTransports;
import com.ericsson.ssa.sip.dns.TargetTuple;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UDPListener
extends LinkBase
implements Link {
    protected static final String _transport = "UDP";
    protected static final int UDP_BUFFER_SIZE = 65535;
    protected Logger _log = Logger.getLogger("SipContainer");
    protected DatagramChannel _dgramChannel = null;
    protected int _port = -1;
    private Config _config = ConfigFactory.getConfig();

    public UDPListener(int port, OLDNetworkManager n, Layer l) {
        super(n, l);
        this._networkManager = n;
        this._port = port;
    }

    public String getTransport() {
        return _transport;
    }

    public TargetTuple getTargetTuple() {
        return null;
    }

    public boolean isOpen() {
        return this._dgramChannel != null ? this._dgramChannel.isOpen() : false;
    }

    public void open() throws IOException {
        this._dgramChannel = DatagramChannel.open();
        this._dgramChannel.configureBlocking(false);
        InetAddress ia = InetAddress.getByName(this._config.get("HOST"));
        InetSocketAddress local = new InetSocketAddress(ia, this._port);
        this._dgramChannel.socket().bind(local);
        this._dgramChannel.register(this._networkManager.getSelector(), 1, this);
        this._readBuffer = ByteBuffer.allocate(65535);
        this._writeBuffer = ByteBuffer.allocate(65535);
        this._networkManager.getSelector().wakeup();
        if (this._log.isLoggable(Level.FINE)) {
            this._log.log(Level.FINE, "Opening " + ia + ":" + this._port);
        }
    }

    protected void closeImpl() throws IOException {
        this._dgramChannel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this._readMutex.lock();
        InetSocketAddress remote = null;
        try {
            remote = (InetSocketAddress)this._dgramChannel.receive(this._readBuffer);
        }
        catch (IOException ioe) {
            if (this._log.isLoggable(Level.FINE)) {
                this._log.log(Level.FINE, "Caught IOException: ", ioe);
            }
            this._readMutex.unlock();
        }
        catch (Throwable t) {
            this._log.log(Level.SEVERE, "Caught Throwable: ", t);
            this._readMutex.unlock();
        }
        finally {
            this._networkManager.releaseSelectorSemaphore();
        }
        this._readBuffer.flip();
        if (this._readBuffer.hasRemaining()) {
            if (this._log.isLoggable(Level.FINE)) {
                this._log.log(Level.FINE, "In Dgram :" + Thread.currentThread().getName());
                this._log.log(Level.FINE, "Buffer = " + this._readBuffer.limit());
            }
            this.handleMessage(this._readBuffer, this.getLocal(), new TargetTuple(SipTransports.UDP_PROT, remote));
        } else {
            if (this._log.isLoggable(Level.FINE)) {
                this._log.log(Level.FINE, "Zero bytes in UDP ByteBuffer = " + this._readBuffer.limit());
            }
            this._readBuffer.clear();
            this._readMutex.unlock();
        }
    }

    public void write(InetSocketAddress remote, ByteBuffer message) throws IOException {
        while (message.hasRemaining()) {
            this._dgramChannel.send(message, remote);
        }
    }

    public InetSocketAddress getLocal() {
        return (InetSocketAddress)this._dgramChannel.socket().getLocalSocketAddress();
    }

    public InetSocketAddress getRemote() {
        return (InetSocketAddress)this._dgramChannel.socket().getRemoteSocketAddress();
    }

    public SelectableChannel getSelectableChannel() {
        return this._dgramChannel;
    }

    public String getInfo() {
        return this.getClass().getName();
    }
}

